/*
 * Decompiled with CFR 0.152.
 */
package com.dyrocraft.simplespawn;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleSpawn
extends JavaPlugin
implements Listener {
    public final Logger logger = Logger.getLogger("Minecraft");
    public static SimpleSpawn plugin;
    public Location spawn;

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.logger.info(String.valueOf(pdfFile.getVersion()) + "is Disabled");
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        this.logger.info("====================================");
        this.logger.info(String.valueOf(pdfFile.getFullName()) + " has been enabled");
        this.logger.info(String.valueOf(pdfFile.getDescription()) + "created by " + pdfFile.getAuthors());
        this.logger.info(pdfFile.getWebsite());
        this.logger.info("====================================");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (cmd.getName().equalsIgnoreCase("setspawn")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "You cannot use this command from console");
            } else if (!sender.hasPermission("simplespawn.setspawn")) {
                sender.sendMessage(ChatColor.RED + "Permission Denied to set Spawn location");
            } else if (args.length != 0) {
                sender.sendMessage(ChatColor.RED + "Usage: /setspawn");
            } else {
                Player player = (Player)sender;
                World world = player.getLocation().getWorld();
                double x = player.getLocation().getX();
                double y = player.getLocation().getY();
                double z = player.getLocation().getZ();
                float yaw = player.getLocation().getYaw();
                float pitch = player.getLocation().getPitch();
                FileConfiguration config = this.getConfig();
                config.set(".World", (Object)world.getName().toString());
                config.set(".X", (Object)x);
                config.set(".Y", (Object)y);
                config.set(".Z", (Object)z);
                config.set(".Yaw", (Object)Float.valueOf(yaw));
                config.set(".Pitch", (Object)Float.valueOf(pitch));
                this.saveConfig();
                world.setSpawnLocation((int)x, (int)y, (int)z);
                this.spawn = new Location(world, x, y, z, yaw, pitch);
                sender.sendMessage(ChatColor.GREEN + "Spawn point set");
            }
        }
        if (!cmd.getName().equalsIgnoreCase("spawn")) return true;
        if (args.length > 1) {
            sender.sendMessage(ChatColor.RED + "Usage: /spawn <player>");
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "You cannot use this command from console");
                return true;
            }
            if (!sender.hasPermission("simplespawn.spawn")) {
                sender.sendMessage(ChatColor.RED + "Permission Denied to spawn");
                return true;
            }
            ((Player)sender).teleport(this.spawn);
            return true;
        }
        if (args.length != 1) return true;
        if (!sender.hasPermission("simplespawn.spawn.other")) {
            sender.sendMessage(ChatColor.RED + "Permission Denied to spawn another user");
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            sender.sendMessage(ChatColor.RED + "Player not online!");
            return true;
        }
        target.teleport(this.spawn);
        return true;
    }

    public void setSpawn() {
        try {
            FileConfiguration config = this.getConfig();
            this.spawn = new Location(Bukkit.getWorld((String)config.getString(".World")), Double.parseDouble(config.getString(".X")), Double.parseDouble(config.getString(".Y")), Double.parseDouble(config.getString(".Z")), Float.parseFloat(config.getString(".Yaw")), Float.parseFloat(config.getString(".Pitch")));
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to load spawn location, reverting to default!");
            this.spawn = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
        }
    }
}

