/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons;

import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.CreateExplosion;
import at.pavlov.Cannons.config.Config;
import at.pavlov.Cannons.config.Projectile;
import at.pavlov.Cannons.config.UserMessages;
import at.pavlov.Cannons.dao.CannonData;
import at.pavlov.Cannons.utils.DelayedFireTask;
import at.pavlov.Cannons.utils.FireTaskWrapper;
import at.pavlov.Cannons.utils.FlyingProjectile;
import at.pavlov.Cannons.utils.InventoryManagement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class FireCannon {
    private Config config;
    private UserMessages userMessages;
    private InventoryManagement InvManage;
    private Cannons plugin;
    private CreateExplosion explosion;
    public LinkedList<FlyingProjectile> flying_projectiles = new LinkedList();

    public FireCannon(Cannons plugin, Config config, UserMessages userMessages, InventoryManagement invManage, CreateExplosion explosion) {
        this.plugin = plugin;
        this.config = config;
        this.userMessages = userMessages;
        this.InvManage = invManage;
        this.explosion = explosion;
    }

    public LinkedList<FlyingProjectile> getProjectiles() {
        return this.flying_projectiles;
    }

    public boolean displayPrepareFireMessage(CannonData cannon_loc, Player player) {
        if (player != null && this.config.flint_and_steel && player.getItemInHand().getType() != Material.FLINT_AND_STEEL) {
            player.sendMessage(this.userMessages.NoFlintAndSteel);
            return false;
        }
        if (cannon_loc.gunpowder <= 0) {
            if (player != null) {
                player.sendMessage(this.userMessages.NoSulphur);
            }
            return false;
        }
        if (cannon_loc.projectileID == Material.AIR.getId()) {
            if (player != null) {
                player.sendMessage(this.userMessages.NoProjectile);
            }
            return false;
        }
        if ((double)cannon_loc.LastFired + this.config.fireDelay * 1000.0 >= (double)System.currentTimeMillis()) {
            if (player != null) {
                player.sendMessage(this.userMessages.BarreltoHot);
            }
            return false;
        }
        return true;
    }

    public boolean prepare_fire(CannonData cannon_loc, Player player, Boolean deleteCharge) {
        if (!this.displayPrepareFireMessage(cannon_loc, player)) {
            return false;
        }
        if (player != null) {
            if (player.hasPermission("cannons.player.fire")) {
                player.sendMessage(this.userMessages.FireGun);
                this.delayedFire(cannon_loc, player, deleteCharge);
            } else if (player != null) {
                player.sendMessage(this.userMessages.ErrorPermFire);
            }
        } else {
            this.delayedFire(cannon_loc, player, deleteCharge);
        }
        return true;
    }

    private void delayedFire(CannonData cannon_loc, Player player, Boolean deleteCharge) {
        cannon_loc.LastFired = System.currentTimeMillis();
        Location torchLoc = cannon_loc.firingLocation.getBlock().getRelative(cannon_loc.face.getOppositeFace(), cannon_loc.barrel_length - 1).getRelative(BlockFace.UP, 1).getLocation().clone();
        torchLoc.setX(torchLoc.getX() + 0.5);
        torchLoc.setZ(torchLoc.getZ() + 0.5);
        torchLoc.getWorld().playEffect(torchLoc, Effect.SMOKE, (Object)BlockFace.UP);
        torchLoc.getWorld().playSound(torchLoc, Sound.FUSE, 1.0f, 1.0f);
        FireTaskWrapper fireTask = new FireTaskWrapper(cannon_loc, player, deleteCharge);
        Long delay = (long)this.config.ignitionDelay * 20L;
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new DelayedFireTask(fireTask){

            @Override
            public void run(Object object) {
                FireTaskWrapper fireTask = (FireTaskWrapper)object;
                FireCannon.this.fire(fireTask.cannon, fireTask.player, fireTask.deleteCharge);
            }
        }, delay.longValue());
    }

    private void fire(CannonData cannon, Player shooter, Boolean deleteCharge) {
        Projectile projectile = this.config.getProjectile(cannon.projectileID, cannon.projectileData);
        Block Block2 = cannon.firingLocation.getBlock();
        Location loc = Block2.getRelative(cannon.face).getLocation();
        World world = loc.getWorld();
        loc.setX(loc.getX() + 0.5);
        loc.setY(loc.getY() + 0.5);
        loc.setZ(loc.getZ() + 0.5);
        if (this.config.Muzzle_flash) {
            cannon.firingLocation.getWorld().createExplosion(Block2.getRelative(cannon.face, this.config.Muzzle_displ).getLocation(), 0.0f);
        }
        int max_projectiles = 1;
        if (projectile.canisterShot && !projectile.cannonball) {
            max_projectiles = projectile.amountCanisterShot;
        }
        if (!projectile.canisterShot && !projectile.cannonball) {
            max_projectiles = 0;
        }
        int i = 0;
        while (i < max_projectiles) {
            FlyingProjectile cannonball = new FlyingProjectile();
            cannonball.projectile = projectile;
            cannonball.snowball = (Snowball)world.spawn(loc, Snowball.class);
            cannonball.snowball.setFireTicks(100);
            cannonball.snowball.setTicksLived(2);
            if (i == 0 && this.config.confusesShooter > 0.0) {
                List living = cannonball.snowball.getNearbyEntities(10.0, 10.0, 10.0);
                Iterator iter = living.iterator();
                while (iter.hasNext()) {
                    boolean harmEntity = false;
                    Entity next = (Entity)iter.next();
                    if (next instanceof Player) {
                        Player player = (Player)next;
                        if (player.isOnline() && !this.CheckHelmet(player) && player.getGameMode() != GameMode.CREATIVE) {
                            harmEntity = true;
                        }
                    } else if (next instanceof LivingEntity) {
                        harmEntity = true;
                    }
                    if (!harmEntity) continue;
                    LivingEntity livingEntity = (LivingEntity)next;
                    livingEntity.damage(1);
                    livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, (int)this.config.confusesShooter * 20, 0));
                }
            }
            Vector vect = cannon.getFiringVector(this.config);
            cannonball.snowball.setVelocity(vect);
            if (shooter != null) {
                cannonball.snowball.setShooter((LivingEntity)shooter);
            }
            this.flying_projectiles.add(cannonball);
            if (cannonball.projectile.timefuse > 0.0 && !cannonball.projectile.canisterShot) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (!FireCannon.this.flying_projectiles.isEmpty()) {
                            Iterator iterator = FireCannon.this.flying_projectiles.iterator();
                            while (iterator.hasNext()) {
                                FlyingProjectile flying = (FlyingProjectile)iterator.next();
                                if (!((double)flying.snowball.getTicksLived() > flying.projectile.timefuse * 20.0) || !(flying.projectile.timefuse > 0.0)) continue;
                                FireCannon.this.explosion.create_explosion(flying);
                                flying.snowball.remove();
                                iterator.remove();
                            }
                        }
                    }
                }, (long)(cannonball.projectile.timefuse * 20.0));
            }
            ++i;
        }
        cannon.LastFired = System.currentTimeMillis();
        if (deleteCharge.booleanValue()) {
            cannon.gunpowder = 0;
            cannon.projectileID = Material.AIR.getId();
            cannon.updateCannonSigns();
        } else if (this.config.redstone_consumption && !this.InvManage.removeAmmoFromChests(cannon, cannon.gunpowder, cannon.projectileID, cannon.projectileData)) {
            cannon.gunpowder = 0;
            cannon.projectileID = Material.AIR.getId();
            cannon.updateCannonSigns();
        }
    }

    private boolean CheckHelmet(Player player) {
        ItemStack helmet = player.getInventory().getHelmet();
        return helmet != null;
    }

    public void deleteOldSnowballs() {
        Iterator flying = this.flying_projectiles.iterator();
        while (flying.hasNext()) {
            FlyingProjectile next = (FlyingProjectile)flying.next();
            if (next.snowball.getTicksLived() <= 10000) continue;
            next.snowball.remove();
            flying.remove();
        }
    }
}

