/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons.config;

import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class UserMessages {
    private FileConfiguration customLanguage = null;
    private File customLanguageFile = null;
    public String BarreltoHot;
    public String NoProjectile;
    public String NoSulphur;
    public String NoFlintAndSteel;
    public String MaximumGunpowderLoaded;
    public String ProjectileAlreadyLoaded;
    public String FireGun;
    public String enableAimingMode;
    public String disableAimingMode;
    public String settingCombinedAngle;
    public String settingVerticalAngleUp;
    public String settingVerticalAngleDown;
    public String settingHorizontalAngleRight;
    public String settingHorizontalAngleLeft;
    public String loadProjectile;
    public String loadGunpowder;
    public String twoTorches;
    public String tooManyGuns;
    public String cannonBuilt;
    public String cannonDestroyed;
    public String cannonsReseted;
    public String ErrorPermRestoneTorch;
    public String ErrorPermFire;
    public String ErrorPermLoad;
    public String ErrorPermAdjust;
    public String ErrorPermissionProjectile;
    public String HelpText;
    public String HelpBuild;
    public String HelpFire;
    public String HelpAdjust;
    private Config config;
    private Cannons plugin;

    public UserMessages(Cannons plugin, Config config) {
        this.config = config;
        this.plugin = plugin;
        this.loadLanguage("english");
    }

    public boolean loadLanguage(String language) {
        if (language.equalsIgnoreCase("english")) {
            this.loadEnglish();
        } else if (language.equalsIgnoreCase("german")) {
            this.loadGerman();
        } else if (language.equalsIgnoreCase("custom")) {
            this.loadCustom("CustomLanguage");
        } else {
            this.plugin.logSevere("Language not found. Loading english language.");
            this.loadEnglish();
            return false;
        }
        return true;
    }

    private void loadEnglish() {
        this.BarreltoHot = ChatColor.RED + "The Barrel is too hot and must cool down";
        this.NoProjectile = ChatColor.RED + "No Projectile loaded. Load something!";
        this.NoFlintAndSteel = ChatColor.RED + "You need Flint and Steel to fire";
        this.NoSulphur = ChatColor.RED + "No gunpowder. Please load the barrel with gunpowder.";
        this.MaximumGunpowderLoaded = ChatColor.YELLOW + "Maximum gunpowder of " + ChatColor.GOLD + "GUNPOWDER " + ChatColor.YELLOW + "already loaded. More will destroyed the barrel.";
        this.ProjectileAlreadyLoaded = ChatColor.YELLOW + "Projectile " + ChatColor.GOLD + "PROJECTILE " + ChatColor.YELLOW + "and " + ChatColor.GOLD + "GUNPOWDER " + ChatColor.YELLOW + "gunpowder already loaded. Fire the damn gun before you blow yourself up.";
        this.FireGun = ChatColor.YELLOW + "FIRE!";
        this.enableAimingMode = ChatColor.GREEN + "Entering aiming mode";
        this.disableAimingMode = ChatColor.GREEN + "Leaving aiming mode";
        this.settingCombinedAngle = ChatColor.YELLOW + "New angle " + ChatColor.GOLD + "HDEGREE\u00b0 " + ChatColor.YELLOW + "horizontal and " + ChatColor.GOLD + "VDEGREE\u00b0 " + ChatColor.YELLOW + "vertical";
        this.settingVerticalAngleUp = ChatColor.YELLOW + "Setting vertical angle to " + ChatColor.GOLD + "VDEGREE\u00b0";
        this.settingVerticalAngleDown = ChatColor.YELLOW + "Setting vertical angle to " + ChatColor.GOLD + "-VDEGREE\u00b0";
        this.settingHorizontalAngleRight = ChatColor.YELLOW + "Aiming " + ChatColor.GOLD + "HDEGREE\u00b0 " + ChatColor.YELLOW + "to the " + ChatColor.GOLD + "right";
        this.settingHorizontalAngleLeft = ChatColor.YELLOW + "Aiming " + ChatColor.GOLD + "HDEGREE\u00b0 " + ChatColor.YELLOW + "to the " + ChatColor.GOLD + "left";
        this.loadProjectile = ChatColor.YELLOW + "Projectile " + ChatColor.GOLD + "PROJECTILE " + ChatColor.YELLOW + "has been loaded. \nFire if ready.";
        this.loadGunpowder = ChatColor.GOLD + "GUNPOWDERkg " + ChatColor.YELLOW + "of gunpowder loaded.";
        this.twoTorches = ChatColor.RED + "You can't place two torches on one cannon";
        this.tooManyGuns = ChatColor.RED + "You cant build more than " + ChatColor.GOLD + "CANNONS gun(s)";
        this.cannonBuilt = ChatColor.GREEN + "You have created a cannon";
        this.cannonDestroyed = ChatColor.RED + "One of your cannons has been destroyed";
        this.cannonsReseted = ChatColor.GREEN + "All your cannons have been deleted from the database";
        this.ErrorPermRestoneTorch = ChatColor.RED + "You are not allowed to control cannons with Redstone";
        this.ErrorPermFire = ChatColor.RED + "You have no idea how to fire this cannon.";
        this.ErrorPermLoad = ChatColor.RED + "No permission to load this gun.";
        this.ErrorPermAdjust = ChatColor.RED + "You have no idea how to adjust this cannon.";
        this.ErrorPermissionProjectile = ChatColor.RED + "No permission for this projectile.";
        this.HelpText = "\n Cannons plugin \n " + ChatColor.RED + "/cannons build " + ChatColor.GREEN + " - How to build a cannon" + "\n " + ChatColor.RED + "/cannons fire " + ChatColor.GREEN + " - How to load and fire a cannon" + "\n " + ChatColor.RED + "/cannons adjust " + ChatColor.GREEN + " - A small guide aim with a cannon";
        this.HelpBuild = "\n How to build a cannon: \n To make the barrel place " + this.config.min_barrel_length + "-" + this.config.max_barrel_length + " " + this.config.CannonMaterialName + " Blocks in x or z direction.\n " + "Place a Button on each end of the barrel \n " + "Finish it by placing a torch on the first block of the barrel. \n " + "To check if the cannon works right click the torch and you will\nget a message.";
        this.HelpFire = "\n How to load and fire: \n 1) Load the barrel with Sulphur by right clicking a few times \nwith sulphur. \n 2) Right click with a projectile block (e.g. " + this.config.allowedProjectiles.get((int)0).name + ").\n " + "3) When you have done everthing right right click the torch.";
        this.HelpAdjust = "\n You missed the target? Learn now how to aim: \n Right clicking with empty hands will increase the angle. \n Shift + right click will decrease the angle. \n Clicking on the top of the barrel will change the vertical angle.\n Clicking on the side will change the horizontal angle.";
    }

    private void loadGerman() {
        this.BarreltoHot = ChatColor.RED + "Das Rohr ist zu heiss";
        this.NoProjectile = ChatColor.RED + "Kein Kanonkugel im Rohr. Lade einen Block!";
        this.NoSulphur = ChatColor.RED + "Kein Schwarzpuvler. Lade zuerst die Treibladung!";
        this.NoFlintAndSteel = ChatColor.RED + "Du brauchst ein Feuerzeug zum Feuern";
        this.MaximumGunpowderLoaded = ChatColor.YELLOW + "Du hast bereits " + ChatColor.GOLD + "GUNPOWDERkg " + ChatColor.YELLOW + "Schwarzpuvler geladen.";
        this.ProjectileAlreadyLoaded = ChatColor.YELLOW + "Es wurde bereits eine Kanonenkugel aus " + ChatColor.GOLD + "PROJECTILE " + ChatColor.YELLOW + "und " + ChatColor.GOLD + "GUNPOWDERkg " + ChatColor.YELLOW + "Pulver geladen.  \nFeuer die Kanone endlich ab!";
        this.FireGun = ChatColor.YELLOW + "FEUER!";
        this.enableAimingMode = ChatColor.GREEN + "Zielmodus aktiviert";
        this.disableAimingMode = ChatColor.RED + "Zielmodus deaktiviert";
        this.settingCombinedAngle = ChatColor.YELLOW + "Neuer Winkel " + ChatColor.GOLD + "HDEGREE\u00b0 " + ChatColor.YELLOW + "horizontal and " + ChatColor.GOLD + "VDEGREE\u00b0 " + ChatColor.YELLOW + "vertikal";
        this.settingVerticalAngleUp = ChatColor.YELLOW + "Neuer vertikaler Winkel " + ChatColor.GOLD + "VDEGREE\u00b0";
        this.settingVerticalAngleDown = ChatColor.YELLOW + "Neuer vertikaler Winkel " + ChatColor.GOLD + "-VDEGREE\u00b0";
        this.settingHorizontalAngleRight = ChatColor.YELLOW + "Justiere die Kanone " + ChatColor.GOLD + "HDEGREE\u00b0 " + ChatColor.YELLOW + "nach " + ChatColor.GOLD + "rechts";
        this.settingHorizontalAngleLeft = ChatColor.YELLOW + "Justiere die Kanone " + ChatColor.GOLD + "HDEGREE\u00b0 " + ChatColor.YELLOW + "nach " + ChatColor.GOLD + "links";
        this.loadProjectile = ChatColor.YELLOW + "Eine Kanonenkugel aus " + ChatColor.GOLD + "PROJECTILE " + ChatColor.YELLOW + "wurde geladen.";
        this.loadGunpowder = ChatColor.GOLD + "GUNPOWDERkg " + ChatColor.YELLOW + "Schwarzpuvler geladen";
        this.twoTorches = ChatColor.RED + "Zwei Fackeln an einer Kanone sind unm\u00f6glich.";
        this.tooManyGuns = ChatColor.RED + "Du darfst nicht mehr als " + ChatColor.GOLD + "CANNONS Kanone(n) " + ChatColor.YELLOW + "bauen.";
        this.cannonBuilt = ChatColor.GREEN + "Kanone wurde fertiggestellt";
        this.cannonDestroyed = ChatColor.RED + "Eine deiner Kanonen wurde zerst\u00f6rt";
        this.cannonsReseted = ChatColor.GREEN + "Alle deine Kanonen wurden aus der Datenbank gel\u00f6scht";
        this.ErrorPermRestoneTorch = ChatColor.RED + "Nicht gen\u00fcgend Rechte um eine Kanone mit Redstone zu steuern.";
        this.ErrorPermFire = ChatColor.RED + "Du weisst leider nicht wie man eine Kanonen abfeuert.";
        this.ErrorPermLoad = ChatColor.RED + "Du w\u00fcrdest dich beim Laden der Kanone nur verletzen.";
        this.ErrorPermAdjust = ChatColor.RED + "Das Zielen mit Kanonen liegt dir nicht im Blut.";
        this.ErrorPermissionProjectile = ChatColor.RED + "Keine Rechte f\u00fcr dieses Projektil.";
        this.HelpText = "\n Cannons Plugin \n" + ChatColor.RED + "/cannons build " + ChatColor.GREEN + " - Wie baue ich eine Kanone" + "\n " + ChatColor.RED + "/cannons fire " + ChatColor.GREEN + " - Wie lade und feuere ich?" + "\n " + ChatColor.RED + "/cannons adjust " + ChatColor.GREEN + " - Wie kann ich diese Kanone ausrichten?";
        this.HelpBuild = "\n Bauanleitung f\u00fcr Kanonen: \n F\u00fcr das Rohr platziere " + this.config.min_barrel_length + "-" + this.config.max_barrel_length + " " + this.config.CannonMaterialName + " Bl\u00f6cke in x oder z Richtung.\n " + "Damit die Kanone erkannt platziere einen Schalter an beiden Enden des Rohrs und eine Fackel auf dem ersten Block. \n " + "Wenn du die Fackel rechts anklickst und eine Meldung bekommst\n " + "ist alles richtig gebaut.";
        this.HelpFire = "\n Wie lade ich eine Kanone? Weiterlesen und mehr erfahren:\n 1) W\u00e4hle Scharzpuvlver aus und mache mehrere Rechtsklicks auf das Rohr.\n2) Ein Rechtsklick mit dem Projektil (z.B. " + this.config.allowedProjectiles.get((int)0).name + ") um die\n " + "Kanonenkugel zu laden. \n " + "3) Hast du alles richtig gemacht kannst du die Kanone mit\n" + "Rechtsklick auf die Fackel abfeuern.";
        this.HelpAdjust = "\n Ziel verfehlt? Lese und lerne wie man zielt: \n Ein Rechtsklick mit einer leeren Hand erh\u00f6ht den Winkel. \n Shift + Rechtsklick auf das Rohr verringert den Winkel.\n Klicke oben oder unten um den verticalen Winkel zu \u00e4ndern. \n Die Seiten des Rohrs ver\u00e4ndern den horizontalen Winkel.";
    }

    private void loadCustom(String filename) {
        this.reloadcustomLanguage(filename);
        this.customLanguage.options().copyDefaults(true);
        this.savecustomLanguage();
        this.BarreltoHot = this.getEntry("BarreltoHot");
        this.NoProjectile = this.getEntry("NoProjectile");
        this.NoSulphur = this.getEntry("NoSulphur");
        this.NoFlintAndSteel = this.getEntry("NoFlintAndSteel");
        this.MaximumGunpowderLoaded = this.getEntry("MaximumGunpowderLoaded");
        this.ProjectileAlreadyLoaded = this.getEntry("ProjectileAlreadyLoaded");
        this.FireGun = this.getEntry("FireGun");
        this.enableAimingMode = this.getEntry("enableAimingMode");
        this.disableAimingMode = this.getEntry("disableAimingMode");
        this.settingCombinedAngle = this.getEntry("settingCombinedAngle");
        this.settingVerticalAngleUp = this.getEntry("settingVerticalAngleUp");
        this.settingVerticalAngleDown = this.getEntry("settingVerticalAngleDown");
        this.settingHorizontalAngleRight = this.getEntry("settingHorizontalAngleRight");
        this.settingHorizontalAngleLeft = this.getEntry("settingHorizontalAngleLeft");
        this.loadProjectile = this.getEntry("loadProjectile");
        this.loadGunpowder = this.getEntry("loadGunpowder");
        this.twoTorches = this.getEntry("twoTorches");
        this.tooManyGuns = this.getEntry("tooManyGuns");
        this.cannonBuilt = this.getEntry("cannonBuilt");
        this.cannonDestroyed = this.getEntry("cannonDestroyed");
        this.ErrorPermRestoneTorch = this.getEntry("ErrorPermRestoneTorch");
        this.ErrorPermFire = this.getEntry("ErrorPermFire");
        this.ErrorPermLoad = this.getEntry("ErrorPermLoad");
        this.ErrorPermAdjust = this.getEntry("ErrorPermAdjust");
        this.HelpText = this.getEntry("HelpText");
        this.HelpBuild = this.getEntry("HelpBuild");
        this.HelpFire = this.getEntry("HelpFire");
        this.HelpAdjust = this.getEntry("HelpAdjust");
    }

    public String getEntry(String key) {
        String entry = this.customLanguage.getString(key);
        String replace = null;
        replace = "" + ChatColor.RED;
        entry = this.splitString(entry, "ChatColor.RED ", replace);
        entry = this.splitString(entry, "RED ", replace);
        replace = "" + ChatColor.GREEN;
        entry = this.splitString(entry, "ChatColor.GREEN ", replace);
        entry = this.splitString(entry, "GREEN ", replace);
        replace = "" + ChatColor.YELLOW;
        entry = this.splitString(entry, "ChatColor.YELLOW ", replace);
        entry = this.splitString(entry, "YELLOW ", replace);
        replace = "" + ChatColor.GOLD;
        entry = this.splitString(entry, "ChatColor.GOLD ", replace);
        entry = this.splitString(entry, "GOLD ", replace);
        replace = this.config.allowedProjectiles.get((int)0).name;
        entry = this.splitString(entry, "ALLOWED_PROJECTILE", replace);
        replace = "" + this.config.min_barrel_length;
        entry = this.splitString(entry, "MIN_BARREL_LENGTH", replace);
        replace = "" + this.config.max_barrel_length;
        entry = this.splitString(entry, "MAX_BARREL_LENGTH", replace);
        replace = this.config.CannonMaterialName;
        entry = this.splitString(entry, "CANNON_MATERIAL", replace);
        replace = "\n ";
        entry = this.splitString(entry, "NEWLINE ", replace);
        return entry;
    }

    public String splitString(String entry, String split, String replace) {
        if (entry == null) {
            this.plugin.logSevere("Wrong entry in the lanugagefile");
            return null;
        }
        String[] tempEntry = entry.split(split);
        if (tempEntry.length > 0) {
            int x = 1;
            while (x < tempEntry.length) {
                tempEntry[0] = String.valueOf(tempEntry[0]) + replace + tempEntry[x];
                ++x;
            }
            return tempEntry[0];
        }
        return null;
    }

    private void reloadcustomLanguage(String filename) {
        if (this.customLanguageFile == null) {
            this.customLanguageFile = new File(this.getDataFolder(), String.valueOf(filename) + ".yml");
        }
        this.customLanguage = YamlConfiguration.loadConfiguration((File)this.customLanguageFile);
        InputStream defConfigStream = this.plugin.getResource(String.valueOf(filename) + ".yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.customLanguage.setDefaults((Configuration)defConfig);
        }
    }

    private String getDataFolder() {
        return "plugins/Cannons/";
    }

    private void savecustomLanguage() {
        if (this.customLanguage == null || this.customLanguageFile == null) {
            return;
        }
        try {
            this.customLanguage.save(this.customLanguageFile);
        }
        catch (IOException ex) {
            this.plugin.logSevere("Could not save config to " + this.customLanguageFile);
        }
    }

    public String getMaximumGunpowderLoaded(int gunpowder) {
        return this.splitString(this.MaximumGunpowderLoaded, "GUNPOWDER", Integer.toString(gunpowder));
    }

    public String getProjectileAlreadyLoaded(int gunpowder, int projectileID) {
        String string = this.splitString(this.ProjectileAlreadyLoaded, "GUNPOWDER", Integer.toString(gunpowder));
        return this.splitString(string, "PROJECTILE", Material.getMaterial((int)projectileID).toString());
    }

    public String getSettingCombinedAngle(double horizontal_angle, double vertical_angle) {
        int hangle = (int)horizontal_angle;
        int vangle = (int)vertical_angle;
        String string = this.splitString(this.settingCombinedAngle, "HDEGREE", Integer.toString(hangle));
        return this.splitString(string, "VDEGREE", Integer.toString(vangle));
    }

    public String getSettingVerticalAngle(double vangle) {
        int angle = (int)vangle;
        if (angle >= 0) {
            return this.splitString(this.settingVerticalAngleUp, "VDEGREE", Integer.toString(angle));
        }
        return this.splitString(this.settingVerticalAngleDown, "VDEGREE", Integer.toString(-angle));
    }

    public String getSettingHorizontalAngle(double horizontal_angle) {
        int hori = (int)horizontal_angle;
        if (hori >= 0) {
            return this.splitString(this.settingHorizontalAngleRight, "HDEGREE", Integer.toString(hori));
        }
        return this.splitString(this.settingHorizontalAngleLeft, "HDEGREE", Integer.toString(-hori));
    }

    public String getloadProjectile(int projectileID) {
        return this.splitString(this.loadProjectile, "PROJECTILE", Material.getMaterial((int)projectileID).toString());
    }

    public String getloadGunpowder(int gunpowder) {
        return this.splitString(this.loadGunpowder, "GUNPOWDER", Integer.toString(gunpowder));
    }

    public String getTooManyGuns(int cannons) {
        return this.splitString(this.tooManyGuns, "CANNONS", Integer.toString(cannons));
    }
}

