/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons.dao;

import at.pavlov.Cannons.config.Config;
import at.pavlov.Cannons.config.Projectile;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CannonData {
    public int id;
    public String name;
    public Location firingLocation;
    public BlockFace face;
    public int barrel_length;
    public long LastFired;
    public int gunpowder;
    public int projectileID;
    public int projectileData;
    public double horizontal_angle;
    public double vertical_angle;
    public String owner;
    public int designId;
    public boolean isValid = true;
    public ArrayList<Location> CannonBlocks = new ArrayList();

    public void addBlock(Location loc) {
        this.CannonBlocks.add(loc);
    }

    public Vector getFiringVector(Config config) {
        Projectile proj = config.getProjectile(this.projectileID, this.projectileData);
        Vector vect = new Vector(1.0f, 0.0f, 0.0f);
        Random r = new Random();
        double shrinkFactor = Math.exp(-2.0 * ((double)this.barrel_length - (double)config.min_barrel_length) / (double)(config.max_barrel_length - config.min_barrel_length));
        double deviation = r.nextGaussian() * config.angle_deviation * shrinkFactor;
        if (proj.canisterShot) {
            deviation += r.nextGaussian() * proj.spreadCanisterShot;
        }
        double horizontal = Math.sin((this.horizontal_angle + deviation) * Math.PI / 180.0);
        deviation = r.nextGaussian() * config.angle_deviation * shrinkFactor;
        if (proj.canisterShot) {
            deviation += r.nextGaussian() * proj.spreadCanisterShot;
        }
        double vertical = Math.sin((this.vertical_angle + deviation) * Math.PI / 180.0);
        if (this.face == BlockFace.WEST) {
            vect = new Vector(-1.0, vertical, -horizontal);
        } else if (this.face == BlockFace.NORTH) {
            vect = new Vector(horizontal, vertical, -1.0);
        } else if (this.face == BlockFace.EAST) {
            vect = new Vector(1.0, vertical, horizontal);
        } else if (this.face == BlockFace.SOUTH) {
            vect = new Vector(-horizontal, vertical, 1.0);
        }
        double multi = proj.max_speed * (double)this.gunpowder / (double)config.max_gunpowder;
        if (multi < 0.1) {
            multi = 0.1;
        }
        return vect.multiply(multi);
    }

    public boolean isLoaded() {
        return this.projectileID != Material.AIR.getId();
    }

    private void dropCharge() {
        if (this.gunpowder > 0) {
            ItemStack powder = new ItemStack(Material.SULPHUR, this.gunpowder);
            this.firingLocation.getWorld().dropItemNaturally(this.firingLocation, powder);
        }
        if (this.projectileID > 0) {
            ItemStack projectile = new ItemStack(this.projectileID, 1, (short)this.projectileData);
            this.firingLocation.getWorld().dropItemNaturally(this.firingLocation, projectile);
        }
    }

    public void destroyCannon() {
        this.isValid = false;
        this.updateCannonSigns();
        this.dropCharge();
    }

    public void updateCannonSigns() {
        Block block = this.firingLocation.getBlock().getRelative(this.face.getOppositeFace(), this.barrel_length - 1);
        if (this.face == BlockFace.EAST || this.face == BlockFace.WEST) {
            this.updateSign(block.getRelative(BlockFace.NORTH));
            this.updateSign(block.getRelative(BlockFace.SOUTH));
        } else {
            this.updateSign(block.getRelative(BlockFace.WEST));
            this.updateSign(block.getRelative(BlockFace.EAST));
        }
    }

    private void updateSign(Block block) {
        if (block.getType() != Material.WALL_SIGN) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (this.isValid) {
            sign.setLine(0, this.getSignString(0));
            sign.setLine(1, this.getSignString(1));
            sign.setLine(2, this.getSignString(2));
            sign.setLine(3, this.getSignString(3));
        } else {
            sign.setLine(0, "cannon");
            sign.setLine(1, "damaged");
            sign.setLine(2, "");
            sign.setLine(3, "");
        }
        sign.update(true);
    }

    public String getSignString(int index) {
        switch (index) {
            case 0: {
                if (this.name == null) {
                    this.name = "missing Name";
                }
                return this.name;
            }
            case 1: {
                if (this.owner == null) {
                    this.owner = "missing Owner";
                }
                return this.owner;
            }
            case 2: {
                return "p: " + this.gunpowder + " c: " + this.projectileID + ":" + this.projectileData;
            }
            case 3: {
                return String.valueOf(this.horizontal_angle) + "/" + this.vertical_angle;
            }
        }
        return "missing";
    }

    public boolean isCannonEqualSign() {
        Block block = this.firingLocation.getBlock().getRelative(this.face.getOppositeFace(), this.barrel_length - 1);
        if (this.face == BlockFace.EAST || this.face == BlockFace.WEST) {
            return this.isCannonEqualThisSign(block.getRelative(BlockFace.NORTH)) && this.isCannonEqualThisSign(block.getRelative(BlockFace.SOUTH));
        }
        return this.isCannonEqualThisSign(block.getRelative(BlockFace.EAST)) && this.isCannonEqualThisSign(block.getRelative(BlockFace.WEST));
    }

    private boolean isCannonEqualThisSign(Block block) {
        if (block.getType() != Material.WALL_SIGN) {
            return true;
        }
        Sign sign = (Sign)block.getState();
        if (sign.getLine(0) == null || sign.getLine(1) == null) {
            return true;
        }
        return sign.getLine(0).equals(this.name) && sign.getLine(1).equals(this.owner);
    }

    private String getLineOfCannonSigns(int line) {
        Block block = this.firingLocation.getBlock().getRelative(this.face.getOppositeFace(), this.barrel_length - 1);
        String lineStr = null;
        if (this.face == BlockFace.EAST || this.face == BlockFace.WEST) {
            lineStr = this.getLineOfThisSign(block.getRelative(BlockFace.NORTH), line);
            if (lineStr != null) {
                return lineStr;
            }
            lineStr = this.getLineOfThisSign(block.getRelative(BlockFace.SOUTH), line);
            if (lineStr != null) {
                return lineStr;
            }
        } else {
            lineStr = this.getLineOfThisSign(block.getRelative(BlockFace.EAST), line);
            if (lineStr != null) {
                return lineStr;
            }
            lineStr = this.getLineOfThisSign(block.getRelative(BlockFace.WEST), line);
            if (lineStr != null) {
                return lineStr;
            }
        }
        return null;
    }

    private String getLineOfThisSign(Block block, int line) {
        if (block.getType() != Material.WALL_SIGN) {
            return null;
        }
        Sign sign = (Sign)block.getState();
        return sign.getLine(line);
    }

    public String getCannonNameFromSign() {
        return this.getLineOfCannonSigns(0);
    }

    public String getOwnerFromSign() {
        return this.getLineOfCannonSigns(1);
    }

    public int getGunpowderFromSign() {
        String[] str = this.getLineOfCannonSigns(2).split(" ");
        if (str.length >= 4) {
            return Integer.parseInt(str[1]);
        }
        return 0;
    }

    public int getProjectileIDFromSign() {
        String[] str = this.getLineOfCannonSigns(2).split(" ");
        if (str.length >= 4) {
            String[] str2 = str[3].split(":");
            if (str.length >= 2) {
                return Integer.parseInt(str2[0]);
            }
        }
        return 0;
    }

    public int getProjectileDataFromSign() {
        String[] str = this.getLineOfCannonSigns(2).split(" ");
        if (str.length >= 4) {
            String[] str2 = str[3].split(":");
            if (str.length >= 2) {
                return Integer.parseInt(str2[1]);
            }
        }
        return 0;
    }

    public double getHorizontalAngleFromSign() {
        String[] str = this.getLineOfCannonSigns(2).split("/");
        if (str.length >= 2) {
            return Double.parseDouble(str[0]);
        }
        return 0.0;
    }

    public double getVerticalAngleFromSign() {
        String[] str = this.getLineOfCannonSigns(2).split("/");
        if (str.length >= 2) {
            return Double.parseDouble(str[1]);
        }
        return 0.0;
    }
}

