/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons.dao;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.SQLitePlatform;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import com.avaje.ebeaninternal.server.lib.sql.TransactionIsolation;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MyDatabase {
    private JavaPlugin javaPlugin;
    private ClassLoader classLoader;
    private Level loggerLevel;
    private boolean usingSQLite;
    private ServerConfig serverConfig;
    private EbeanServer ebeanServer;

    public MyDatabase(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getClassLoader", new Class[0]);
            method.setAccessible(true);
            this.classLoader = (ClassLoader)method.invoke((Object)javaPlugin, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to retrieve the ClassLoader of the plugin using Reflection", ex);
        }
    }

    public void initializeDatabase(String driver, String url, String username, String password, String isolation, boolean logging, boolean rebuild) {
        try {
            try {
                this.disableDatabaseLogging(logging);
                this.prepareDatabase(driver, url, username, password, isolation);
                this.loadDatabase();
                this.installDatabase(rebuild);
            }
            catch (Exception ex) {
                throw new RuntimeException("An exception has occured while initializing the database", ex);
            }
        }
        finally {
            this.enableDatabaseLogging(logging);
        }
    }

    private void prepareDatabase(String driver, String url, String username, String password, String isolation) {
        DataSourceConfig ds = new DataSourceConfig();
        ds.setDriver(driver);
        ds.setUrl(this.replaceDatabaseString(url));
        ds.setUsername(username);
        ds.setPassword(password);
        ds.setIsolationLevel(TransactionIsolation.getLevel((String)isolation));
        ServerConfig sc = new ServerConfig();
        sc.setDefaultServer(false);
        sc.setRegister(false);
        sc.setName(ds.getUrl().replaceAll("[^a-zA-Z0-9]", ""));
        List<Class<?>> classes = this.getDatabaseClasses();
        if (classes.size() == 0) {
            throw new RuntimeException("Database has been enabled, but no classes are registered to it");
        }
        sc.setClasses(classes);
        if (ds.getDriver().equalsIgnoreCase("org.sqlite.JDBC")) {
            this.usingSQLite = true;
            sc.setDatabasePlatform((DatabasePlatform)new SQLitePlatform());
            sc.getDatabasePlatform().getDbDdlSyntax().setIdentity("");
        }
        this.prepareDatabaseAdditionalConfig(ds, sc);
        sc.setDataSourceConfig(ds);
        this.serverConfig = sc;
    }

    private void loadDatabase() {
        ClassLoader currentClassLoader = null;
        Field cacheField = null;
        boolean cacheValue = true;
        try {
            try {
                currentClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
                cacheField = URLConnection.class.getDeclaredField("defaultUseCaches");
                cacheField.setAccessible(true);
                cacheValue = cacheField.getBoolean(null);
                cacheField.setBoolean(null, false);
                this.ebeanServer = EbeanServerFactory.create((ServerConfig)this.serverConfig);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create a new instance of the EbeanServer", ex);
            }
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            try {
                if (cacheField != null) {
                    cacheField.setBoolean(null, cacheValue);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to revert the \"defaultUseCaches\"-field back to its original value, URLConnection-caching remains disabled.");
            }
        }
    }

    public void installDatabase(boolean rebuild) {
        DdlGenerator gen;
        block11: {
            boolean databaseExists = false;
            List<Class<?>> classes = this.getDatabaseClasses();
            int i = 0;
            while (i < classes.size()) {
                try {
                    this.ebeanServer.find(classes.get(i)).findRowCount();
                    databaseExists = true;
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            if (!rebuild && databaseExists) {
                return;
            }
            SpiEbeanServer serv = (SpiEbeanServer)this.ebeanServer;
            gen = serv.getDdlGenerator();
            try {
                this.beforeDropDatabase();
            }
            catch (Exception ex) {
                if (!databaseExists) break block11;
                throw new RuntimeException("An unexpected exception occured", ex);
            }
        }
        gen.runScript(true, gen.generateDropDdl());
        if (this.usingSQLite) {
            this.loadDatabase();
        }
        if (this.usingSQLite) {
            gen.runScript(false, this.validateCreateDDLSqlite(gen.generateCreateDdl()));
        } else {
            gen.runScript(false, gen.generateCreateDdl());
        }
        try {
            this.afterCreateDatabase();
        }
        catch (Exception ex) {
            throw new RuntimeException("An unexpected exception occured", ex);
        }
    }

    private String replaceDatabaseString(String input) {
        input = input.replaceAll("\\{DIR\\}", String.valueOf(this.javaPlugin.getDataFolder().getPath().replaceAll("\\\\", "/")) + "/");
        input = input.replaceAll("\\{NAME\\}", this.javaPlugin.getDescription().getName().replaceAll("[^\\w_-]", ""));
        return input;
    }

    private String validateCreateDDLSqlite(String oldScript) {
        try {
            String currentLine;
            BufferedReader scriptReader = new BufferedReader(new StringReader(oldScript));
            ArrayList<String> scriptLines = new ArrayList<String>();
            HashMap<String, Integer> foundTables = new HashMap<String, Integer>();
            String currentTable = null;
            int tableOffset = 0;
            while ((currentLine = scriptReader.readLine()) != null) {
                String[] alterTableLine;
                currentLine = currentLine.trim();
                scriptLines.add(currentLine.trim());
                if (currentLine.startsWith("create table")) {
                    currentTable = currentLine.split(" ", 4)[2];
                    foundTables.put(currentLine.split(" ", 3)[2], scriptLines.size() - 1);
                    continue;
                }
                if (currentLine.startsWith(";") && currentTable != null && !currentTable.equals("")) {
                    int index = scriptLines.size() - 1;
                    foundTables.put(currentTable, index);
                    String previousLine = (String)scriptLines.get(index - 1);
                    previousLine = previousLine.substring(0, previousLine.length() - 1);
                    scriptLines.set(index - 1, previousLine);
                    scriptLines.set(index, ");");
                    currentTable = null;
                    continue;
                }
                if (!currentLine.startsWith("alter table") || !(alterTableLine = currentLine.split(" ", 4))[3].startsWith("add constraint")) continue;
                String[] addConstraintLine = alterTableLine[3].split(" ", 4);
                if (addConstraintLine[3].startsWith("foreign key")) {
                    int tableLastLine = (Integer)foundTables.get(alterTableLine[2]) + tableOffset;
                    scriptLines.set(tableLastLine - 1, String.valueOf((String)scriptLines.get(tableLastLine - 1)) + ",");
                    String constraintLine = String.format("%s %s %s", addConstraintLine[1], addConstraintLine[2], addConstraintLine[3]);
                    scriptLines.add(tableLastLine, constraintLine.substring(0, constraintLine.length() - 1));
                    scriptLines.remove(scriptLines.size() - 1);
                    ++tableOffset;
                    continue;
                }
                throw new RuntimeException("Unsupported action encountered: ALTER TABLE using ADD CONSTRAINT with " + addConstraintLine[3]);
            }
            String newScript = "";
            for (String newLine : scriptLines) {
                newScript = String.valueOf(newScript) + newLine + "\n";
            }
            System.out.println(newScript);
            return newScript;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to validate the CreateDDL-script for SQLite", ex);
        }
    }

    private void disableDatabaseLogging(boolean logging) {
        if (logging) {
            return;
        }
        this.loggerLevel = Logger.getLogger("").getLevel();
        Logger.getLogger("").setLevel(Level.OFF);
    }

    private void enableDatabaseLogging(boolean logging) {
        if (logging) {
            return;
        }
        Logger.getLogger("").setLevel(this.loggerLevel);
    }

    protected List<Class<?>> getDatabaseClasses() {
        return new ArrayList();
    }

    protected void beforeDropDatabase() {
    }

    protected void afterCreateDatabase() {
    }

    protected void prepareDatabaseAdditionalConfig(DataSourceConfig dataSourceConfig, ServerConfig serverConfig) {
    }

    public EbeanServer getDatabase() {
        return this.ebeanServer;
    }
}

