/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons.utils;

import at.pavlov.Cannons.dao.CannonData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryManagement {
    public void TakeFromPlayerInventory(Player player, boolean inventory_take) {
        if (inventory_take) {
            int amount = player.getInventory().getItemInHand().getAmount();
            if (amount == 1) {
                player.getInventory().removeItem(new ItemStack[]{player.getInventory().getItemInHand()});
            } else {
                player.getInventory().getItemInHand().setAmount(amount - 1);
            }
        }
    }

    public boolean removeAmmoFromChests(CannonData cannon, int gunpowder, int projectileId, int projectileData) {
        ItemStack projectile = this.newItemStack(projectileId, projectileData, 1);
        ItemStack powder = this.newItemStack(Material.SULPHUR.getId(), 0, gunpowder);
        BlockFace face = cannon.face;
        Block block = cannon.firingLocation.getBlock().getRelative(face.getOppositeFace(), cannon.barrel_length - 1);
        return face == BlockFace.EAST || face == BlockFace.WEST ? this.removeAmmoFromChest(block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.SOUTH), powder, projectile) : this.removeAmmoFromChest(block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.WEST), powder, projectile);
    }

    private boolean removeAmmoFromChest(Block block1, Block block2, ItemStack gunpowder, ItemStack projectile) {
        ArrayList<Inventory> invlist = new ArrayList<Inventory>();
        invlist = this.getInventories(block1, invlist);
        if (!this.containsItemInChests(invlist = this.getInventories(block2, invlist), projectile)) {
            return false;
        }
        int startingAmount = gunpowder.getAmount();
        if ((gunpowder = this.removeItemInChests(invlist, gunpowder)).getAmount() > 0) {
            gunpowder.setAmount(startingAmount - gunpowder.getAmount());
            this.addItemInChests(invlist, gunpowder);
            return false;
        }
        this.removeItemInChests(invlist, projectile);
        return true;
    }

    private ItemStack removeItemInChests(ArrayList<Inventory> invlist, ItemStack item) {
        Iterator<Inventory> iter = invlist.iterator();
        while (iter.hasNext() && item.getAmount() > 0) {
            Inventory next = iter.next();
            item = this.remove(next, item);
        }
        return item;
    }

    private boolean containsItemInChests(ArrayList<Inventory> invlist, ItemStack item) {
        Iterator<Inventory> iter = invlist.iterator();
        while (iter.hasNext()) {
            if (!this.contains(iter.next(), item)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Inventory inv, ItemStack item) {
        if (inv == null) {
            return false;
        }
        ItemStack[] itemStackArray = inv.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack invItem = itemStackArray[n2];
            if (invItem != null && invItem.getTypeId() == item.getTypeId() && invItem.getData().getData() == item.getData().getData()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ItemStack remove(Inventory inv, ItemStack item) {
        if (inv == null || item == null) {
            return item;
        }
        HashMap itemMap = inv.removeItem(new ItemStack[]{item});
        if (itemMap.size() == 0) {
            item.setAmount(0);
            return item;
        }
        Iterator iterator = itemMap.values().iterator();
        if (iterator.hasNext()) {
            ItemStack newItem = (ItemStack)iterator.next();
            return newItem;
        }
        return item;
    }

    private boolean addItemInChests(ArrayList<Inventory> invlist, ItemStack item) {
        if (item == null || item.getAmount() == 0) {
            return true;
        }
        for (Inventory next : invlist) {
            int size = next.addItem(new ItemStack[]{item}).size();
            if (size != 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Inventory> getInventories(Block block, ArrayList<Inventory> list) {
        if (list == null) {
            list = new ArrayList();
        }
        if (block.getType() == Material.CHEST) {
            Chest chest = (Chest)block.getState();
            list.add(chest.getInventory());
            Chest other = this.attached(block);
            if (other != null) {
                list.add(other.getInventory());
            }
        }
        return list;
    }

    private Chest attached(Block block) {
        BlockFace[] FACES;
        BlockFace[] blockFaceArray = FACES = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
        int n = FACES.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace face = blockFaceArray[n2];
            Block other = block.getRelative(face);
            if (other.getType() == Material.CHEST) {
                return (Chest)other.getState();
            }
            ++n2;
        }
        return null;
    }

    private ItemStack newItemStack(int id, int data, int amount) {
        ItemStack item = new ItemStack(id, amount, (short)data);
        return item;
    }
}

