/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons;

import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.config.Config;
import at.pavlov.Cannons.config.UserMessages;
import at.pavlov.Cannons.dao.CannonData;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CalcAngle {
    Cannons plugin;
    UserMessages userMessages;
    Config config;
    HashMap<Player, CannonData> inAimingMode = new HashMap();

    public CalcAngle(Cannons plugin, UserMessages userMessages, Config config) {
        this.plugin = plugin;
        this.userMessages = userMessages;
        this.config = config;
        this.inAimingMode = new HashMap();
    }

    public void initAimingMode() {
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                CalcAngle.this.updateAimingMode();
            }
        }, 5L, 5L);
    }

    public void ChangeAngle(CannonData cannon_loc, Action action, BlockFace clickedFace, Player player) {
        if (action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            if (player.getItemInHand().getType() == Material.WATCH) {
                this.ToggleAimingMode(player, cannon_loc);
            } else {
                this.DisplayAngle(cannon_loc, action, clickedFace, player);
            }
        }
    }

    private void DisplayAngle(CannonData cannon_loc, Action action, BlockFace clickedFace, Player player) {
        gunAngles angles = new gunAngles(0.0, 0.0);
        boolean combine = false;
        boolean hasChanged = false;
        if (!player.hasPermission("cannons.player.adjust")) {
            player.sendMessage(this.userMessages.ErrorPermAdjust);
            return;
        }
        if (player.getItemInHand().getType() == Material.WATCH) {
            angles = this.CheckLookingDirection(cannon_loc, player.getLocation().getDirection());
            combine = true;
        } else {
            angles = this.CheckBlockFace(clickedFace, cannon_loc.face, player.isSneaking());
            combine = false;
        }
        if (Math.abs(angles.getHorizontal()) >= 1.0) {
            if (angles.getHorizontal() >= 0.0) {
                if (cannon_loc.horizontal_angle + this.config.angle_step <= this.config.max_h_angle) {
                    cannon_loc.horizontal_angle += this.config.angle_step;
                    hasChanged = true;
                    if (!combine) {
                        player.sendMessage(this.userMessages.getSettingHorizontalAngle(cannon_loc.horizontal_angle));
                    }
                }
            } else if (cannon_loc.horizontal_angle - this.config.angle_step >= this.config.min_h_angle) {
                cannon_loc.horizontal_angle -= this.config.angle_step;
                hasChanged = true;
                if (!combine) {
                    player.sendMessage(this.userMessages.getSettingHorizontalAngle(cannon_loc.horizontal_angle));
                }
            }
        }
        if (Math.abs(angles.getVertical()) >= 1.0) {
            if (angles.getVertical() >= 0.0) {
                if (cannon_loc.vertical_angle + this.config.angle_step <= this.config.max_v_angle) {
                    cannon_loc.vertical_angle += this.config.angle_step;
                    hasChanged = true;
                    if (!combine) {
                        player.sendMessage(this.userMessages.getSettingVerticalAngle(cannon_loc.vertical_angle));
                    }
                }
            } else if (cannon_loc.vertical_angle - this.config.angle_step >= this.config.min_v_angle) {
                cannon_loc.vertical_angle -= this.config.angle_step;
                hasChanged = true;
                if (!combine) {
                    player.sendMessage(this.userMessages.getSettingVerticalAngle(cannon_loc.vertical_angle));
                }
            }
        }
        if (combine && hasChanged) {
            player.sendMessage(this.userMessages.getSettingCombinedAngle(cannon_loc.horizontal_angle, cannon_loc.vertical_angle));
        }
    }

    private gunAngles CheckLookingDirection(CannonData cannon, Vector lookingDirection) {
        gunAngles returnValue = new gunAngles(0.0, 0.0);
        returnValue.setVertical((lookingDirection.getY() - Math.sin(cannon.vertical_angle * Math.PI / 180.0)) * 180.0 / Math.PI);
        if (cannon.face == BlockFace.NORTH) {
            returnValue.setHorizontal((-lookingDirection.getZ() - Math.sin(cannon.horizontal_angle * Math.PI / 180.0)) * 180.0 / Math.PI);
        } else if (cannon.face == BlockFace.EAST) {
            returnValue.setHorizontal((lookingDirection.getX() - Math.sin(cannon.horizontal_angle * Math.PI / 180.0)) * 180.0 / Math.PI);
        } else if (cannon.face == BlockFace.SOUTH) {
            returnValue.setHorizontal((lookingDirection.getZ() - Math.sin(cannon.horizontal_angle * Math.PI / 180.0)) * 180.0 / Math.PI);
        } else if (cannon.face == BlockFace.WEST) {
            returnValue.setHorizontal((-lookingDirection.getX() - Math.sin(cannon.horizontal_angle * Math.PI / 180.0)) * 180.0 / Math.PI);
        }
        return returnValue;
    }

    public gunAngles CheckBlockFace(BlockFace clickedFace, BlockFace cannonDirection, boolean isSneaking) {
        if (clickedFace.equals((Object)BlockFace.DOWN)) {
            if (isSneaking) {
                return new gunAngles(0.0, 1.0);
            }
            return new gunAngles(0.0, -1.0);
        }
        if (clickedFace.equals((Object)BlockFace.UP)) {
            if (isSneaking) {
                return new gunAngles(0.0, -1.0);
            }
            return new gunAngles(0.0, 1.0);
        }
        BlockFace rightFace = this.getRightBlockFace(cannonDirection);
        if (clickedFace.equals((Object)rightFace.getOppositeFace())) {
            if (isSneaking) {
                return new gunAngles(1.0, 0.0);
            }
            return new gunAngles(-1.0, 0.0);
        }
        if (clickedFace.equals((Object)rightFace)) {
            if (isSneaking) {
                return new gunAngles(-1.0, 0.0);
            }
            return new gunAngles(1.0, 0.0);
        }
        if (clickedFace.equals((Object)cannonDirection) || clickedFace.equals((Object)cannonDirection.getOppositeFace())) {
            if (isSneaking) {
                return new gunAngles(-1.0, 0.0);
            }
            return new gunAngles(1.0, 0.0);
        }
        return new gunAngles(0.0, 0.0);
    }

    private BlockFace getRightBlockFace(BlockFace face) {
        if (face == BlockFace.NORTH) {
            return BlockFace.EAST;
        }
        if (face == BlockFace.EAST) {
            return BlockFace.SOUTH;
        }
        if (face == BlockFace.SOUTH) {
            return BlockFace.WEST;
        }
        if (face == BlockFace.WEST) {
            return BlockFace.NORTH;
        }
        return BlockFace.UP;
    }

    public void PlayerMove(Player player) {
        if (this.inAimingMode.containsKey(player)) {
            CannonData cannon = this.inAimingMode.get(player);
            Location locCannon = cannon.firingLocation.getBlock().getRelative(cannon.face.getOppositeFace(), cannon.barrel_length).getLocation();
            if (player.getLocation().distance(locCannon) > 5.0) {
                this.disableAimingMode(player);
            }
        }
    }

    public void updateAimingMode() {
        for (Map.Entry<Player, CannonData> entry : this.inAimingMode.entrySet()) {
            Player player = entry.getKey();
            CannonData cannon = entry.getValue();
            if (player.getItemInHand().getType() == Material.WATCH && player.isOnline() && cannon.isValid) {
                this.DisplayAngle(cannon, null, null, player);
                continue;
            }
            this.disableAimingMode(player);
        }
    }

    public void ToggleAimingMode(Player player, CannonData cannon) {
        if (this.inAimingMode.containsKey(player)) {
            this.disableAimingMode(player);
        } else if (player.hasPermission("cannons.player.adjust")) {
            player.sendMessage(this.userMessages.enableAimingMode);
            this.inAimingMode.put(player, cannon);
        } else {
            player.sendMessage(this.userMessages.ErrorPermAdjust);
            return;
        }
    }

    public void disableAimingMode(Player player) {
        if (this.inAimingMode.containsKey(player)) {
            player.sendMessage(this.userMessages.disableAimingMode);
            this.inAimingMode.remove(player);
        }
    }

    private class gunAngles {
        private double horizontal;
        private double vertical;

        public gunAngles(double horizontal, double vertical) {
            this.setHorizontal(horizontal);
            this.setVertical(vertical);
        }

        public double getHorizontal() {
            return this.horizontal;
        }

        public void setHorizontal(double horizontal) {
            this.horizontal = horizontal;
        }

        public double getVertical() {
            return this.vertical;
        }

        public void setVertical(double vertical) {
            this.vertical = vertical;
        }
    }
}

