/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons;

import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.config.Config;
import at.pavlov.Cannons.config.UserMessages;
import at.pavlov.Cannons.dao.CannonData;
import at.pavlov.Cannons.utils.BlockHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.material.Button;
import org.bukkit.material.Torch;

public class CannonManager {
    private ArrayList<CannonData> CannonList = new ArrayList();
    private Cannons plugin;
    private UserMessages message;
    private Config config;

    public CannonManager(Cannons cannons, UserMessages userMessages, Config config) {
        this.message = userMessages;
        this.config = config;
        this.plugin = cannons;
    }

    public void removeCannon(Location loc) {
        CannonData cannon = this.getCannon(loc);
        this.removeCannon(cannon);
    }

    public void removeCannon(CannonData cannon) {
        if (cannon != null) {
            Player player = Bukkit.getPlayer((String)cannon.owner);
            if (player != null) {
                player.sendMessage(this.message.cannonDestroyed);
            }
            cannon.destroyCannon();
            this.CannonList.remove(cannon);
        }
    }

    private boolean isCannonNameUnique(String name, String owner) {
        for (CannonData cannon : this.CannonList) {
            if (cannon.name == null || name == null || !cannon.name.equals(name)) continue;
            return false;
        }
        return true;
    }

    private String newCannonName(String owner) {
        String[] nameList = new String[]{"Cannon"};
        Random r = new Random();
        String pre = nameList[r.nextInt(nameList.length)];
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String cannonName = String.valueOf(pre) + " " + i;
            if (this.isCannonNameUnique(cannonName, owner)) {
                return cannonName;
            }
            ++i;
        }
        return "no unique name";
    }

    private void createCannon(CannonData cannon, Player player) {
        this.CannonList.add(cannon);
        if (player != null) {
            player.sendMessage(this.message.cannonBuilt);
        }
    }

    public CannonData getCannonFromStorage(String cannonName, String owner) {
        if (cannonName == null || owner == null) {
            return null;
        }
        for (CannonData cannon : this.CannonList) {
            if (!cannonName.equals(cannon.name) || !owner.equals(cannon.owner)) continue;
            return cannon;
        }
        return null;
    }

    private CannonData getCannonFromStorage(Location loc) {
        for (CannonData cannon : this.CannonList) {
            for (Location cannonBlock : cannon.CannonBlocks) {
                if (!cannonBlock.equals((Object)loc)) continue;
                return cannon;
            }
        }
        return null;
    }

    public CannonData getCannon(Location loc) {
        return this.getCannon(loc, null);
    }

    public CannonData getCannon(Location cannonBlock, Player player) {
        CannonData cannon = this.getCannonFromStorage(cannonBlock);
        if (cannon != null) {
            CannonData CannonFromSign = this.getCannonFromStorage(cannon.getCannonNameFromSign(), cannon.getOwnerFromSign());
            if (CannonFromSign == null || cannon.isCannonEqualSign()) {
                return cannon;
            }
            return CannonFromSign;
        }
        CannonAttribute attribute = this.check_Cannon(cannonBlock, player);
        if (attribute.find) {
            return this.addCannon(attribute, player);
        }
        return null;
    }

    public boolean isCannonBlock(Location loc) {
        return this.getCannon(loc) != null;
    }

    public int getCannonAmount(Player player) {
        int i = 1;
        for (CannonData cannon : this.CannonList) {
            if (!cannon.owner.equalsIgnoreCase(player.getName())) continue;
            ++i;
        }
        return i;
    }

    public List<CannonData> getCannonList() {
        return this.CannonList;
    }

    public int getCannonListSize() {
        return this.CannonList.size();
    }

    private boolean CheckCannonsAmount(Player player) {
        if (player == null) {
            return true;
        }
        int newBuildLimit = this.getBuildLimit(player);
        int i = this.getCannonAmount(player);
        if (newBuildLimit == -1) {
            if (player.hasPermission("cannons.player.limitB") && i > this.config.cannonLimitB) {
                player.sendMessage(this.message.getTooManyGuns(this.config.cannonLimitB));
                return false;
            }
            if (!player.hasPermission("cannons.player.limitB") && player.hasPermission("cannons.player.limitA") && i > this.config.cannonLimitA) {
                player.sendMessage(this.message.getTooManyGuns(this.config.cannonLimitA));
                return false;
            }
            return true;
        }
        if (i > newBuildLimit) {
            player.sendMessage(this.message.getTooManyGuns(newBuildLimit));
            return false;
        }
        return true;
    }

    private int getBuildLimit(Player player) {
        if (player.hasPermission("cannons.player.limit.2147483647")) {
            return Integer.MAX_VALUE;
        }
        int i = 100;
        while (i > 0) {
            if (player.hasPermission("cannons.player.limit." + i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private CannonData addCannonBlocks(CannonData cannon) {
        if (cannon == null) {
            return null;
        }
        Block block = cannon.firingLocation.getBlock();
        BlockFace reverse = cannon.face.getOppositeFace();
        Location loc = block.getRelative(cannon.face).getLocation();
        cannon.addBlock(loc);
        loc = block.getLocation();
        cannon.addBlock(loc);
        int length = 1;
        do {
            block = block.getRelative(reverse, 1);
            loc = block.getLocation();
            cannon.addBlock(loc);
        } while (++length < cannon.barrel_length + 1);
        block = block.getRelative(cannon.face, 1);
        loc = block.getRelative(BlockFace.UP).getLocation();
        cannon.addBlock(loc);
        return cannon;
    }

    private CannonData addCannon(CannonAttribute att_cannon, Player player) {
        boolean create = true;
        if (this.config.enableLimits) {
            create = this.CheckCannonsAmount(player);
        }
        if (create) {
            CannonData new_cannon = new CannonData();
            if (player != null) {
                new_cannon.owner = player.getName();
                new_cannon.name = this.newCannonName(new_cannon.owner);
            }
            new_cannon.firingLocation = att_cannon.barrel;
            new_cannon.face = att_cannon.face;
            new_cannon.barrel_length = att_cannon.barrel_length;
            CannonData old_cannon = this.getCannonFromStorage(new_cannon.getCannonNameFromSign(), new_cannon.getOwnerFromSign());
            if (old_cannon != null) {
                old_cannon.firingLocation = new_cannon.firingLocation;
                old_cannon.face = new_cannon.face;
                old_cannon.CannonBlocks.clear();
                old_cannon = this.addCannonBlocks(old_cannon);
                old_cannon.updateCannonSigns();
                return old_cannon;
            }
            new_cannon.LastFired = 0L;
            new_cannon.gunpowder = 0;
            new_cannon.projectileID = Material.AIR.getId();
            new_cannon.projectileData = 0;
            new_cannon.horizontal_angle = 0.0;
            new_cannon.vertical_angle = 0.0;
            new_cannon.designId = 0;
            new_cannon.isValid = true;
            new_cannon = this.addCannonBlocks(new_cannon);
            this.createCannon(new_cannon, player);
            new_cannon.updateCannonSigns();
            return new_cannon;
        }
        return null;
    }

    private CannonAttribute check_Cannon(Location barrel, Player player) {
        boolean find_cannon = false;
        Block block = barrel.getBlock();
        BlockFace face = BlockFace.SELF;
        if (block.getType() == Material.TORCH) {
            Torch torch = (Torch)block.getState().getData();
            block = block.getRelative(torch.getAttachedFace());
        } else if (block.getType() == Material.STONE_BUTTON) {
            Button button = (Button)block.getState().getData();
            block = block.getRelative(button.getAttachedFace());
        }
        boolean redo = false;
        int length = 0;
        int length_plus = 0;
        int length_minus = 0;
        if (BlockHelper.hasIdData(block, this.config.CannonMaterialId, this.config.CannonMaterialData)) {
            do {
                face = BlockHelper.hasIdData(block.getRelative(BlockFace.EAST), this.config.CannonMaterialId, this.config.CannonMaterialData) && !redo ? BlockFace.EAST : (BlockHelper.hasIdData(block.getRelative(BlockFace.WEST), this.config.CannonMaterialId, this.config.CannonMaterialData) && !redo ? BlockFace.WEST : (BlockHelper.hasIdData(block.getRelative(BlockFace.SOUTH), this.config.CannonMaterialId, this.config.CannonMaterialData) ? BlockFace.SOUTH : (BlockHelper.hasIdData(block.getRelative(BlockFace.NORTH), this.config.CannonMaterialId, this.config.CannonMaterialData) ? BlockFace.NORTH : BlockFace.NORTH)));
                while (BlockHelper.hasIdData(block.getRelative(face, ++length_plus), this.config.CannonMaterialId, this.config.CannonMaterialData) && length_plus < this.config.max_barrel_length) {
                }
                while (BlockHelper.hasIdData(block.getRelative(face.getOppositeFace(), ++length_minus), this.config.CannonMaterialId, this.config.CannonMaterialData) && length_minus < this.config.max_barrel_length) {
                }
                if (BlockHelper.CheckAttachedButton(block.getRelative(face.getOppositeFace(), length_minus - 1), face.getOppositeFace()) && BlockHelper.CheckAttachedButton(block.getRelative(face, length_plus - 1), face)) {
                    if (BlockHelper.CheckAttachedTorch(block.getRelative(face.getOppositeFace(), length_minus - 1))) {
                        if (!BlockHelper.CheckAttachedTorch(block.getRelative(face, length_plus - 1))) {
                            barrel = block.getRelative(face, length_plus - 1).getLocation();
                            find_cannon = true;
                        }
                    } else if (BlockHelper.CheckAttachedTorch(block.getRelative(face, length_plus - 1)) && !BlockHelper.CheckAttachedTorch(block.getRelative(face.getOppositeFace(), length_minus - 1))) {
                        face = face.getOppositeFace();
                        barrel = block.getRelative(face, length_minus - 1).getLocation();
                        find_cannon = true;
                    }
                }
                if ((length = length_plus + length_minus - 1) < this.config.min_barrel_length || length > this.config.max_barrel_length || !find_cannon) {
                    find_cannon = false;
                }
                if (!find_cannon && !redo) {
                    redo = true;
                    length_plus = 0;
                    length_minus = 0;
                    continue;
                }
                redo = false;
            } while (redo);
        }
        if (find_cannon && player != null && !player.hasPermission("cannons.player.placeRedstoneTorch") && this.CheckRedstone(barrel, length, face)) {
            player.sendMessage(this.message.ErrorPermRestoneTorch);
        }
        CannonAttribute cannon = new CannonAttribute();
        cannon.barrel = barrel;
        cannon.face = face;
        cannon.find = find_cannon;
        cannon.barrel_length = length;
        return cannon;
    }

    private boolean CheckRedstone(Location barrel, int length, BlockFace face) {
        Block barrelBlock = barrel.getBlock();
        Boolean broke = false;
        int i = 0;
        while (i < length) {
            Block next = barrelBlock.getRelative(face.getOppositeFace(), i);
            for (Block b : this.SurroundingBlocks(next)) {
                if (b.getType() != Material.REDSTONE_TORCH_ON && b.getType() != Material.REDSTONE_TORCH_OFF) continue;
                broke = true;
                b.breakNaturally();
            }
            ++i;
        }
        Block button = barrelBlock.getRelative(face.getOppositeFace(), length);
        for (Block b : this.HorizontalSurroundingBlocks(button)) {
            if (b.getType() != Material.REDSTONE_WIRE) continue;
            broke = true;
            b.breakNaturally();
        }
        return broke;
    }

    public void deleteCannons(String owner) {
        Iterator<CannonData> iter = this.CannonList.iterator();
        while (iter.hasNext()) {
            CannonData next = iter.next();
            if (next.owner != owner) continue;
            iter.remove();
        }
    }

    public ArrayList<Block> SurroundingBlocks(Block block) {
        ArrayList<Block> Blocks = new ArrayList<Block>();
        Blocks.add(block.getRelative(BlockFace.UP));
        Blocks.add(block.getRelative(BlockFace.DOWN));
        Blocks.add(block.getRelative(BlockFace.SOUTH));
        Blocks.add(block.getRelative(BlockFace.WEST));
        Blocks.add(block.getRelative(BlockFace.NORTH));
        Blocks.add(block.getRelative(BlockFace.EAST));
        return Blocks;
    }

    public ArrayList<Block> HorizontalSurroundingBlocks(Block block) {
        ArrayList<Block> Blocks = new ArrayList<Block>();
        Blocks.add(block.getRelative(BlockFace.SOUTH));
        Blocks.add(block.getRelative(BlockFace.WEST));
        Blocks.add(block.getRelative(BlockFace.NORTH));
        Blocks.add(block.getRelative(BlockFace.EAST));
        return Blocks;
    }

    public class CannonAttribute {
        public Location barrel;
        public BlockFace face;
        public int barrel_length;
        public boolean find;
    }
}

