/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons.config;

import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.config.MaterialHolder;
import at.pavlov.Cannons.config.Projectile;
import at.pavlov.Cannons.config.UserMessages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class Config {
    public String CannonMaterialName = "WOOL";
    public int CannonMaterialId = 35;
    public int CannonMaterialData = 15;
    public ArrayList<Projectile> allowedProjectiles = new ArrayList();
    public ArrayList<MaterialHolder> usedMaterial = new ArrayList();
    public boolean Muzzle_flash = true;
    public boolean usePlayerName = true;
    public int Muzzle_displ = 5;
    public int max_gunpowder = 10;
    public boolean gunpowder_depends_on_length = true;
    public double fireDelay = 5.0;
    public double ignitionDelay = 1.0;
    public double confusesShooter = 10.0;
    public boolean inventory_take = false;
    public boolean redstone_consumption = true;
    public boolean redstone_autoload = true;
    public boolean flint_and_steel = false;
    public boolean fireTorch = true;
    public boolean fireButton = false;
    public double max_h_angle = 30.0;
    public double min_h_angle = -30.0;
    public double max_v_angle = 30.0;
    public double min_v_angle = -30.0;
    public double angle_step = 1.0;
    public double angle_deviation = 3.0;
    public int max_barrel_length = 10;
    public int min_barrel_length = 2;
    public boolean enableLimits = false;
    public int cannonLimitA = 3;
    public int cannonLimitB = 100;
    public boolean forceTNTexplosion = true;
    public int version_number;
    private UserMessages userMessage;
    private Cannons plugin;

    public Config(Cannons plugin) {
        this.plugin = plugin;
        this.allowedProjectiles.add(new Projectile());
        this.userMessage = new UserMessages(plugin, this);
    }

    public void loadConfig() {
        this.plugin.reloadConfig();
        this.loadProjectiles(this.plugin);
        this.CannonMaterialName = this.plugin.getConfig().getString("construction.cannon material name", "cannon material name missing");
        this.CannonMaterialId = this.plugin.getConfig().getInt("construction.cannon material ID", 35);
        this.CannonMaterialData = this.plugin.getConfig().getInt("construction.cannon material data", 15);
        this.usedMaterial.add(new MaterialHolder(this.CannonMaterialId, this.CannonMaterialData));
        this.usedMaterial.add(new MaterialHolder(Material.STONE_BUTTON.getId(), -1));
        this.usedMaterial.add(new MaterialHolder(Material.TORCH.getId(), 5));
        this.Muzzle_flash = this.plugin.getConfig().getBoolean("general.muzzleflash", true);
        this.usePlayerName = this.plugin.getConfig().getBoolean("general.use player name for damage", false);
        this.confusesShooter = this.plugin.getConfig().getDouble("general.confuses shooter", 3.0);
        this.max_gunpowder = this.plugin.getConfig().getInt("general.max gunpowder", 5);
        this.gunpowder_depends_on_length = this.plugin.getConfig().getBoolean("general.gunpowder varies for length", true);
        this.fireDelay = this.plugin.getConfig().getInt("general.barrel cooldown time", 3);
        this.ignitionDelay = this.plugin.getConfig().getInt("general.fuse burn time", 3);
        this.inventory_take = this.plugin.getConfig().getBoolean("general.player ammunition consumption", true);
        this.redstone_consumption = this.plugin.getConfig().getBoolean("general.redstone ammunition consumption", true);
        this.redstone_autoload = this.plugin.getConfig().getBoolean("fire and reload.redstone autoload", true);
        this.flint_and_steel = this.plugin.getConfig().getBoolean("fire and reload.fire torch with flint and steel", false);
        this.fireTorch = this.plugin.getConfig().getBoolean("fire and reload.fire with torch", true);
        this.fireButton = this.plugin.getConfig().getBoolean("fire and reload.fire with button", true);
        this.enableLimits = this.plugin.getConfig().getBoolean("amount of built cannons.use limits", true);
        this.cannonLimitA = this.plugin.getConfig().getInt("amount of built cannons.build limit A", 1);
        this.cannonLimitB = this.plugin.getConfig().getInt("amount of built cannons.build limit B", 10);
        this.max_h_angle = this.plugin.getConfig().getDouble("angles.max horizontal angle", 30.0);
        this.min_h_angle = this.plugin.getConfig().getDouble("angles.min horizontal angle", 30.0);
        this.max_v_angle = this.plugin.getConfig().getDouble("angles.max vertical angle", 30.0);
        this.min_v_angle = this.plugin.getConfig().getDouble("angles.min vertical angle", 30.0);
        this.angle_step = this.plugin.getConfig().getDouble("angles.angle step", 1.0);
        this.angle_deviation = this.plugin.getConfig().getDouble("angles.deviation angle", 1.0);
        this.max_barrel_length = this.plugin.getConfig().getInt("construction.max barrel length", 5);
        this.min_barrel_length = this.plugin.getConfig().getInt("construction.min barrel length", 2);
        this.forceTNTexplosion = this.plugin.getConfig().getBoolean("protectionplugin.force tnt event", true);
        if (!this.userMessage.loadLanguage(this.plugin.getConfig().getString("language"))) {
            this.plugin.logSevere("Can't load language. Check spelling.");
        }
        this.plugin.getConfig().options().copyHeader(true);
        this.plugin.getConfig().options().copyDefaults(true);
        this.plugin.saveConfig();
    }

    private void loadProjectiles(Cannons plugin) {
        this.allowedProjectiles.clear();
        List list_material = plugin.getConfig().getStringList("projectiles");
        if (list_material != null) {
            for (String next : list_material) {
                if (plugin.getConfig().contains(next)) {
                    this.allowedProjectiles.add(this.loadProjectileData(plugin, next));
                    continue;
                }
                plugin.logSevere("missing cannon property entry for " + next);
            }
            if (this.allowedProjectiles.size() == 0) {
                this.allowedProjectiles.add(new Projectile());
            }
        } else {
            plugin.logSevere("No Projectile found.");
        }
    }

    private Projectile loadProjectileData(Cannons plugin, String next) {
        Projectile projectile = new Projectile();
        projectile.name = plugin.getConfig().getString(String.valueOf(next) + "." + "name", "no cannonball name");
        projectile.id = plugin.getConfig().getInt(String.valueOf(next) + "." + "id", 4);
        projectile.data = plugin.getConfig().getInt(String.valueOf(next) + "." + "data", 0);
        projectile.max_speed = plugin.getConfig().getDouble(String.valueOf(next) + "." + "max speed", 3.0);
        projectile.player_damage = plugin.getConfig().getDouble(String.valueOf(next) + "." + "player damage", 7.0);
        projectile.cannonball = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "cannonball.cannonball", true);
        projectile.explosion_power = plugin.getConfig().getDouble(String.valueOf(next) + "." + "cannonball.explosion power", 2.0);
        projectile.penetration = plugin.getConfig().getDouble(String.valueOf(next) + "." + "cannonball.penetration", 1.0);
        projectile.timefuse = plugin.getConfig().getDouble(String.valueOf(next) + "." + "cannonball.timefuse", 0.0);
        projectile.canisterShot = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "canistershot.canister shot", false);
        projectile.spreadCanisterShot = plugin.getConfig().getDouble(String.valueOf(next) + "." + "canistershot.spread", 1.0);
        projectile.amountCanisterShot = plugin.getConfig().getInt(String.valueOf(next) + "." + "canistershot.amount of bullets", 40);
        projectile.placeBlock = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "placeBlock.enabled", false);
        projectile.placeBlockRadius = plugin.getConfig().getDouble(String.valueOf(next) + "." + "placeBlock.radius", 3.0);
        projectile.placeBlockAmount = plugin.getConfig().getInt(String.valueOf(next) + "." + "placeBlock.amount", 3);
        projectile.placeBlockMaterialId = plugin.getConfig().getInt(String.valueOf(next) + "." + "placeBlock.materialID", 0);
        projectile.placeBlockMaterialData = plugin.getConfig().getInt(String.valueOf(next) + "." + "placeBlock.materialData", 0);
        projectile.effectDuration = plugin.getConfig().getDouble(String.valueOf(next) + "." + "effects.effect duration");
        projectile.superBreaker = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.super breaker");
        projectile.incendiary = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.incendiary");
        projectile.blindness = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.blindness");
        projectile.poison = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.poison");
        projectile.slowness = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.slowness");
        projectile.slowDigging = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.slowDigging");
        projectile.weakness = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.weakness");
        projectile.confusion = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.confusion");
        projectile.hunger = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.hunger");
        projectile.teleport = plugin.getConfig().getBoolean(String.valueOf(next) + "." + "effects.teleport to impact");
        if (!projectile.cannonball && !projectile.canisterShot || projectile.max_speed <= 0.1) {
            plugin.logSevere("No proporties of " + projectile.name + " found. Check if both names are written in the same way.");
        }
        return projectile;
    }

    public Projectile getProjectile(int projectileID, int projectileData) {
        for (Projectile next : this.allowedProjectiles) {
            if (!next.isEqual(projectileID, projectileData)) continue;
            return next;
        }
        return null;
    }

    public UserMessages getUserMessages() {
        return this.userMessage;
    }

    public boolean isCannonBarrel(Block block) {
        return block.getTypeId() == this.CannonMaterialId && (this.CannonMaterialData < 0 || block.getData() == this.CannonMaterialData);
    }

    public boolean isCannonBlock(Block block) {
        for (MaterialHolder next : this.usedMaterial) {
            if (block.getTypeId() != next.id || next.data >= 0 && block.getData() != next.data) continue;
            return true;
        }
        return false;
    }
}

