/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons.listener;

import at.pavlov.Cannons.CalcAngle;
import at.pavlov.Cannons.CannonManager;
import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.CreateExplosion;
import at.pavlov.Cannons.FireCannon;
import at.pavlov.Cannons.config.Config;
import at.pavlov.Cannons.config.Projectile;
import at.pavlov.Cannons.config.UserMessages;
import at.pavlov.Cannons.dao.CannonData;
import at.pavlov.Cannons.utils.BlockHelper;
import at.pavlov.Cannons.utils.FlyingProjectile;
import at.pavlov.Cannons.utils.InventoryManagement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Button;

public class PlayerListener
implements Listener {
    private Config config;
    private UserMessages userMessages;
    private Cannons plugin;
    private CannonManager cannonManager;
    private InventoryManagement InvManage;
    private FireCannon fireCannon;
    private CreateExplosion explosion;
    private CalcAngle calcAngle;

    public PlayerListener(Cannons plugin) {
        this.InvManage = plugin.getInvManage();
        this.config = plugin.getmyConfig();
        this.userMessages = plugin.getmyConfig().getUserMessages();
        this.plugin = plugin;
        this.cannonManager = plugin.getCannonManager();
        this.explosion = plugin.getExplosion();
        this.fireCannon = plugin.getFireCannon();
        this.calcAngle = plugin.getCalcAngle();
    }

    @EventHandler
    public void PlayerMove(PlayerMoveEvent event) {
        this.calcAngle.PlayerMove(event.getPlayer());
    }

    @EventHandler
    public void EntityDeath(EntityDeathEvent event) {
    }

    @EventHandler
    public void BlockFromTo(BlockFromToEvent event) {
        Block block = event.getToBlock();
        if ((block.getType() == Material.STONE_BUTTON || block.getType() == Material.TORCH) && this.cannonManager.isCannonBlock(block.getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void EntityExplode(EntityExplodeEvent event) {
        if (this.config.forceTNTexplosion && (event.getEntity() == null || event.getEntity() instanceof Snowball) && !event.blockList().isEmpty()) {
            Location eventLoc = event.getLocation();
            TNTPrimed tnt = (TNTPrimed)eventLoc.getWorld().spawn(eventLoc, TNTPrimed.class);
            EntityExplodeEvent newEvent = new EntityExplodeEvent((Entity)tnt, eventLoc, event.blockList(), 0.3f);
            this.plugin.getServer().getPluginManager().callEvent((Event)newEvent);
            tnt.remove();
            if (newEvent.isCancelled()) {
                event.setCancelled(newEvent.isCancelled());
                event.blockList().clear();
            }
        }
        if (!event.isCancelled()) {
            Block block;
            List blocks = event.blockList();
            int i = 0;
            while (i < blocks.size()) {
                block = (Block)blocks.get(i);
                if (this.cannonManager.isCannonBlock(block.getLocation())) {
                    Entity explosionEntity = event.getEntity();
                    if (explosionEntity == null) {
                        blocks.remove(i--);
                    } else {
                        Location impact = explosionEntity.getLocation();
                        double distance = impact.distance(block.getLocation());
                        if (distance < 2.0) {
                            this.cannonManager.removeCannon(block.getLocation());
                        } else {
                            blocks.remove(i--);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < blocks.size()) {
                block = (Block)blocks.get(i);
                if (event.getEntity() != null) {
                    block = (Block)blocks.get(i);
                    if (event.getEntity().toString().equals("CraftSnowball")) {
                        Material material = block.getType();
                        if (material == Material.OBSIDIAN || material == Material.WATER || material == Material.LAVA) {
                            if (!this.plugin.BlockBreakPluginLoaded()) {
                                this.BlockBreak(block, event.getYield());
                            }
                        } else if (!this.plugin.BlockBreakPluginLoaded()) {
                            this.BlockBreak(block, event.getYield());
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void BlockBreak(Block block, float yield) {
        Random r = new Random();
        if (r.nextFloat() > yield) {
            block.breakNaturally();
        } else {
            block.setTypeId(0);
        }
    }

    @EventHandler
    public void BlockPistonRetract(BlockPistonRetractEvent event) {
        Location loc;
        CannonData cannon;
        if (event.isSticky() && (cannon = this.cannonManager.getCannon(loc = event.getBlock().getRelative(event.getDirection(), 2).getLocation())) != null) {
            this.cannonManager.removeCannon(cannon);
        }
    }

    @EventHandler
    public void BlockPistonExtend(BlockPistonExtendEvent event) {
        Iterator iter = event.getBlocks().iterator();
        while (iter.hasNext()) {
            CannonData cannon = this.cannonManager.getCannon(((Block)iter.next()).getLocation());
            if (cannon == null) continue;
            this.cannonManager.removeCannon(cannon);
        }
    }

    @EventHandler
    public void BlockBurn(BlockBurnEvent event) {
        if (this.cannonManager.isCannonBlock(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void BlockBreak(BlockBreakEvent event) {
        CannonData cannon = this.cannonManager.getCannon(event.getBlock().getLocation());
        if (cannon != null) {
            this.cannonManager.removeCannon(cannon);
        }
    }

    @EventHandler
    public void PlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Location barrel;
        if (this.config.isCannonBarrel(event.getBlockClicked()) && this.cannonManager.isCannonBlock(barrel = event.getBlockClicked().getLocation()) && this.CheckLoadedProjectile(event.getBucket().getId(), 0)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void BlockPlace(BlockPlaceEvent event) {
        Location loc;
        Location loc2;
        Location barrel;
        if (this.config.isCannonBlock(event.getBlockPlaced())) {
            Block block = event.getBlockPlaced();
            Location barrel2 = block.getLocation();
            if (block.getType() == Material.TORCH || block.getType() == Material.STONE_BUTTON) {
                Block barrelBlock = event.getBlockAgainst();
                if (barrelBlock.getLocation().equals((Object)event.getBlockPlaced().getLocation())) {
                    barrelBlock = barrelBlock.getRelative(BlockFace.DOWN);
                }
                barrel2 = barrelBlock.getLocation();
            }
            this.cannonManager.getCannon(barrel2, event.getPlayer());
            return;
        }
        if (event.getBlockAgainst() != null && this.config.isCannonBlock(event.getBlockAgainst()) && this.cannonManager.isCannonBlock(barrel = event.getBlockAgainst().getLocation()) && this.CheckLoadedProjectile(event.getBlock())) {
            event.setCancelled(true);
        }
        if (!(event.getBlockPlaced().getType() != Material.REDSTONE_TORCH_ON && event.getBlockPlaced().getType() != Material.REDSTONE_TORCH_OFF || event.getPlayer().hasPermission("cannons.player.placeRedstoneTorch"))) {
            for (Block b : this.cannonManager.SurroundingBlocks(event.getBlock())) {
                if (!this.config.isCannonBarrel(b) || this.cannonManager.getCannon(loc2 = b.getLocation(), event.getPlayer()) == null) continue;
                event.getPlayer().sendMessage(this.userMessages.ErrorPermRestoneTorch);
                event.setCancelled(true);
            }
        }
        if (event.getBlockPlaced().getType() == Material.REDSTONE_WIRE && !event.getPlayer().hasPermission("cannons.player.placeRedstoneTorch")) {
            for (Block b : this.cannonManager.HorizontalSurroundingBlocks(event.getBlock())) {
                if (b.getType() != Material.STONE_BUTTON || this.cannonManager.getCannon(loc2 = b.getLocation(), event.getPlayer()) == null) continue;
                event.getPlayer().sendMessage(this.userMessages.ErrorPermRestoneTorch);
                event.setCancelled(true);
            }
        }
        if (event.getBlock().getType() == Material.FIRE && this.cannonManager.getCannon(loc = event.getBlockAgainst().getLocation(), event.getPlayer()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void RedstoneEvent(BlockRedstoneEvent event) {
        Location barrel;
        CannonData cannon;
        Button button;
        Location barrel2;
        CannonData cannon2;
        Block block = event.getBlock();
        if (block.getType() == Material.REDSTONE_TORCH_ON) {
            for (Block b : this.cannonManager.SurroundingBlocks(block)) {
                if (!this.config.isCannonBarrel(b) || (cannon2 = this.cannonManager.getCannon(barrel2 = b.getLocation())) == null) continue;
                this.fireCannon.prepare_fire(cannon2, null, !this.config.redstone_autoload);
            }
        }
        if ((block = event.getBlock()).getType() == Material.REDSTONE_WIRE && block.getData() == 0) {
            for (Block b : this.cannonManager.HorizontalSurroundingBlocks(block)) {
                if (b.getType() != Material.STONE_BUTTON || (cannon2 = this.cannonManager.getCannon(barrel2 = b.getLocation())) == null) continue;
                this.fireCannon.prepare_fire(cannon2, null, !this.config.redstone_autoload);
            }
        }
        if (event.getBlock().getType() == Material.STONE_BUTTON && this.config.fireButton && BlockHelper.CheckAttachedTorch(block = block.getRelative((button = (Button)event.getBlock().getState().getData()).getAttachedFace())) && this.config.isCannonBarrel(block) && (cannon = this.cannonManager.getCannon(barrel = block.getLocation())) != null) {
            this.fireCannon.prepare_fire(cannon, null, true);
        }
    }

    @EventHandler
    public void ProjectileHit(ProjectileHitEvent event) {
        LinkedList<FlyingProjectile> flying_projectiles = this.fireCannon.getProjectiles();
        if (!flying_projectiles.isEmpty()) {
            Iterator iterator = flying_projectiles.iterator();
            while (iterator.hasNext()) {
                FlyingProjectile flying = (FlyingProjectile)iterator.next();
                if (!event.getEntity().equals(flying.snowball)) continue;
                flying.snowball = (Snowball)event.getEntity();
                this.explosion.create_explosion(flying);
                iterator.remove();
            }
        }
    }

    @EventHandler
    public void PlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) {
            Block clickedBlock = event.getClickedBlock() == null ? event.getPlayer().getTargetBlock(null, 4) : event.getClickedBlock();
            if (this.config.isCannonBlock(clickedBlock)) {
                Player player = event.getPlayer();
                Location barrel = clickedBlock.getLocation();
                CannonData cannon = this.cannonManager.getCannon(barrel, player);
                if (cannon == null) {
                    return;
                }
                Material ItemInHand = player.getItemInHand().getType();
                if (ItemInHand == Material.EGG || ItemInHand == Material.SNOW_BALL || ItemInHand == Material.MONSTER_EGG) {
                    event.setCancelled(true);
                }
                if (this.config.isCannonBarrel(clickedBlock) && this.CheckLoadedProjectile(event.getPlayer().getItemInHand()) && this.CheckPermProjectile(player, cannon)) {
                    cannon.projectileID = ItemInHand.getId();
                    player.sendMessage(this.userMessages.getloadProjectile(ItemInHand.getId()));
                    this.InvManage.TakeFromPlayerInventory(player, this.config.inventory_take);
                    cannon.updateCannonSigns();
                    return;
                }
                if (this.config.isCannonBarrel(clickedBlock) && event.getMaterial() == Material.SULPHUR && this.CheckPermSulphur(player, cannon)) {
                    ++cannon.gunpowder;
                    player.sendMessage(this.userMessages.getloadGunpowder(cannon.gunpowder));
                    this.InvManage.TakeFromPlayerInventory(player, this.config.inventory_take);
                    cannon.updateCannonSigns();
                    return;
                }
                if (clickedBlock.getType() == Material.TORCH && this.config.fireTorch) {
                    this.fireCannon.prepare_fire(cannon, player, true);
                    return;
                }
                if (clickedBlock.getType() == Material.STONE_BUTTON && this.config.fireButton) {
                    this.fireCannon.displayPrepareFireMessage(cannon, player);
                    return;
                }
                if ((player.getItemInHand().getType() == Material.AIR || player.getItemInHand().getType() == Material.WATCH) && this.config.isCannonBarrel(clickedBlock)) {
                    this.calcAngle.ChangeAngle(cannon, event.getAction(), event.getBlockFace(), player);
                    cannon.updateCannonSigns();
                    return;
                }
            } else {
                this.calcAngle.disableAimingMode(event.getPlayer());
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            this.calcAngle.disableAimingMode(event.getPlayer());
        }
    }

    private boolean CheckPermProjectile(Player player, CannonData cannon) {
        if (cannon.isLoaded()) {
            player.sendMessage(this.userMessages.getProjectileAlreadyLoaded(cannon.gunpowder, cannon.projectileID));
            return false;
        }
        if (cannon.gunpowder == 0) {
            player.sendMessage(this.userMessages.NoSulphur);
            return false;
        }
        if (!player.hasPermission("cannons.player.load")) {
            player.sendMessage(this.userMessages.ErrorPermLoad);
            return false;
        }
        String ItemInHand = player.getItemInHand().getType().toString();
        if (!player.hasPermission("cannons.projectile." + ItemInHand.toString()) && !player.hasPermission("cannons.projectile")) {
            player.sendMessage(this.userMessages.ErrorPermissionProjectile);
            return false;
        }
        return true;
    }

    private boolean CheckPermSulphur(Player player, CannonData cannon) {
        if (cannon.isLoaded()) {
            player.sendMessage(this.userMessages.getProjectileAlreadyLoaded(cannon.gunpowder, cannon.projectileID));
            return false;
        }
        int lengthDiff = this.config.max_barrel_length - this.config.min_barrel_length;
        if (lengthDiff == 0) {
            lengthDiff = 1;
        }
        int max_gunpowder = this.config.max_gunpowder;
        if (this.config.gunpowder_depends_on_length) {
            max_gunpowder = 1 + (this.config.max_gunpowder - 1) * (cannon.barrel_length - this.config.min_barrel_length) / (this.config.max_barrel_length - this.config.min_barrel_length);
        }
        if (cannon.gunpowder >= max_gunpowder) {
            player.sendMessage(this.userMessages.getMaximumGunpowderLoaded(cannon.gunpowder));
            return false;
        }
        if (!player.hasPermission("cannons.player.load")) {
            player.sendMessage(this.userMessages.ErrorPermLoad);
            return false;
        }
        return true;
    }

    private boolean CheckLoadedProjectile(ItemStack item) {
        return this.CheckLoadedProjectile(item.getTypeId(), item.getData().getData());
    }

    private boolean CheckLoadedProjectile(Block block) {
        return this.CheckLoadedProjectile(block.getTypeId(), block.getData());
    }

    private boolean CheckLoadedProjectile(int blockId, int blockData) {
        for (Projectile next : this.config.allowedProjectiles) {
            if (blockId == Material.REDSTONE_WIRE.getId()) {
                blockId = Material.REDSTONE.getId();
            }
            if (blockId == Material.CAKE_BLOCK.getId()) {
                blockId = Material.CAKE.getId();
            }
            if (!next.isEqual(blockId, blockData)) continue;
            return true;
        }
        return false;
    }
}

