/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons;

import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.config.Config;
import at.pavlov.Cannons.config.Projectile;
import at.pavlov.Cannons.utils.FlyingProjectile;
import de.tyranus.minecraft.bukkit.guildawards.external.GunnerGuildConnector;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftSkeleton;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftSpider;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftZombie;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class CreateExplosion {
    private Cannons plugin;
    private Config config;
    LinkedList<UUID> transmittedEntities = new LinkedList();

    public CreateExplosion(Cannons plugin, Config config) {
        this.plugin = plugin;
        this.config = config;
        this.transmittedEntities = new LinkedList();
    }

    private boolean breakBlock(Block block, List<Block> blocklist, Boolean superBreaker) {
        Material material = block.getType();
        if (material != Material.AIR) {
            if (material == Material.OBSIDIAN) {
                if (superBreaker.booleanValue()) {
                    blocklist.add(block);
                    return true;
                }
                return false;
            }
            if (material == Material.WATER || material == Material.LAVA) {
                if (superBreaker.booleanValue()) {
                    blocklist.add(block);
                    return true;
                }
                return true;
            }
            if (material != Material.BEDROCK) {
                blocklist.add(block);
                return true;
            }
            return false;
        }
        return true;
    }

    private Location blockBreaker(FlyingProjectile cannonball) {
        LinkedList<Block> blocklist = new LinkedList<Block>();
        Boolean superbreaker = cannonball.projectile.superBreaker;
        Vector vel = cannonball.snowball.getVelocity();
        Location snowballLoc = cannonball.snowball.getLocation();
        int penetration = (int)(cannonball.projectile.penetration * vel.length() / cannonball.projectile.max_speed);
        Location impactLoc = snowballLoc.clone();
        if (cannonball.projectile.penetration > 0.0) {
            BlockIterator iter = new BlockIterator(snowballLoc.getWorld(), snowballLoc.toVector(), vel.normalize(), 0.0, penetration + 1);
            int i = 0;
            while (iter.hasNext() && i <= penetration + 1) {
                Block next = iter.next();
                if (++i <= penetration) {
                    if (this.breakBlock(next, blocklist, superbreaker)) continue;
                    impactLoc = next.getLocation();
                    break;
                }
                impactLoc = next.getLocation();
            }
        }
        if (cannonball.projectile.superBreaker) {
            Block block = impactLoc.getBlock();
            this.breakBlock(block, blocklist, superbreaker);
            this.breakBlock(block.getRelative(BlockFace.UP), blocklist, superbreaker);
            this.breakBlock(block.getRelative(BlockFace.DOWN), blocklist, superbreaker);
            this.breakBlock(block.getRelative(BlockFace.SOUTH), blocklist, superbreaker);
            this.breakBlock(block.getRelative(BlockFace.WEST), blocklist, superbreaker);
            this.breakBlock(block.getRelative(BlockFace.EAST), blocklist, superbreaker);
            this.breakBlock(block.getRelative(BlockFace.NORTH), blocklist, superbreaker);
        }
        EntityExplodeEvent event = new EntityExplodeEvent((Entity)cannonball.snowball, impactLoc, blocklist, 1.0f);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        return impactLoc;
    }

    private void PlaceRandomMob(Location Loc) {
        World world = Loc.getWorld();
        Random r = new Random();
        switch (r.nextInt(4)) {
            case 0: {
                world.spawn(Loc, CraftZombie.class);
                break;
            }
            case 1: {
                world.spawn(Loc, CraftCreeper.class);
                break;
            }
            case 2: {
                world.spawn(Loc, CraftSpider.class);
                break;
            }
            case 3: {
                world.spawn(Loc, CraftSkeleton.class);
            }
        }
    }

    private void makeBlockPlace(Location impactLoc, Location Loc, Projectile projectile) {
        Block block = Loc.getBlock();
        if (block.getType() == Material.AIR && this.checkLineOfSight(impactLoc, Loc) == 0) {
            if (projectile == null) {
                return;
            }
            if (projectile.placeBlockMaterialId != 0) {
                if (projectile.isMobEgg()) {
                    this.PlaceRandomMob(Loc);
                } else {
                    block.setTypeId(projectile.placeBlockMaterialId);
                    block.setData((byte)projectile.placeBlockMaterialData);
                }
            }
        }
    }

    private void spreadBlocks(Location impactLoc, Projectile projectile) {
        if (projectile.placeBlock) {
            double spread = projectile.placeBlockRadius;
            int maxPlacement = projectile.placeBlockAmount;
            Random r = new Random();
            int i = 0;
            int iterations1 = 0;
            do {
                ++iterations1;
                Location loc = impactLoc.clone();
                loc.setX(loc.getX() + r.nextGaussian() * spread / 2.0);
                loc.setZ(loc.getZ() + r.nextGaussian() * spread / 2.0);
                int iterations2 = 0;
                Block block = loc.getBlock();
                boolean finished = false;
                do {
                    ++iterations2;
                    if (block.getType() != Material.AIR) {
                        block = block.getRelative(BlockFace.UP);
                        continue;
                    }
                    if (block.getRelative(BlockFace.DOWN).getType() == Material.AIR) {
                        block = block.getRelative(BlockFace.DOWN);
                        continue;
                    }
                    finished = true;
                } while (!finished && (double)iterations2 <= spread);
                if (!finished) continue;
                ++i;
                this.makeBlockPlace(impactLoc, block.getLocation(), projectile);
            } while (iterations1 < maxPlacement * 2 && i < maxPlacement);
        }
    }

    private int checkLineOfSight(Location impact, Location target) {
        int blockingBlocks = 0;
        Vector vect = target.toVector().clone().subtract(impact.toVector());
        int length = (int)Math.ceil(vect.length());
        vect.normalize();
        Location impactClone = impact.clone();
        int i = 2;
        while (i <= length) {
            if (impactClone.add(vect).getBlock().getType() != Material.AIR) {
                ++blockingBlocks;
            }
            ++i;
        }
        return blockingBlocks;
    }

    private void doPlayerDamage(Location impactLoc, Entity next, FlyingProjectile cannonball) {
        double dist = impactLoc.distanceSquared(next.getLocation());
        if (next instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)next;
            double damage = dist <= 16.0 ? cannonball.projectile.player_damage : Math.floor(cannonball.projectile.player_damage / (dist - 15.0));
            int blockingBlocks = this.checkLineOfSight(impactLoc, living.getEyeLocation());
            damage /= (double)(blockingBlocks + 1);
            Random r = new Random();
            int crit = r.nextInt(10);
            if (crit == 0) {
                damage *= 3.0;
            }
            if (damage >= 1.0) {
                int intDamage = (int)(damage * 2.0);
                if (this.config.usePlayerName) {
                    living.damage(intDamage, (Entity)cannonball.snowball.getShooter());
                } else {
                    living.damage(intDamage, null);
                }
            }
            int amplifer = 0;
            if (damage >= 2.0) {
                amplifer = 1;
            }
            if (cannonball.projectile.blindness && damage >= 1.0) {
                living.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, (int)(cannonball.projectile.effectDuration * 20.0), amplifer));
            }
            if (cannonball.projectile.confusion && damage >= 1.0) {
                living.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, (int)(cannonball.projectile.effectDuration * 20.0), amplifer));
            }
            if (cannonball.projectile.hunger && damage >= 1.0) {
                living.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, (int)(cannonball.projectile.effectDuration * 20.0), amplifer));
            }
            if (cannonball.projectile.poison && damage >= 1.0) {
                living.addPotionEffect(new PotionEffect(PotionEffectType.POISON, (int)(cannonball.projectile.effectDuration * 5.0), 0));
            }
            if (cannonball.projectile.slowDigging && damage >= 1.0) {
                living.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, (int)(cannonball.projectile.effectDuration * 20.0), amplifer));
            }
            if (cannonball.projectile.slowness && damage >= 1.0) {
                living.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)(cannonball.projectile.effectDuration * 20.0), amplifer));
            }
            if (cannonball.projectile.weakness && damage >= 1.0) {
                living.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, (int)(cannonball.projectile.effectDuration * 20.0), amplifer));
            }
        }
    }

    public void create_explosion(FlyingProjectile cannonball) {
        LivingEntity shooter;
        List entity;
        Location impactLoc = this.blockBreaker(cannonball);
        float explosion_power = (float)cannonball.projectile.explosion_power;
        if (cannonball.projectile.canisterShot) {
            entity = cannonball.snowball.getNearbyEntities(2.0, 2.0, 2.0);
        } else {
            entity = cannonball.snowball.getNearbyEntities(20.0, 20.0, 20.0);
            cannonball.snowball.getLocation().getWorld().createExplosion(impactLoc, explosion_power, cannonball.projectile.incendiary);
        }
        this.spreadBlocks(impactLoc, cannonball.projectile);
        for (Entity next : entity) {
            this.doPlayerDamage(impactLoc, next, cannonball);
        }
        if (cannonball.projectile.teleport && (shooter = cannonball.snowball.getShooter()) != null) {
            shooter.teleport(impactLoc);
        }
        List EntitiesAfterExplosion = cannonball.snowball.getNearbyEntities(20.0, 20.0, 20.0);
        this.transmittingEntities(EntitiesAfterExplosion, (Entity)cannonball.snowball.getShooter());
    }

    private void transmittingEntities(List<Entity> after, Entity shooter) {
        GunnerGuildConnector handler = this.plugin.getCannonGuildHandler();
        if (handler == null) {
            return;
        }
        if (shooter == null) {
            return;
        }
        if (!(shooter instanceof Player)) {
            return;
        }
        if (after.size() == 0) {
            return;
        }
        double distance = 0.0;
        LinkedList<LivingEntity> killedEntities = new LinkedList<LivingEntity>();
        for (Entity entity : after) {
            LivingEntity LivEntity;
            if (!(entity instanceof LivingEntity) || !entity.isDead() || this.hasBeenTransmitted((LivEntity = (LivingEntity)entity).getUniqueId())) continue;
            distance = shooter.getLocation().distance(LivEntity.getLocation());
            killedEntities.add(LivEntity);
            this.transmittedEntities.add(LivEntity.getUniqueId());
        }
        if (killedEntities.size() > 0) {
            try {
                handler.updateGunnerReputation((Player)shooter, killedEntities, distance);
            }
            catch (Exception e) {
                this.plugin.logSevere("Error adding reputation to player");
            }
        }
    }

    private boolean hasBeenTransmitted(UUID id) {
        ListIterator<UUID> iter = this.transmittedEntities.listIterator(this.transmittedEntities.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != id) continue;
            return true;
        }
        return false;
    }

    public void deleteTransmittedEntities() {
        this.transmittedEntities = new LinkedList();
    }
}

