/*
 * Decompiled with CFR 0.152.
 */
package at.pavlov.Cannons.dao;

import at.pavlov.Cannons.Cannons;
import at.pavlov.Cannons.dao.CannonBean;
import at.pavlov.Cannons.dao.CannonData;
import com.avaje.ebean.Query;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class PersistenceDatabase {
    private final Cannons plugin;
    private List<Object> obsoleteIdList;

    public PersistenceDatabase(Cannons _plugin) {
        this.plugin = _plugin;
    }

    public boolean loadCannons() {
        Query query = this.plugin.getDatabase().find(CannonBean.class);
        List beans = query.findList();
        if (beans == null || beans.size() == 0) {
            return false;
        }
        for (CannonBean bean : beans) {
            World world = Bukkit.getWorld((String)bean.getWorld());
            if (world == null) {
                this.plugin.logSevere("World for cannon not found");
                continue;
            }
            Location loc = new Location(world, (double)bean.getLocX(), (double)bean.getLocY(), (double)bean.getLocZ());
            CannonData cannonData = this.plugin.getCannonManager().getCannon(loc);
            if (cannonData != null) {
                cannonData.id = bean.getId();
                cannonData.name = bean.getName();
                cannonData.owner = bean.getOwner();
                cannonData.gunpowder = bean.getGunpowder();
                cannonData.projectileID = bean.getProjectileID();
                cannonData.projectileData = bean.getProjectileData();
                cannonData.horizontal_angle = bean.getHorizontalAngle();
                cannonData.vertical_angle = bean.getVerticalAngle();
                cannonData.designId = bean.getDesignId();
                cannonData.isValid = bean.isValid();
                cannonData.updateCannonSigns();
                continue;
            }
            this.plugin.logSevere("Unable to find cannon at " + loc.toString());
        }
        return true;
    }

    public void saveAllCannons() {
        this.obsoleteIdList = this.plugin.getDatabase().find(CannonBean.class).findIds();
        List<CannonData> cannonList = this.plugin.getCannonManager().getCannonList();
        for (CannonData cannon : cannonList) {
            this.saveCannon(cannon);
        }
        if (this.obsoleteIdList == null || this.obsoleteIdList.size() == 0) {
            return;
        }
    }

    private void saveCannon(CannonData cannon) {
        CannonBean bean = (CannonBean)this.plugin.getDatabase().find(CannonBean.class).where().idEq((Object)cannon.id).findUnique();
        if (bean == null) {
            bean = (CannonBean)this.plugin.getDatabase().createEntityBean(CannonBean.class);
            bean.setOwner(cannon.owner);
            bean.setWorld(cannon.firingLocation.getWorld().getName());
            if (cannon.CannonBlocks.size() > 0) {
                bean.setLocX(cannon.CannonBlocks.get(0).getBlockX());
                bean.setLocY(cannon.CannonBlocks.get(0).getBlockY());
                bean.setLocZ(cannon.CannonBlocks.get(0).getBlockZ());
            } else {
                bean.setLocX(cannon.firingLocation.getBlockX());
                bean.setLocY(cannon.firingLocation.getBlockY());
                bean.setLocZ(cannon.firingLocation.getBlockZ());
            }
        }
        bean.setName(cannon.name);
        bean.setGunpowder(cannon.gunpowder);
        bean.setProjectileID(cannon.projectileID);
        bean.setProjectileData(cannon.projectileData);
        bean.setHorizontalAngle(cannon.horizontal_angle);
        bean.setVerticalAngle(cannon.vertical_angle);
        bean.setDesignId(cannon.designId);
        bean.setValid(cannon.isValid);
        this.plugin.getDatabase().save((Object)bean);
        cannon.id = bean.getId();
        this.removeObsoleteID(cannon.id);
    }

    private void removeObsoleteID(int id) {
        if (this.obsoleteIdList == null || this.obsoleteIdList.size() == 0) {
            return;
        }
        Iterator<Object> iter = this.obsoleteIdList.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(id)) continue;
            iter.remove();
        }
    }

    public void deleteCannons(String owner) {
        List beans = this.plugin.getDatabase().find(CannonBean.class).where().eq("owner", (Object)owner).findList();
        if (beans == null || beans.size() == 0) {
            return;
        }
        for (CannonBean bean : beans) {
            this.plugin.getDatabase().delete(CannonBean.class, (Object)bean.getId());
        }
    }
}

