/*
 * Decompiled with CFR 0.152.
 */
package tux2.MonsterBox;

import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import tux2.MonsterBox.CreatureTypes;
import tux2.MonsterBox.MonsterBox;

public class MonsterBoxBlockListener
implements Listener {
    MonsterBox plugin;
    public ConcurrentHashMap<Integer, String> intmobs = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Integer> stringmobs = new ConcurrentHashMap();

    public MonsterBoxBlockListener(MonsterBox plugin) {
        CreatureTypes[] mobs;
        this.plugin = plugin;
        CreatureTypes[] creatureTypesArray = mobs = CreatureTypes.values();
        int n = mobs.length;
        int n2 = 0;
        while (n2 < n) {
            CreatureTypes mob = creatureTypesArray[n2];
            this.intmobs.put(new Integer(mob.id), mob.toString());
            this.stringmobs.put(mob.toString(), new Integer(mob.id));
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        event.getPlayer().getItemInHand();
        if (!event.isCancelled() && event.getBlock().getType() == Material.MOB_SPAWNER) {
            ItemStack is = event.getPlayer().getItemInHand();
            boolean nodrops = false;
            if (this.plugin.disabledspawnerlocs.containsKey(this.plugin.locationBuilder(event.getBlock().getLocation()))) {
                this.plugin.removeDisabledSpawner(event.getBlock());
                nodrops = true;
            }
            if (this.plugin.needssilktouch && !this.itemHasSilkTouch(is)) {
                return;
            }
            try {
                CreatureSpawner theSpawner = (CreatureSpawner)event.getBlock().getState();
                String monster = this.intmobs.get(new Integer(theSpawner.getSpawnedType().getTypeId()));
                if (this.plugin.hasPermissions(event.getPlayer(), "monsterbox.drops") || this.plugin.hasPermissions(event.getPlayer(), "monsterbox.dropegg")) {
                    if (nodrops) {
                        event.getPlayer().sendMessage(ChatColor.DARK_GREEN + "You just broke an " + ChatColor.RED + "unset" + ChatColor.DARK_GREEN + " spawner.");
                    } else {
                        event.getPlayer().sendMessage(ChatColor.DARK_GREEN + "You just broke a " + ChatColor.RED + monster.toLowerCase() + ChatColor.DARK_GREEN + " spawner.");
                    }
                }
                boolean mcmmofix = false;
                if (this.plugin.hasPermissions(event.getPlayer(), "monsterbox.drops")) {
                    ItemStack mobstack = new ItemStack(Material.MOB_SPAWNER, 1);
                    event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), mobstack);
                    mcmmofix = true;
                }
                if (!nodrops && this.stringmobs.containsKey(monster) && this.plugin.hasPermissions(event.getPlayer(), "monsterbox.dropegg." + monster.toLowerCase())) {
                    ItemStack eggstack = new ItemStack(383, 1, theSpawner.getSpawnedType().getTypeId());
                    event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), eggstack);
                    mcmmofix = true;
                }
                if (mcmmofix) {
                    event.getBlock().setType(Material.AIR);
                    event.setExpToDrop(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean itemHasSilkTouch(ItemStack is) {
        return is != null && is.containsEnchantment(Enchantment.SILK_TOUCH);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.isCancelled() && event.getBlockPlaced().getType() == Material.MOB_SPAWNER) {
            if (this.plugin.hasPermissions(event.getPlayer(), "monsterbox.place")) {
                this.plugin.addDisabledSpawner(event.getBlockPlaced());
            } else {
                event.setCancelled(true);
                event.getPlayer().sendMessage(ChatColor.DARK_RED + "You don't have permission to place a monster spawner.");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void explosion(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (Block block : event.blockList()) {
            if (block.getType() != Material.MOB_SPAWNER || !this.plugin.disabledspawnerlocs.containsKey(this.plugin.locationBuilder(block.getLocation()))) continue;
            this.plugin.removeDisabledSpawner(block);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void mobSpawn(CreatureSpawnEvent event) {
        if (!event.isCancelled() && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER && !this.plugin.canSpawnMob(event.getLocation(), event.getEntityType())) {
            event.setCancelled(true);
        }
    }
}

