/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.bukkit;

import java.util.ArrayList;
import mc.alk.bukkit.BukkitItemStack;
import mc.alk.bukkit.util.BukkitInventoryUtil;
import mc.alk.mc.MCInventory;
import mc.alk.mc.MCItemStack;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BukkitInventory
implements MCInventory {
    Inventory inventory;

    public BukkitInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void addItem(MCItemStack ... itemStacks) {
        for (MCItemStack item : itemStacks) {
            this.addItem(item);
        }
    }

    public void addItem(MCItemStack itemStack) {
        if (itemStack != null && itemStack.getType() == 0) {
            return;
        }
        BukkitInventory.addItemToInventory(this.inventory, ((BukkitItemStack)itemStack).getItem(), itemStack.getQuantity());
    }

    public static void addItemToInventory(Inventory inv, ItemStack is, int left) {
        int maxStackSize = is.getType().getMaxStackSize();
        if (left <= maxStackSize) {
            is.setAmount(left);
            inv.addItem(new ItemStack[]{is});
            return;
        }
        if (maxStackSize != 64) {
            Object[] iArray;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int i = 0;
            while ((double)i < Math.ceil(left / maxStackSize)) {
                if (left < maxStackSize) {
                    is.setAmount(left);
                    items.add(is);
                    return;
                }
                is.setAmount(maxStackSize);
                items.add(is);
                ++i;
            }
            for (Object o : iArray = items.toArray()) {
                inv.addItem(new ItemStack[]{(ItemStack)o});
            }
        } else {
            inv.addItem(new ItemStack[]{is});
        }
    }

    public void removeItem(MCItemStack itemStack) {
        BukkitInventoryUtil.removeItem(this.inventory, ((BukkitItemStack)itemStack).getItem());
    }

    public int getItemAmount(MCItemStack itemStack) {
        return BukkitInventoryUtil.getItemAmountFromInventory(this.inventory, ((BukkitItemStack)itemStack).getItem());
    }

    public boolean canFit(MCItemStack itemStack) {
        int space = BukkitInventoryUtil.amountFreeSpace(this.inventory, ((BukkitItemStack)itemStack).getItem(), itemStack.getQuantity());
        return space >= 0;
    }

    public int freeSpaceAfter(MCItemStack itemStack) {
        return BukkitInventoryUtil.amountFreeSpace(this.inventory, ((BukkitItemStack)itemStack).getItem(), itemStack.getQuantity());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public MCItemStack[] getContents() {
        ItemStack[] is = this.inventory.getContents();
        MCItemStack[] items = new MCItemStack[is.length];
        for (int i = 0; i < is.length; ++i) {
            items[i] = new BukkitItemStack(is[i]);
        }
        return items;
    }
}

