/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.bukkit;

import java.util.HashMap;
import java.util.Map;
import mc.alk.bukkit.util.BukkitInventoryUtil;
import mc.alk.mc.MCItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BukkitItemStack
implements MCItemStack {
    ItemStack itemStack;

    public BukkitItemStack(ItemStack itemStack) {
        this.itemStack = itemStack == null ? new ItemStack(0) : itemStack;
    }

    @Override
    public void setType(int id) {
        this.itemStack.setTypeId(id);
    }

    @Override
    public int getType() {
        return this.itemStack.getTypeId();
    }

    @Override
    public void setDataValue(short value) {
        this.itemStack.setDurability(value);
    }

    @Override
    public short getDataValue() {
        return this.itemStack.getDurability();
    }

    @Override
    public void setQuantity(int quantity) {
        this.itemStack.setAmount(quantity);
    }

    @Override
    public int getQuantity() {
        return this.itemStack.getAmount();
    }

    @Override
    public Map<Integer, Integer> getEnchantments() {
        HashMap<Integer, Integer> encs = new HashMap<Integer, Integer>();
        for (Map.Entry entry : this.itemStack.getEnchantments().entrySet()) {
            encs.put(((Enchantment)entry.getKey()).getId(), (Integer)entry.getValue());
        }
        return encs;
    }

    @Override
    public boolean hasMetaData() {
        return this.itemStack.hasItemMeta();
    }

    @Override
    public String getCommonName() {
        return BukkitInventoryUtil.getCommonName(this.itemStack);
    }

    @Override
    public MCItemStack clone() {
        return new BukkitItemStack(this.itemStack.clone());
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    public String toString() {
        return this.itemStack != null ? "[" + this.itemStack.getType() + ":" + this.itemStack.getDurability() + " q=" + this.getQuantity() + "]" : "null";
    }

    @Override
    public void addEnchantment(int id, int level) {
        this.itemStack.addEnchantment(Enchantment.getById((int)id), level);
    }

    public void addEnchantment(Enchantment enc, int level) {
        this.itemStack.addEnchantment(enc, level);
    }

    @Override
    public int isSpecial() {
        int special = 0;
        return special;
    }
}

