/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.bukkit.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mc.alk.mc.util.MCInventoryUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BukkitInventoryUtil
implements MCInventoryUtil {
    public static HashMap<String, ItemStack> commonToStack = new HashMap();
    public static HashMap<String, String> idToCommon = new HashMap();
    public static final HashMap<String, ItemStack> itemNames = new HashMap();

    public static int getItemAmountFromInventory(Inventory inv, ItemStack is) {
        return BukkitInventoryUtil.getItemAmount(inv.getContents(), is);
    }

    public static boolean sameItem(ItemStack is1, ItemStack is2, boolean checkDura) {
        if (is1 == null || is2 == null) {
            return false;
        }
        if (is1.getType() != is2.getType()) {
            return false;
        }
        if (checkDura && is1.getDurability() != -1 && is1.getDurability() != is2.getDurability()) {
            return false;
        }
        Map e1 = is1.getEnchantments();
        Map e2 = is2.getEnchantments();
        return e1.size() == e2.size();
    }

    public static int getItemAmount(ItemStack[] items, ItemStack is) {
        boolean checkDurability = true;
        int count = 0;
        for (ItemStack item : items) {
            if (!BukkitInventoryUtil.sameItem(item, is, checkDurability) || item.getAmount() <= 0) continue;
            count += item.getAmount();
        }
        return count;
    }

    public static boolean checkFreeSpace(Chest chest, ItemStack is, int left) {
        Inventory inv = chest.getInventory();
        return BukkitInventoryUtil.checkFreeSpace(inv, is, left);
    }

    public static boolean checkFreeSpace(Inventory inv, ItemStack is, int left) {
        return BukkitInventoryUtil.checkFreeSpace(inv.getContents(), is, left);
    }

    public static boolean checkFreeSpace(ItemStack[] contents, ItemStack is, int left) {
        int maxStack = is.getType().getMaxStackSize();
        for (ItemStack curitem : contents) {
            int amount;
            if (left <= 0) {
                return true;
            }
            if (curitem == null || curitem.getType() == Material.AIR) {
                left -= maxStack;
                continue;
            }
            if (!BukkitInventoryUtil.sameItem(curitem, is, true) || (amount = curitem.getAmount()) >= maxStack) continue;
            left -= maxStack - amount;
        }
        return left <= 0;
    }

    public static int amountFreeSpace(ItemStack[] contents, ItemStack is, int left) {
        int maxStack = is.getType().getMaxStackSize();
        for (ItemStack curitem : contents) {
            int amount;
            if (curitem == null) {
                left -= maxStack;
                continue;
            }
            if (!BukkitInventoryUtil.sameItem(curitem, is, true) || (amount = curitem.getAmount()) >= maxStack) continue;
            left -= maxStack - amount;
        }
        return -left;
    }

    public static int amountFreeSpace(Chest chest, ItemStack is, int left) {
        Inventory inv = chest.getInventory();
        return BukkitInventoryUtil.amountFreeSpace(inv, is, left);
    }

    public static int amountFreeSpace(Inventory inv, ItemStack is, int left) {
        return BukkitInventoryUtil.amountFreeSpace(inv.getContents(), is, left);
    }

    public static void addItemToInventory(Player player, ItemStack itemStack, int stockAmount) {
        BukkitInventoryUtil.addItemToInventory((Inventory)player.getInventory(), itemStack, stockAmount);
        player.updateInventory();
    }

    public static void addItemToInventory(Chest chest, ItemStack is, int left) {
        BukkitInventoryUtil.addItemToInventory(chest.getInventory(), is, left);
    }

    public static void addItemToInventory(Inventory inv, ItemStack is, int left) {
        int maxStackSize = is.getType().getMaxStackSize();
        if (left <= maxStackSize) {
            is.setAmount(left);
            inv.addItem(new ItemStack[]{is});
            return;
        }
        if (maxStackSize != 64) {
            Object[] iArray;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int i = 0;
            while ((double)i < Math.ceil(left / maxStackSize)) {
                if (left < maxStackSize) {
                    is.setAmount(left);
                    items.add(is);
                    return;
                }
                is.setAmount(maxStackSize);
                items.add(is);
                ++i;
            }
            for (Object o : iArray = items.toArray()) {
                inv.addItem(new ItemStack[]{(ItemStack)o});
            }
        } else {
            inv.addItem(new ItemStack[]{is});
        }
    }

    public static int first(Inventory inv, ItemStack is1) {
        if (is1 == null) {
            return -1;
        }
        ItemStack[] inventory = inv.getContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack is2 = inventory[i];
            if (is2 == null || !BukkitInventoryUtil.sameItem(is1, is2, true)) continue;
            return i;
        }
        return -1;
    }

    public static HashMap<Integer, ItemStack> removeItem(Inventory inv, ItemStack ... items) {
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = BukkitInventoryUtil.first(inv, item)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = inv.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    inv.setItem(first, null);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                inv.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
        }
        return leftover;
    }

    public static String printItemStack(ItemStack is) {
        StringBuilder sb = new StringBuilder("[ItemStack] " + is.getTypeId() + ":" + is.getAmount() + " dura=" + is.getDurability());
        if (is.getData() != null) {
            sb.append(" data=" + is.getData() + "  d.itemType=" + is.getData().getItemType() + " d.itemTypeId=" + is.getData().getItemTypeId() + " d.data=" + is.getData().getData());
        } else {
            sb.append(" data=null");
        }
        return sb.toString();
    }

    public static ItemStack getItemStack(String name) {
        ItemStack is;
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.replace(" ", "_");
        name = name.replace(";", ":");
        name = BukkitInventoryUtil.decolorChat(name);
        name = name.toLowerCase();
        String[] split = name.split(":");
        short dataValue = 0;
        if (split.length > 1 && BukkitInventoryUtil.isInt(split[1])) {
            int i = Integer.valueOf(split[1]);
            dataValue = (short)i;
            name = split[0];
        }
        if ((is = itemNames.get(name)) != null) {
            return is;
        }
        Material mat = Material.matchMaterial((String)name);
        if (mat != null && mat != Material.AIR) {
            return new ItemStack(mat.getId(), 1, dataValue);
        }
        is = commonToStack.get(name);
        if (is == null) {
            for (String itemName : commonToStack.keySet()) {
                int index = itemName.indexOf(name, 0);
                if (index == -1 || index != 0) continue;
                is = commonToStack.get(itemName);
                return is;
            }
        } else {
            is.setAmount(1);
        }
        return is;
    }

    public static boolean isInt(String i) {
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String decolorChat(String string) {
        string = string.replaceAll("&[0-9a-fA-F]", "");
        string = ChatColor.stripColor((String)string);
        return string;
    }

    public static String getCommonName(ItemStack is) {
        int id = is.getTypeId();
        short datavalue = is.getDurability();
        String iname = "";
        try {
            String idkey;
            String cname;
            if (datavalue > 0) {
                iname = Material.getMaterial((int)id).toString() + ":" + datavalue;
            }
            if ((cname = idToCommon.get(idkey = id + ":" + datavalue)) != null) {
                return cname;
            }
            iname = Material.getMaterial((int)id).toString().toLowerCase() + " durability(" + datavalue + ")";
        }
        catch (Exception e) {
            System.err.println("Error getting commonName id=" + id + "   iname=" + iname + "   datavalue=" + datavalue);
            e.printStackTrace();
        }
        return iname;
    }

    public static String getCustomName(ItemStack item) {
        ItemMeta im = item.getItemMeta();
        if (im == null) {
            return item.getType().name().toLowerCase();
        }
        String displayName = im.getDisplayName();
        return displayName == null || displayName.isEmpty() ? item.getType().name().toLowerCase() : displayName;
    }

    public static ItemStack getItemStack(int id, short datavalue) {
        return new ItemStack(id, 1, datavalue);
    }

    static {
        itemNames.put("light_gray_wool", new ItemStack(Material.WOOL.getId(), 1, 8));
        itemNames.put("stone_brick", new ItemStack(Material.SMOOTH_BRICK, 1, 0));
        itemNames.put("mossy_stone", new ItemStack(Material.SMOOTH_BRICK, 1, 1));
        itemNames.put("mossy_smooth", new ItemStack(Material.SMOOTH_BRICK, 1, 1));
        itemNames.put("cracked_stone", new ItemStack(Material.SMOOTH_BRICK, 1, 2));
        itemNames.put("piston", new ItemStack(Material.PISTON_BASE, 1, 0));
        itemNames.put("sticky_piston", new ItemStack(Material.PISTON_STICKY_BASE, 1, 0));
        itemNames.put("long_grass", new ItemStack(Material.GRASS, 1, 0));
        itemNames.put("fern", new ItemStack(Material.GRASS, 1, 0));
        itemNames.put("mycelium", new ItemStack(Material.MYCEL, 1, 0));
        itemNames.put("nether_wart", new ItemStack(Material.NETHER_STALK, 1, 0));
        itemNames.put("redstone_lamp", new ItemStack(Material.REDSTONE_LAMP_OFF, 1, 0));
        itemNames.put("redstone_torch", new ItemStack(Material.REDSTONE_TORCH_ON, 1, 0));
        itemNames.put("carrot", new ItemStack(Material.CARROT_ITEM, 1, 0));
        itemNames.put("carrots", new ItemStack(Material.CARROT, 1, 0));
        itemNames.put("carrot_seed", new ItemStack(Material.CARROT, 1, 0));
        itemNames.put("potato", new ItemStack(Material.POTATO_ITEM, 1, 0));
        itemNames.put("potatoes", new ItemStack(Material.POTATO, 1, 0));
        itemNames.put("potato_seed", new ItemStack(Material.POTATO, 1, 0));
        block2: for (Material m : Material.values()) {
            for (int i = 0; i < 64; ++i) {
                try {
                    String s = m.getNewData((byte)i).toString();
                    s = s.replaceAll("null", "");
                    s = s.replaceAll("generic", "");
                    s = s.replaceAll("\\(\\d+\\)$", "");
                    s = s.replaceAll("durability.*", "");
                    s = s.replaceAll(" up ", "");
                    s = s.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
                    s = s.replaceAll(" ", "_");
                    s = s.toLowerCase();
                    if (s.split("_").length > 3 || s.contains("(") || s.contains(")") || commonToStack.containsKey(s)) continue block2;
                    ItemStack is = m.getNewData((byte)i).toItemStack();
                    is.setAmount(1);
                    commonToStack.put(s, is);
                    s = s.replaceAll("_", " ");
                    idToCommon.put(is.getTypeId() + ":" + is.getDurability(), s);
                    continue;
                }
                catch (Exception e) {
                    continue block2;
                }
            }
        }
    }
}

