/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.controllers;

import mc.alk.util.Log;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class MoneyController
implements Listener {
    static boolean initialized = false;
    static boolean hasVault = false;
    static boolean useVault = false;
    public static Economy economy = null;

    public static boolean hasEconomy() {
        return initialized;
    }

    public static boolean hasAccount(String name) {
        if (!initialized) {
            return true;
        }
        return useVault ? economy.hasAccount(name) : true;
    }

    public static boolean hasEnough(String name, double fee) {
        if (!initialized) {
            return true;
        }
        return MoneyController.hasEnough(name, (float)fee);
    }

    public static boolean hasEnough(String name, float amount) {
        if (!initialized) {
            return true;
        }
        return useVault ? economy.getBalance(name) >= (double)amount : true;
    }

    public static boolean hasEnough(String name, float amount, String world) {
        return MoneyController.hasEnough(name, amount);
    }

    public static void subtract(String name, float amount, String world) {
        MoneyController.subtract(name, amount);
    }

    public static void subtract(String name, double amount) {
        MoneyController.subtract(name, (float)amount);
    }

    public static void subtract(String name, float amount) {
        if (!initialized) {
            return;
        }
        if (useVault) {
            economy.withdrawPlayer(name, (double)amount);
        }
    }

    public static void add(String name, float amount, String world) {
        MoneyController.add(name, amount);
    }

    public static void add(String name, double amount) {
        if (!initialized) {
            return;
        }
        MoneyController.add(name, (float)amount);
    }

    public static void add(String name, float amount) {
        if (!initialized) {
            return;
        }
        if (useVault) {
            economy.depositPlayer(name, (double)amount);
        }
    }

    public static Double balance(String name, String world) {
        return MoneyController.balance(name);
    }

    public static Double balance(String name) {
        if (!initialized) {
            return 0.0;
        }
        return useVault ? economy.getBalance(name) : 0.0;
    }

    public static void setup(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)new MoneyController(), plugin);
        MoneyController.checkRegisteredPlugins();
    }

    @EventHandler
    public void setup(PluginEnableEvent event) {
        MoneyController.checkRegisteredPlugins();
    }

    private static void checkRegisteredPlugins() {
        Plugin controller;
        if (useVault) {
            return;
        }
        if (economy == null && (controller = Bukkit.getServer().getPluginManager().getPlugin("Vault")) != null) {
            RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider == null || economyProvider.getProvider() == null) {
                economy = null;
                Log.warn("[] found no economy plugin. Attempts to use money in arenas might result in errors.");
                return;
            }
            economy = (Economy)economyProvider.getProvider();
            hasVault = true;
            useVault = true;
            initialized = true;
            Log.info("[] found economy plugin Vault. [Default]");
        }
    }
}

