/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.serializers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public abstract class SQLSerializer {
    public static final String version = "1.3.2";
    protected static final boolean DEBUG = false;
    static final boolean DEBUG_UPDATE = false;
    public static final int MAX_NAME_LENGTH = 16;
    private DataSource ds;
    protected String DB = "minecraft";
    protected SQLType TYPE = SQLType.MYSQL;
    protected String URL = "localhost";
    protected String PORT = "3306";
    protected String USERNAME = "root";
    protected String PASSWORD = "";
    private String create_database = "CREATE DATABASE IF NOT EXISTS `" + this.DB + "`";

    public String getURL() {
        return this.URL;
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public String getPort() {
        return this.PORT;
    }

    public void setPort(String port) {
        this.PORT = port;
    }

    public String getUsername() {
        return this.USERNAME;
    }

    public void setUsername(String username) {
        this.USERNAME = username;
    }

    public String getPassword() {
        return this.PASSWORD;
    }

    public void setPassword(String password) {
        this.PASSWORD = password;
    }

    public void setType(SQLType type) {
        this.TYPE = type;
    }

    public SQLType getType() {
        return this.TYPE;
    }

    public String getDB() {
        return this.DB;
    }

    public void setDB(String dB) {
        this.DB = dB;
        this.create_database = "CREATE DATABASE IF NOT EXISTS `" + this.DB + "`";
    }

    protected void close(RSCon rscon) {
        try {
            rscon.rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection(boolean displayErrors) throws SQLException {
        return this.getConnection(displayErrors, true);
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(true, true);
    }

    public Connection getConnection(boolean displayErrors, boolean autoCommit) throws SQLException {
        if (this.ds == null) {
            throw new SQLException("Connection is null.  Did you intiliaze your SQL connection?");
        }
        try {
            Connection con = this.ds.getConnection();
            con.setAutoCommit(autoCommit);
            return con;
        }
        catch (SQLException e1) {
            if (displayErrors) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    public void closeConnection(RSCon rscon) {
        if (rscon == null || rscon.con == null) {
            return;
        }
        try {
            rscon.con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean init() {
        Connection con = null;
        try {
            Class.forName(this.TYPE.getDriver());
        }
        catch (ClassNotFoundException e1) {
            System.err.println("Failed getting driver " + this.TYPE.getDriver());
            e1.printStackTrace();
            return false;
        }
        String connectionString = null;
        String datasourceString = null;
        switch (this.TYPE) {
            case SQLITE: {
                datasourceString = connectionString = "jdbc:sqlite:" + this.URL + "/" + this.DB + ".sqlite";
                break;
            }
            default: {
                datasourceString = "jdbc:mysql://" + this.URL + ":" + this.PORT + "/" + this.DB + "?autoReconnect=true";
                connectionString = "jdbc:mysql://" + this.URL + ":" + this.PORT + "?autoReconnect=true";
            }
        }
        try {
            this.ds = SQLSerializer.setupDataSource(datasourceString, this.USERNAME, this.PASSWORD, 10, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.TYPE == SQLType.MYSQL) {
            String strStmt = this.create_database;
            try {
                con = DriverManager.getConnection(connectionString, this.USERNAME, this.PASSWORD);
                Statement st = con.createStatement();
                st.executeUpdate(strStmt);
                this.closeConnection(con);
            }
            catch (SQLException e) {
                try {
                    System.err.println("Failed creating db: " + strStmt);
                    e.printStackTrace();
                    boolean bl = false;
                    this.closeConnection(con);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.closeConnection(con);
                    throw throwable;
                }
            }
        }
        return true;
    }

    public static DataSource setupDataSource(String connectURI, String username, String password, int minIdle, int maxActive) throws Exception {
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        connectionPool.setMinIdle(minIdle);
        connectionPool.setMaxActive(maxActive);
        connectionPool.setTestOnBorrow(true);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, username, password);
        boolean defaultReadOnly = false;
        boolean defaultAutoCommit = true;
        String validationQuery = null;
        GenericKeyedObjectPoolFactory statementPool = new GenericKeyedObjectPoolFactory(null);
        PoolableConnectionFactory factory = new PoolableConnectionFactory(connectionFactory, connectionPool, statementPool, validationQuery, false, true);
        factory.setValidationQuery("select 1");
        PoolingDataSource dataSource = new PoolingDataSource(connectionPool);
        return dataSource;
    }

    protected boolean createTable(Connection con, String tableName, String sql_create_table, String ... sql_updates) {
        List<Object> objs;
        Boolean exists = this.TYPE == SQLType.SQLITE ? this.getBoolean("SELECT count(name) FROM sqlite_master WHERE type='table' AND name='" + tableName + "';", new Object[0]) : Boolean.valueOf((objs = this.getObjects("SHOW TABLES LIKE '" + tableName + "';", new Object[0])) != null && objs.size() == 1);
        if (exists != null && exists.booleanValue()) {
            return true;
        }
        String strStmt = sql_create_table;
        Statement st = null;
        int result = 0;
        try {
            st = con.createStatement();
            result = st.executeUpdate(strStmt);
        }
        catch (SQLException e) {
            System.err.println("Failed in creating Table " + strStmt + " result=" + result);
            e.printStackTrace();
            return false;
        }
        if (sql_updates != null) {
            for (String sql_update : sql_updates) {
                if (sql_update == null) continue;
                strStmt = sql_update;
                try {
                    st = con.createStatement();
                    result = st.executeUpdate(strStmt);
                }
                catch (SQLException e) {
                    System.err.println("Failed in updating Table " + strStmt + " result=" + result);
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    protected Boolean hasColumn(String table, String column) {
        String stmt = null;
        Boolean b = null;
        switch (this.TYPE) {
            case MYSQL: {
                stmt = "SELECT COUNT(*) FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?";
                b = this.getBoolean(true, stmt, this.DB, table, column);
                return b == null ? false : b;
            }
            case SQLITE: {
                stmt = "SELECT COUNT(" + column + ") FROM '" + table + "'";
                try {
                    b = this.getBoolean(false, stmt, new Object[0]);
                    return b != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    protected Boolean hasTable(String tableName) {
        List<Object> objs;
        Boolean exists = this.TYPE == SQLType.SQLITE ? this.getBoolean("SELECT count(name) FROM sqlite_master WHERE type='table' AND name='" + tableName + "';", new Object[0]) : Boolean.valueOf((objs = this.getObjects("SHOW TABLES LIKE '" + tableName + "';", new Object[0])) != null && objs.size() == 1);
        return exists;
    }

    protected RSCon executeQuery(String strRawStmt, Object ... varArgs) {
        return this.executeQuery(true, strRawStmt, varArgs);
    }

    protected RSCon executeQuery(boolean displayErrors, String strRawStmt, Object ... varArgs) {
        RSCon rscon;
        block5: {
            Connection con = null;
            try {
                con = this.getConnection();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
            PreparedStatement ps = null;
            rscon = null;
            try {
                ps = this.getStatement(displayErrors, strRawStmt, con, varArgs);
                ResultSet rs = ps.executeQuery();
                rscon = new RSCon();
                rscon.con = con;
                rscon.rs = rs;
            }
            catch (Exception e) {
                if (!displayErrors) break block5;
                System.err.println("Couldnt execute query " + ps);
                for (int i = 0; i < varArgs.length; ++i) {
                    System.err.println("   arg[" + i + "] = " + varArgs[i]);
                }
                e.printStackTrace();
            }
        }
        return rscon;
    }

    protected void executeUpdate(boolean async, final String strRawStmt, final Object ... varArgs) {
        if (async) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLSerializer.this.executeUpdate(strRawStmt, varArgs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        } else {
            try {
                this.executeUpdate(strRawStmt, varArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(String strRawStmt, Object ... varArgs) {
        int result = -1;
        Connection con = null;
        try {
            con = this.getConnection();
        }
        catch (SQLException e) {
            System.err.println("Couldnt execute update raw='" + strRawStmt + "'");
            e.printStackTrace();
            return -1;
        }
        PreparedStatement ps = null;
        try {
            ps = this.getStatement(strRawStmt, con, varArgs);
            result = ps.executeUpdate();
        }
        catch (Exception e) {
            System.err.println("Couldnt execute update " + ps);
            e.printStackTrace();
        }
        finally {
            this.closeConnection(con);
        }
        return result;
    }

    protected void executeBatch(boolean async, final String updateStatement, final List<List<Object>> batch) {
        if (async) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLSerializer.this.executeBatch(updateStatement, batch);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        } else {
            try {
                this.executeBatch(updateStatement, batch);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeBatch(String updateStatement, List<List<Object>> batch) {
        Connection con = null;
        try {
            con = this.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        PreparedStatement ps = null;
        try {
            con.setAutoCommit(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ps = con.prepareStatement(updateStatement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (List<Object> update : batch) {
            try {
                for (int i = 0; i < update.size(); ++i) {
                    ps.setObject(i + 1, update.get(i));
                }
                ps.addBatch();
            }
            catch (Exception e) {
                System.err.println("statement = " + ps);
                e.printStackTrace();
            }
        }
        try {
            ps.executeBatch();
            con.commit();
        }
        catch (Exception e) {
            System.err.println("statement = " + updateStatement + " preparedStatement=" + ps);
            for (List<Object> objs : batch) {
                for (Object o : objs) {
                    System.err.print(o + ",");
                }
                System.err.println();
            }
            e.printStackTrace();
        }
        finally {
            this.closeConnection(con);
        }
    }

    protected PreparedStatement getStatement(String strRawStmt, Connection con, Object ... varArgs) {
        return this.getStatement(true, strRawStmt, con, varArgs);
    }

    protected PreparedStatement getStatement(boolean displayErrors, String strRawStmt, Connection con, Object ... varArgs) {
        PreparedStatement ps;
        block4: {
            ps = null;
            try {
                ps = con.prepareStatement(strRawStmt);
                for (int i = 0; i < varArgs.length; ++i) {
                    ps.setObject(i + 1, varArgs[i]);
                }
            }
            catch (Exception e) {
                if (!displayErrors) break block4;
                System.err.println("Couldnt prepare statment " + ps + "   rawStmt='" + strRawStmt + "' args=" + varArgs);
                for (int i = 0; i < varArgs.length; ++i) {
                    System.err.println("   arg[" + i + "] = " + varArgs[i]);
                }
                e.printStackTrace();
            }
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getDouble(String query, Object ... varArgs) {
        RSCon rscon = this.executeQuery(query, varArgs);
        if (rscon == null || rscon.con == null) {
            return null;
        }
        try {
            ResultSet rs = rscon.rs;
            if (rs.next()) {
                Double d = rs.getDouble(1);
                return d;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rscon.con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getInteger(String query, Object ... varArgs) {
        RSCon rscon = this.executeQuery(query, varArgs);
        if (rscon == null || rscon.con == null) {
            return null;
        }
        try {
            ResultSet rs = rscon.rs;
            if (rs.next()) {
                Integer n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rscon.con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getShort(String query, Object ... varArgs) {
        RSCon rscon = this.executeQuery(query, varArgs);
        if (rscon == null || rscon.con == null) {
            return null;
        }
        try {
            ResultSet rs = rscon.rs;
            if (rs.next()) {
                Short s = rs.getShort(1);
                return s;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rscon.con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLong(String query, Object ... varArgs) {
        RSCon rscon = this.executeQuery(query, varArgs);
        if (rscon == null || rscon.con == null) {
            return null;
        }
        try {
            ResultSet rs = rscon.rs;
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rscon.con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    public Boolean getBoolean(String query, Object ... varArgs) {
        return this.getBoolean(true, query, varArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean getBoolean(boolean displayErrors, String query, Object ... varArgs) {
        block19: {
            Boolean bl;
            RSCon rscon = this.executeQuery(displayErrors, query, varArgs);
            if (rscon == null || rscon.con == null) {
                return null;
            }
            try {
                ResultSet rs = rscon.rs;
                if (!rs.next()) break block19;
                Integer i = rs.getInt(1);
                if (i == null) {
                    Boolean bl2 = null;
                    return bl2;
                }
                bl = i > 0;
            }
            catch (SQLException e) {
                if (displayErrors) {
                    e.printStackTrace();
                }
                break block19;
            }
            finally {
                try {
                    rscon.con.close();
                }
                catch (Exception e) {}
            }
            return bl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String query, Object ... varArgs) {
        RSCon rscon = this.executeQuery(query, varArgs);
        if (rscon == null || rscon.con == null) {
            return null;
        }
        try {
            ResultSet rs = rscon.rs;
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rscon.con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getObjects(String query, Object ... varArgs) {
        RSCon rscon = this.executeQuery(query, varArgs);
        if (rscon == null || rscon.con == null) {
            return null;
        }
        try {
            ResultSet rs = rscon.rs;
            if (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                int nCol = rsmd.getColumnCount();
                ArrayList<Object> objs = new ArrayList<Object>(nCol);
                for (int i = 0; i < nCol; ++i) {
                    objs.add(rs.getObject(i + 1));
                }
                ArrayList<Object> arrayList = objs;
                return arrayList;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rscon.con.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    protected ArrayList<Map<String, Object>> convertToResult(RSCon rscon) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        try {
            ResultSet rs = rscon.rs;
            if (rs == null) {
                return null;
            }
            ResultSetMetaData rmd = rs.getMetaData();
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 1; i < rmd.getColumnCount() + 1; ++i) {
                    row.put(rmd.getColumnName(i), rs.getObject(i));
                }
                values.add(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return values;
    }

    protected String getString(Map<String, Object> map, String key) {
        return map.get(key).toString();
    }

    protected Integer getInt(Map<String, Object> map, String key) {
        return Integer.valueOf(map.get(key).toString());
    }

    protected class RSCon {
        public ResultSet rs;
        public Connection con;

        protected RSCon() {
        }
    }

    public static enum SQLType {
        MYSQL("MySQL", "com.mysql.jdbc.Driver"),
        SQLITE("SQLite", "org.sqlite.JDBC");

        String name;
        String driver;

        private SQLType(String name, String driver) {
            this.name = name;
            this.driver = driver;
        }

        public String getName() {
            return this.name;
        }

        public String getDriver() {
            return this.driver;
        }
    }
}

