/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.bukkit;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import mc.alk.bukkit.BukkitServer;
import mc.alk.controllers.MoneyController;
import mc.alk.serializers.SQLSerializerConfig;
import mc.alk.shops.BattleShops;
import mc.alk.shops.BattleShopsPlugin;
import mc.alk.shops.bukkit.controllers.BukkitMessageController;
import mc.alk.shops.bukkit.controllers.BukkitPermController;
import mc.alk.shops.bukkit.controllers.ConfigController;
import mc.alk.shops.bukkit.executors.BukkitPlayerTransactionsExecutor;
import mc.alk.shops.bukkit.executors.BukkitShopTransactionsExecutor;
import mc.alk.shops.bukkit.executors.BukkitShopsExecutor;
import mc.alk.shops.bukkit.listeners.ShopsBlockListener;
import mc.alk.shops.bukkit.listeners.ShopsInventoryListener;
import mc.alk.shops.bukkit.listeners.ShopsPluginListener;
import mc.alk.shops.bukkit.listeners.ShopsSignChestListener;
import mc.alk.shops.bukkit.listeners.ShopsSignListener;
import mc.alk.shops.bukkit.util.BukkitInventoryUtil;
import mc.alk.shops.bukkit.util.BukkitWorldUtil;
import mc.alk.shops.controllers.LinkController;
import mc.alk.shops.controllers.TransactionController;
import mc.alk.shops.controllers.TransactionLogger;
import mc.alk.shops.serializers.SQLInstance;
import mc.alk.shops.serializers.YamlMessageUpdater;
import mc.alk.shops.utils.FileUtil;
import mc.alk.util.Log;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitBattleShops
extends JavaPlugin
implements BattleShopsPlugin {
    private static String pluginname;
    private static String version;
    private static BukkitBattleShops plugin;
    SQLInstance sql;
    TransactionLogger transactionLogger;
    Timer timer = new Timer();

    public void onEnable() {
        plugin = this;
        PluginDescriptionFile pdfFile = this.getDescription();
        pluginname = pdfFile.getName();
        version = pdfFile.getVersion();
        Log.info("[" + pluginname + "]" + " version " + version + " starting");
        File dir = this.getDataFolder();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.setEnabled(true);
        this.loadConfigFiles();
        MoneyController.setup((Plugin)this);
        BattleShops.init(new BukkitServer(), this, new BukkitPermController(), new BukkitInventoryUtil(), this.sql, new BukkitWorldUtil());
        LinkController linkController = new LinkController();
        TransactionController transactionController = new TransactionController(this.transactionLogger);
        if (!MoneyController.hasEconomy()) {
            Log.err("[" + pluginname + "] needs an economy but Vault doesn't have one.  Disabling");
            this.setEnabled(false);
            return;
        }
        ShopsSignChestListener playerListener = new ShopsSignChestListener(linkController, transactionController);
        ShopsInventoryListener invListener = new ShopsInventoryListener(linkController, transactionController);
        BukkitShopsExecutor shopExecutor = new BukkitShopsExecutor(playerListener, linkController, BattleShops.getShopSerializer());
        BukkitShopTransactionsExecutor strExecutor = new BukkitShopTransactionsExecutor(playerListener, linkController, BattleShops.getShopSerializer());
        BukkitPlayerTransactionsExecutor ptrExecutor = new BukkitPlayerTransactionsExecutor(playerListener, linkController, BattleShops.getShopSerializer());
        this.getCommand("shop").setExecutor((CommandExecutor)shopExecutor);
        this.getCommand("shoptransactions").setExecutor((CommandExecutor)strExecutor);
        this.getCommand("playertransactions").setExecutor((CommandExecutor)ptrExecutor);
        ShopsPluginListener pluginListener = new ShopsPluginListener();
        pluginListener.loadAll();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)playerListener, (Plugin)this);
        pm.registerEvents((Listener)invListener, (Plugin)this);
        pm.registerEvents((Listener)new ShopsBlockListener(), (Plugin)this);
        pm.registerEvents((Listener)new ShopsSignListener(), (Plugin)this);
        pm.registerEvents((Listener)pluginListener, (Plugin)this);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BukkitBattleShops.this.sql.saveAll();
            }
        }, 60000L, 600000L);
        this.sql.loadAll();
        Log.info("[" + pluginname + "]" + " version " + version + " initialized!");
    }

    public void onDisable() {
        this.sql.saveAll();
    }

    private void loadConfigFiles() {
        ConfigController.setConfig(FileUtil.load(this.getClass(), "plugins/BattleShops/config.yml", "/default_files/config.yml"));
        BukkitMessageController.setConfig(FileUtil.load(this.getClass(), "plugins/BattleShops/messages.yml", "/default_files/messages.yml"));
        YamlMessageUpdater mu = new YamlMessageUpdater();
        mu.update(BukkitMessageController.getConfig(), BukkitMessageController.getFile(), new File(plugin.getDataFolder() + "/backups"));
        this.transactionLogger = new TransactionLogger();
        this.sql = new SQLInstance(this.transactionLogger);
        SQLSerializerConfig.configureSQL(this, this.sql, ConfigController.getConfig().getConfigurationSection("SQLOptions"));
        BukkitMessageController.setConfig(BukkitMessageController.getFile());
    }

    public static boolean enabled() {
        return plugin.isEnabled();
    }

    @Override
    public BattleShopsPlugin getSelf() {
        return plugin;
    }

    @Override
    public File getDataDirectory() {
        return this.getDataFolder();
    }
}

