/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.bukkit.listeners;

import mc.alk.bukkit.BukkitBlock;
import mc.alk.bukkit.BukkitPlayer;
import mc.alk.bukkit.blocks.BukkitChest;
import mc.alk.bukkit.blocks.BukkitSign;
import mc.alk.mc.MCBlock;
import mc.alk.mc.MCLocation;
import mc.alk.mc.MCPlayer;
import mc.alk.shops.Defaults;
import mc.alk.shops.controllers.LinkController;
import mc.alk.shops.controllers.PermController;
import mc.alk.shops.controllers.ShopController;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.objects.ShopSign;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class ShopsBlockListener
implements Listener {
    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Material mat = event.getBlock().getType();
        if (mat.equals((Object)Material.SIGN) || mat.equals((Object)Material.SIGN_POST) || mat.equals((Object)Material.WALL_SIGN)) {
            BukkitPlayer player = new BukkitPlayer(event.getPlayer());
            BukkitBlock block = new BukkitBlock(event.getBlock());
            MCLocation loc = block.getLocation();
            if (ShopController.hasShopSignAt(loc)) {
                if (PermController.hasAllCreatePermissions(player, loc)) {
                    ShopSign ss = ShopController.getShopSign(loc);
                    if (!PermController.isAdmin(player) && Defaults.DISABLE_PLAYER_SIGN_BREAK && !ShopOwner.sameOwner(ss.getOwner(), new ShopOwner(player.getName()))) {
                        event.setCancelled(true);
                        player.sendMessage(ChatColor.RED + "You can't break a sign you don't own");
                    } else {
                        this.breakShopSign(event, player, block);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        } else if (mat.equals((Object)Material.CHEST)) {
            BukkitPlayer player = new BukkitPlayer(event.getPlayer());
            BukkitChest chest = new BukkitChest((Chest)event.getBlock().getState());
            MCLocation loc = chest.getLocation();
            if (ShopController.hasShopChestAt(chest)) {
                if (PermController.hasAllCreatePermissions(player, loc)) {
                    LinkController.breakChestShop(chest);
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }

    private void breakShopSign(BlockBreakEvent event, MCPlayer player, MCBlock block) {
        ShopSign ss = ShopController.getShopSign(block.getLocation());
        LinkController.breakShopSign(new BukkitSign((Sign)event.getBlock().getState()));
        if (ShopOwner.sameOwner(ss.getOwner(), new ShopOwner(player.getName()))) {
            ShopController.playerUpdatedShop(ss.getOwner().getName());
        }
    }
}

