/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.bukkit.listeners;

import java.util.HashMap;
import mc.alk.bukkit.BukkitLocation;
import mc.alk.bukkit.BukkitPlayer;
import mc.alk.bukkit.blocks.BukkitChest;
import mc.alk.bukkit.blocks.BukkitSign;
import mc.alk.mc.MCPlayer;
import mc.alk.shops.Defaults;
import mc.alk.shops.bukkit.controllers.BukkitMessageController;
import mc.alk.shops.controllers.LinkController;
import mc.alk.shops.controllers.PermController;
import mc.alk.shops.controllers.Shop;
import mc.alk.shops.controllers.ShopController;
import mc.alk.shops.controllers.SignParser;
import mc.alk.shops.controllers.TransactionController;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.objects.ShopSign;
import mc.alk.shops.objects.SignFormatException;
import mc.alk.shops.objects.SignValues;
import mc.alk.shops.utils.Pair;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public class ShopsSignChestListener
implements Listener {
    public static final int BUY_INT = 0;
    public static final int SELL_INT = 1;
    public static int interval = 300;
    private HashMap<String, Long> userTime = new HashMap();
    private HashMap<String, Long> userCommandTime = new HashMap();
    private HashMap<String, Pair<Integer, Integer>> userMultiplier = new HashMap();
    private LinkController linkController = null;
    private TransactionController tc = null;

    public ShopsSignChestListener(LinkController link, TransactionController tc) {
        this.linkController = link;
        this.tc = tc;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChestInteract(PlayerInteractEvent event) {
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        Material clickedMat = clickedBlock.getType();
        if (!clickedMat.equals((Object)Material.CHEST) || event.isCancelled()) {
            return;
        }
        BukkitPlayer player = new BukkitPlayer(event.getPlayer());
        BukkitLocation bloc = new BukkitLocation(clickedBlock.getLocation());
        Action action = event.getAction();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Chest chest = (Chest)clickedBlock.getState();
            this.linkController.chestRightClick(new BukkitChest(chest), player);
        } else if (event.getItem() != null && event.getItem().getTypeId() == Defaults.WAND.intValue()) {
            boolean hasPermissionToBuild = PermController.hasAllCreatePermissions(player, bloc);
            if (hasPermissionToBuild) {
                if (action == Action.LEFT_CLICK_BLOCK && player.getPlayer().getGameMode() == GameMode.CREATIVE) {
                    event.setCancelled(true);
                }
                this.activateChestEvent(event, player, clickedBlock);
            } else if (!PermController.hasCreatePermissions(player)) {
                BukkitMessageController.sendMessage(player, BukkitMessageController.getMessage("no_create_perms", new Object[0]));
            } else if (!PermController.hasBuildPerms(player, bloc)) {
                BukkitMessageController.sendMessage(player, BukkitMessageController.getMessage("no_build_perms", new Object[0]));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerSignInteract(PlayerInteractEvent event) {
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        Material clickedMat = clickedBlock.getType();
        if (!(clickedMat.equals((Object)Material.SIGN) || clickedMat.equals((Object)Material.SIGN_POST) || clickedMat.equals((Object)Material.WALL_SIGN))) {
            return;
        }
        Action action = event.getAction();
        BukkitPlayer player = new BukkitPlayer(event.getPlayer());
        BukkitLocation bloc = new BukkitLocation(clickedBlock.getLocation());
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getItem() != null && event.getItem().getTypeId() == Defaults.WAND.intValue() && action == Action.LEFT_CLICK_BLOCK) {
            boolean hasPermissionToBuild = PermController.hasAllCreatePermissions(player, bloc);
            if (hasPermissionToBuild) {
                if (action == Action.LEFT_CLICK_BLOCK && player.getPlayer().getGameMode() == GameMode.CREATIVE) {
                    event.setCancelled(true);
                }
                this.activateSignEvent(event, player, clickedBlock);
            }
            return;
        }
        BukkitSign sign = null;
        ShopSign ss = null;
        try {
            sign = new BukkitSign((Sign)event.getClickedBlock().getState());
            ss = ShopController.findShopSign(sign);
        }
        catch (Exception e) {
            System.err.println("Failed on block interact");
            System.err.println("Loc=" + event.getClickedBlock().getLocation());
            e.printStackTrace();
        }
        if (ss == null) {
            if (sign == null) {
                return;
            }
            SignValues sv = null;
            try {
                sv = SignParser.parseShopSign(sign.getLines());
                boolean isAdminSign = ShopOwner.isAdminShop(sign.getLine(0));
                if (sv != null && !isAdminSign) {
                    sign.setLine(1, sv.quantity + ": U");
                    sign.update(true);
                } else if (isAdminSign) {
                    sign.setLine(1, sv.quantity + "");
                    ShopOwner so = new ShopOwner(Defaults.ADMIN_NAME);
                    ss = new ShopSign(so, sign, sv);
                    ShopController.addShopSign(ss);
                }
            }
            catch (SignFormatException e) {
                // empty catch block
            }
            return;
        }
        if (player.getPlayer().isSneaking()) {
            player.sendMessage(BukkitMessageController.getMessage("Sneaking", new Object[0]));
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
        }
        ShopOwner so = new ShopOwner(player.getName());
        if (ShopOwner.sameOwner(ss.getOwner(), so) && !PermController.isAdmin(player)) {
            player.sendMessage(BukkitMessageController.getMessage("You_cannot_use_your_own_shop", new Object[0]));
            return;
        }
        String playerName = player.getName();
        if (this.userTime.containsKey(playerName) && System.currentTimeMillis() - this.userTime.get(playerName) < (long)interval) {
            player.sendMessage(BukkitMessageController.getMessage("wait", new Object[0]));
            return;
        }
        this.userTime.put(playerName, System.currentTimeMillis());
        if (this.userCommandTime.containsKey(playerName) && System.currentTimeMillis() - this.userCommandTime.get(playerName) < 60L) {
            this.cancelCommandTimer(player);
        }
        if (action == Action.LEFT_CLICK_BLOCK && Defaults.LEFT_CLICK_SELL_ACTION) {
            Pair<Integer, Integer> mult = this.userMultiplier.get(player.getName());
            if (mult != null && (Integer)mult.fst == 1) {
                this.cancelCommandTimer(player);
                this.tc.sellToShop(ss, player, (Integer)mult.snd);
            } else {
                this.tc.sellToShop(ss, player, 1);
            }
        } else {
            Pair<Integer, Integer> mult = this.userMultiplier.get(player.getName());
            if (mult != null && (Integer)mult.fst == 0) {
                this.cancelCommandTimer(player);
                this.tc.buyFromShop(ss, player, (Integer)mult.snd);
            } else {
                this.tc.buyFromShop(ss, player, 1);
            }
        }
    }

    private void activateChestEvent(PlayerInteractEvent event, MCPlayer player, Block clickedBlock) {
        Chest chest = (Chest)clickedBlock.getState();
        this.linkController.activateChestShop(new BukkitChest(chest), player);
    }

    private void activateSignEvent(PlayerInteractEvent event, MCPlayer player, Block clickedBlock) {
        SignValues sv;
        BukkitSign csign = new BukkitSign((Sign)event.getClickedBlock().getState());
        String[] sLines = csign.getLines();
        boolean isPlayersShopSign = ShopSign.isShopSignOfPlayer(sLines, new BukkitPlayer(event.getPlayer()), csign);
        if (sLines.length < 3 || !isPlayersShopSign) {
            return;
        }
        ShopSign tss = ShopController.findShopSign(csign);
        if (tss != null) {
            Shop s;
            boolean isAdminPlayer = PermController.isAdmin(player);
            boolean isAdminShop = tss.isAdminShop();
            if (isAdminShop) {
                if (isAdminPlayer) {
                    player.sendMessage(BukkitMessageController.getMessage("sign_already_active", new Object[0]));
                }
                return;
            }
            if (isAdminPlayer && !isAdminShop && !tss.getOwner().getName().equalsIgnoreCase(player.getName())) {
                player.sendMessage(BukkitMessageController.getMessage("admins_cant_link_other_shops", new Object[0]));
                return;
            }
            if (!isAdminPlayer && !isAdminShop && (s = ShopController.getShop(csign.getWorld(), new ShopOwner(event.getPlayer().getName()))) != null) {
                int chestCount = s.getNumChestsAttachedToSign(tss);
                player.sendMessage(BukkitMessageController.getMessage("sign_already_links", chestCount, BukkitMessageController.getChestOrChests(chestCount)));
                return;
            }
        }
        try {
            sv = SignParser.parseShopSign(sLines);
        }
        catch (SignFormatException e) {
            e.printStackTrace();
            return;
        }
        if (sv != null) {
            Block sign = event.getClickedBlock();
            Sign cs = (Sign)sign.getState();
            ShopOwner so = new ShopOwner(new BukkitPlayer(event.getPlayer()));
            ShopSign ss = new ShopSign(so, new BukkitSign(cs), sv);
            boolean isAdminShop = ss.isAdminShop();
            ShopController.addShopSign(ss);
            if (!isAdminShop) {
                ShopController.updateAffectedSigns(so, ss);
            } else {
                player.sendMessage(BukkitMessageController.getMessage("activated_admin_shop", new Object[0]));
            }
        }
    }

    public void setBuyCommand(MCPlayer player, int multiplier) {
        if (multiplier < 1 || multiplier > 128) {
            player.sendMessage(BukkitMessageController.getMessage("multiplier_bounds", 128));
            return;
        }
        this.cancelCommandTimer(player);
        this.userMultiplier.put(player.getName(), new Pair<Integer, Integer>(0, multiplier));
        this.userCommandTime.put(player.getName(), System.currentTimeMillis());
    }

    public void cancelCommandTimer(MCPlayer player) {
        this.userMultiplier.remove(player.getName());
        this.userCommandTime.remove(player.getName());
    }

    public void setSellCommand(MCPlayer player, int multiplier) {
        if (multiplier < 1 || multiplier > 128) {
            player.sendMessage(BukkitMessageController.getMessage("multiplier_bounds", 128));
            return;
        }
        this.cancelCommandTimer(player);
        this.userMultiplier.put(player.getName(), new Pair<Integer, Integer>(1, multiplier));
        this.userCommandTime.put(player.getName(), System.currentTimeMillis());
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        ShopController.onPlayerLogin(event.getPlayer().getName());
    }
}

