/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.bukkit.listeners;

import mc.alk.bukkit.BukkitPlayer;
import mc.alk.bukkit.blocks.BukkitSign;
import mc.alk.mc.MCServer;
import mc.alk.shops.BattleShops;
import mc.alk.shops.Defaults;
import mc.alk.shops.bukkit.controllers.BukkitMessageController;
import mc.alk.shops.controllers.PermController;
import mc.alk.shops.controllers.ShopController;
import mc.alk.shops.controllers.SignParser;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.objects.ShopSign;
import mc.alk.shops.objects.SignFormatException;
import mc.alk.shops.objects.SignValues;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;

public class ShopsSignListener
implements Listener {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(priority=EventPriority.LOWEST)
    public void onSignChange(SignChangeEvent event) {
        Block block = event.getBlock();
        Material type = block.getType();
        if (!(type.equals((Object)Material.SIGN) || type.equals((Object)Material.SIGN_POST) || type.equals((Object)Material.WALL_SIGN))) {
            return;
        }
        if (event.getLines().length < 3) return;
        if (!SignParser.isShopSign(event.getLines())) {
            return;
        }
        try {
            ShopOwner so;
            String[] lines = event.getLines();
            SignValues sv = SignParser.parseShopSign(lines);
            if (sv == null) return;
            BukkitPlayer p = new BukkitPlayer(event.getPlayer());
            if (!p.hasPermission("shop.create") && !PermController.isAdmin(p)) {
                BukkitMessageController.sendMessage(p, "&cYou don't have permissions to create a Shop Sign");
                this.cancelAndDrop(event, block);
                return;
            }
            Sign sign = (Sign)block.getState();
            if (ShopOwner.isAdminShop(lines[0])) {
                if (!PermController.isAdmin(p)) {
                    BukkitMessageController.sendMessage(p, "&cYou don't have permissions to create an admin shop");
                    this.cancelAndDrop(event, block);
                    return;
                }
                so = new ShopOwner(Defaults.ADMIN_NAME);
            } else {
                so = new ShopOwner(p.getName());
            }
            final ShopSign ss = new ShopSign(so, new BukkitSign(sign), sv);
            ss.validate();
            ss.setEventValues(event);
            lines[3] = sv.coloredText;
            int chestCount = ShopController.addShopSign(ss);
            if (ss.isAdminShop()) {
                BukkitMessageController.sendMessage(p, BukkitMessageController.getMessage("activated_admin_shop", new Object[0]));
                return;
            }
            if (chestCount > 0) {
                BukkitMessageController.sendMessage(p, BukkitMessageController.getMessage("setup_shop", ss.getCommonName(), chestCount, BukkitMessageController.getChestOrChests(chestCount)));
            } else {
                BukkitMessageController.sendMessage(p, BukkitMessageController.getMessage("setup_shop_no_chests", ss.getCommonName()));
            }
            MCServer.scheduleSyncDelayedTask(BattleShops.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    ShopController.updateAffectedSigns(ss.getOwner(), ss);
                }
            });
            return;
        }
        catch (SignFormatException e) {
            event.getPlayer().sendMessage(e.getMessage());
            this.cancelAndDrop(event, block);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cancelAndDrop(event, block);
        }
    }

    public void cancelAndDrop(SignChangeEvent event, Block block) {
        event.setCancelled(true);
        block.setType(Material.AIR);
        block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.SIGN, 1));
    }
}

