/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.controllers;

import java.util.HashMap;
import java.util.Map;
import mc.alk.mc.MCPlayer;
import mc.alk.mc.MCWorld;
import mc.alk.mc.blocks.MCChest;
import mc.alk.mc.blocks.MCSign;
import mc.alk.shops.bukkit.controllers.BukkitMessageController;
import mc.alk.shops.controllers.PermController;
import mc.alk.shops.controllers.Shop;
import mc.alk.shops.controllers.ShopController;
import mc.alk.shops.objects.ShopChest;
import mc.alk.shops.objects.ShopOwner;

public class LinkController {
    Map<String, Integer> bukkittimers = new HashMap<String, Integer>();

    public boolean chestRightClick(MCChest chest, MCPlayer player) {
        if (PermController.isAdmin(player)) {
            return false;
        }
        ShopChest schest = ShopController.getShopChest(chest);
        if (schest == null) {
            return false;
        }
        ShopOwner prevOwner = schest.getOwner();
        if (prevOwner == null) {
            return false;
        }
        MCWorld w = schest.getWorld();
        ShopOwner newOwner = new ShopOwner(player);
        Shop prevOwnerShop = ShopController.getShop(chest.getWorld(), prevOwner);
        Boolean hasShopPermission = prevOwnerShop != null ? prevOwnerShop.playerHasPermission(player) : false;
        if (hasShopPermission.booleanValue()) {
            return false;
        }
        LinkController.breakConnection(schest, prevOwner, newOwner);
        ShopController.updateAffectedSigns(w, prevOwner, schest);
        BukkitMessageController.sendMessage(prevOwner, BukkitMessageController.getMessage("Break_link", new Object[0]));
        return true;
    }

    public boolean activateChestShop(MCChest chest, MCPlayer player) {
        ShopChest schest = ShopController.getShopChest(chest);
        ShopOwner newOwner = new ShopOwner(player);
        ShopOwner prevOwner = schest != null ? schest.getOwner() : null;
        MCWorld w = chest.getWorld();
        if (prevOwner != null) {
            boolean hasPermissionToTouch;
            if (prevOwner.equals(newOwner)) {
                LinkController.breakConnection(schest, prevOwner, newOwner);
                ShopController.updateAffectedSigns(w, prevOwner, schest);
                BukkitMessageController.sendMessage(player, BukkitMessageController.getMessage("Unlink_chest", new Object[0]));
                return false;
            }
            Shop oldshop = ShopController.getShop(w, prevOwner);
            boolean playerIsAdmin = PermController.isAdmin(player);
            boolean bl = hasPermissionToTouch = oldshop != null ? oldshop.playerHasPermission(player) : false;
            if (hasPermissionToTouch || playerIsAdmin) {
                return true;
            }
            LinkController.breakConnection(schest, prevOwner, newOwner);
            if (oldshop != null && schest != null) {
                ShopController.updateAffectedSigns(w, prevOwner, schest);
            }
            BukkitMessageController.sendMessage(prevOwner, BukkitMessageController.getMessage("Break_link", new Object[0]));
        }
        Shop shop = ShopController.addShop(w, newOwner);
        ShopChest shopchest = new ShopChest(chest, newOwner);
        HashMap<String, Integer> linked = shop.addChest(shopchest);
        ShopController.addShopChest(shopchest);
        if (linked != null && linked.size() > 0) {
            for (String item_name : linked.keySet()) {
                if (item_name.equals("EVERYTHING")) {
                    BukkitMessageController.sendMessage(player, BukkitMessageController.getMessage("Linked_everything", new Object[0]));
                    continue;
                }
                int item_count = linked.get(item_name);
                BukkitMessageController.sendMessage(player, BukkitMessageController.getMessage("Linked_sign", linked.get(item_name), BukkitMessageController.getSignOrSigns(item_count), BukkitMessageController.getHasOrHave(item_count), item_name));
            }
        } else {
            BukkitMessageController.sendMessage(player, BukkitMessageController.getMessage("Unlinked_sign", new Object[0]));
        }
        ShopController.updateAffectedSigns(w, newOwner, shopchest);
        return true;
    }

    public static void breakShopSign(MCSign sign) {
        ShopController.removeShopSign(sign);
    }

    public static void breakChestShop(MCChest chest) {
        ShopChest lc = ShopController.getShopChest(chest);
        if (lc == null) {
            return;
        }
        ShopOwner previous_owner = lc.getOwner();
        ShopController.removeChest(lc);
        ShopController.updateAffectedSigns(chest.getWorld(), previous_owner, lc);
    }

    private static void breakConnection(ShopChest chest, ShopOwner previous_owner, ShopOwner new_owner) {
        ShopController.removeChest(chest);
    }
}

