/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.controllers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.mc.MCItemStack;
import mc.alk.mc.MCLocation;
import mc.alk.mc.MCPlayer;
import mc.alk.mc.blocks.MCChest;
import mc.alk.shops.Defaults;
import mc.alk.shops.objects.ChestSet;
import mc.alk.shops.objects.EverythingItem;
import mc.alk.shops.objects.ShopChest;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.objects.ShopSign;
import mc.alk.shops.utils.CompositeMap;
import mc.alk.shops.utils.InventoryUtil;
import mc.alk.shops.utils.KeyUtil;

public class Shop
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CompositeMap<HashMap<String, ShopChest>> chests_by_itemid = new CompositeMap();
    private CompositeMap<HashMap<String, ShopSign>> signs_by_itemid = new CompositeMap();
    private HashMap<String, ShopChest> chests_by_loc = new HashMap();
    private HashMap<String, ShopSign> signs_by_loc = new HashMap();
    private final ShopOwner owner;
    private HashSet<String> associates;

    public Shop(ShopOwner owner) {
        this.owner = owner;
    }

    public ShopOwner getOwner() {
        return this.owner;
    }

    public Set<String> getAssociates() {
        return this.associates;
    }

    public Collection<ShopSign> getSigns() {
        return this.signs_by_loc.values();
    }

    public int getNumChestsAttachedToSign(ShopSign sign) {
        MCItemStack item = sign.getItemStack();
        long key = KeyUtil.toKey(item);
        int count = 0;
        count += this.chests_by_itemid.containsKey(key) ? this.chests_by_itemid.get(key).size() : 0;
        return count += this.chests_by_itemid.containsKey(Defaults.EVERYTHING_ID) ? this.chests_by_itemid.get(Defaults.EVERYTHING_ID).size() : 0;
    }

    public int addShopSign(ShopSign sign) {
        String key = KeyUtil.getStringLoc(sign);
        this.signs_by_loc.put(key, sign);
        MCItemStack item = sign.getItemStack();
        Long itemid = KeyUtil.toKey(item);
        if (!this.signs_by_itemid.containsKey(itemid)) {
            this.signs_by_itemid.put(itemid, new HashMap());
        }
        Map ss = this.signs_by_itemid.get(itemid);
        ss.put(key, sign);
        int count = 0;
        count += this.chests_by_itemid.containsKey(itemid) ? this.chests_by_itemid.get(itemid).size() : 0;
        return count += this.chests_by_itemid.containsKey(Defaults.EVERYTHING_ID) ? this.chests_by_itemid.get(Defaults.EVERYTHING_ID).size() : 0;
    }

    public HashMap<String, Integer> addChest(ShopChest chest) {
        List<MCItemStack> items = chest.getItemIds();
        if (items == null || items.isEmpty()) {
            return null;
        }
        MCLocation cl = chest.getLocation();
        for (ShopChest sc : this.chests_by_loc.values()) {
            int distance;
            if (!sc.getWorld().getName().equals(cl.getWorld().getName()) || (distance = cl.getBlockY() == sc.getY() ? Math.abs(cl.getBlockX() - sc.getX()) + Math.abs(cl.getBlockZ() - sc.getZ()) : Integer.MAX_VALUE) > 1) continue;
            return null;
        }
        String key = KeyUtil.getStringLoc(chest);
        this.chests_by_loc.put(key, chest);
        HashMap<String, Integer> itemname_count = new HashMap<String, Integer>();
        ArrayList<Long> ids_with_signs = new ArrayList<Long>();
        for (MCItemStack item : chest.getItemIds()) {
            if (item == null || item.getType() == 0) continue;
            Long id = KeyUtil.toKey(item);
            String cn = item.getCommonName();
            if (cn.isEmpty()) {
                System.err.println("Commonname id=" + id + "  location=" + chest.getLocation());
                continue;
            }
            this.addItemId(key, chest, id, cn, itemname_count, ids_with_signs);
        }
        return itemname_count;
    }

    private void addItemId(String key, ShopChest chest, long id, String commonName, HashMap<String, Integer> itemname_count, List<Long> ids_with_signs) {
        if (!this.chests_by_itemid.containsKey(id)) {
            this.chests_by_itemid.put(id, new HashMap());
        }
        Map c = this.chests_by_itemid.get(id);
        c.put(key, chest);
        if (this.signs_by_itemid.containsKey(id)) {
            ids_with_signs.add(id);
            itemname_count.put(commonName, this.signs_by_itemid.get(id).size());
        } else {
            itemname_count.put(commonName, 0);
        }
    }

    public Map<Long, Collection<ShopChest>> getChestsByID(long itemId) {
        HashMap<Long, Collection<ShopChest>> chests = new HashMap<Long, Collection<ShopChest>>();
        if (this.chests_by_itemid.containsKey(itemId)) {
            chests.put(itemId, this.chests_by_itemid.get(itemId).values());
        }
        if (this.chests_by_itemid.containsKey(Defaults.EVERYTHING_ID)) {
            chests.put(Defaults.EVERYTHING_ID, this.chests_by_itemid.get(Defaults.EVERYTHING_ID).values());
        }
        return chests;
    }

    public void removeSign(ShopSign ss) {
        String lockey = KeyUtil.getStringLoc(ss);
        this.signs_by_loc.remove(lockey);
        long key = KeyUtil.toKey(ss.getItemStack());
        Map map = this.signs_by_itemid.get(key);
        if (map != null) {
            map.remove(lockey);
            if (map.size() <= 0) {
                this.signs_by_itemid.remove(key);
            }
        }
    }

    public void removeDoubleChestFromShop(ShopChest chest) {
        String lockey = KeyUtil.getStringLoc(chest);
        String lockey2 = Shop.getNeighborChestLoc(chest);
        this.chests_by_loc.remove(lockey);
        if (lockey2 != null) {
            this.chests_by_loc.remove(lockey2);
        }
        List<MCItemStack> items = chest.getItemIds();
        for (MCItemStack item : items) {
            Long key = KeyUtil.toKey(item);
            Map map = this.chests_by_itemid.get(key);
            if (map == null) continue;
            map.remove(lockey);
            if (lockey2 != null) {
                map.remove(lockey2);
            }
            if (map.size() > 0) continue;
            this.chests_by_itemid.remove(key);
        }
    }

    private static String getNeighborChestLoc(ShopChest lc) {
        MCChest neighbor = lc.getChest().getNeighborChest();
        return neighbor != null ? KeyUtil.getStringLoc(neighbor.getLocation()) : null;
    }

    public void updateSignsByItem(long itemid) {
        if (itemid == Defaults.EVERYTHING_ID) {
            HashSet<Long> ids = new HashSet<Long>();
            for (Long id : this.signs_by_itemid.keySet()) {
                if (id == Defaults.EVERYTHING_ID || ids.contains(id)) continue;
                ids.add(id);
                this.updateSigns(id);
            }
        } else {
            this.updateSigns(itemid);
        }
    }

    public void updateSignsByItem(MCItemStack item) {
        if (EverythingItem.isEverythingItem(item)) {
            for (Long id : this.signs_by_itemid.keySet()) {
                if (id == Defaults.EVERYTHING_ID) continue;
                this.updateSigns(id);
            }
        } else {
            this.updateSigns(KeyUtil.toKey(item));
        }
    }

    public void updateSignsByItems(Collection<MCItemStack> list) {
        for (MCItemStack item : list) {
            if (EverythingItem.isEverythingItem(item)) {
                for (Long id : this.signs_by_itemid.keySet()) {
                    if (id == Defaults.EVERYTHING_ID) continue;
                    this.updateSigns(id);
                }
                continue;
            }
            this.updateSigns(KeyUtil.toKey(item));
        }
    }

    private void updateSigns(long itemid) {
        Map signs = this.signs_by_itemid.get(itemid);
        if (signs == null || signs.size() == 0) {
            return;
        }
        ArrayList<ShopChest> chests = new ArrayList<ShopChest>();
        if (this.chests_by_itemid.containsKey(itemid)) {
            chests.addAll(this.chests_by_itemid.get(itemid).values());
        }
        if (this.chests_by_itemid.containsKey(Defaults.EVERYTHING_ID)) {
            chests.addAll(this.chests_by_itemid.get(Defaults.EVERYTHING_ID).values());
        }
        if (chests.isEmpty()) {
            for (ShopSign sign : signs.values()) {
                sign.setUnlinked();
            }
        } else {
            ChestSet chestset = new ChestSet(itemid, chests);
            int id = CompositeMap.getHOB(itemid);
            int datavalue = CompositeMap.getLOB(itemid);
            MCItemStack is = InventoryUtil.parseItemStack(id, (short)datavalue);
            int amount = chestset.amount(is);
            int free = chestset.freeSpaceAfter(is);
            for (ShopSign sign : signs.values()) {
                sign.setSignAmount(amount, free);
            }
        }
    }

    public boolean playerHasPermission(MCPlayer player) {
        return this.owner.getName().equals(player.getName()) || this.associates != null && this.associates.contains(player.getName().toLowerCase());
    }

    public void addToAssociates(String player) {
        if (this.associates == null) {
            this.associates = new HashSet();
        }
        this.associates.add(player.toLowerCase());
    }

    public void removeFromAssociates(String player) {
        if (this.associates == null) {
            return;
        }
        this.associates.remove(player.toLowerCase());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Shop[owner=" + this.owner.getName());
        for (Long itemid : this.chests_by_itemid.keySet()) {
            Map list = this.chests_by_itemid.get(itemid);
            sb.append("\n - item id = " + itemid + " ");
            for (ShopChest l : list.values()) {
                if (l != null) {
                    sb.append("\t" + l + " ,");
                    continue;
                }
                sb.append("\tnull ,");
            }
        }
        sb.append("-----");
        for (ShopChest chest : this.chests_by_loc.values()) {
            sb.append("\t" + chest);
        }
        for (ShopSign ss : this.signs_by_loc.values()) {
            sb.append("\t" + ss);
        }
        sb.append("]");
        return sb.toString();
    }

    public Collection<ShopChest> getChests() {
        return this.chests_by_loc.values();
    }
}

