/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.controllers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mc.alk.controllers.MoneyController;
import mc.alk.mc.MCItemStack;
import mc.alk.mc.MCPlayer;
import mc.alk.mc.MCWorld;
import mc.alk.shops.bukkit.controllers.BukkitMessageController;
import mc.alk.shops.controllers.Shop;
import mc.alk.shops.controllers.ShopController;
import mc.alk.shops.controllers.TransactionLogger;
import mc.alk.shops.objects.ChestSet;
import mc.alk.shops.objects.ShopChest;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.objects.ShopSign;
import mc.alk.shops.utils.KeyUtil;

public class TransactionController {
    private HashMap<String, Long> userTime = new HashMap();
    static final int spam_interval = 60000;
    TransactionLogger logger;

    public TransactionController(TransactionLogger transactionLogger) {
        this.logger = transactionLogger;
    }

    public boolean sellToShop(ShopSign ss, MCPlayer seller, Integer mult) {
        boolean isAdminShop = ss.isAdminShop();
        ShopOwner so = ss.getOwner();
        Shop shop = ShopController.getShop(ss.getWorld(), so);
        if (!isAdminShop && shop == null) {
            seller.sendMessage("badness shop doesnt exist!");
            return false;
        }
        Map<Long, Collection<ShopChest>> chests = shop.getChestsByID(KeyUtil.toKey(ss.getItemStack()));
        if (!isAdminShop && TransactionController.noChests(chests)) {
            seller.sendMessage(BukkitMessageController.getMessage("No_chests_attached", ss.getCommonName()));
            return false;
        }
        ChestSet chestset = new ChestSet(chests);
        if (!ss.isBuying()) {
            seller.sendMessage(BukkitMessageController.getMessage("No_selling_to_this_shop", new Object[0]));
            return false;
        }
        float sellPrice = ss.getSellPrice() * (float)mult.intValue();
        String itemName = ss.getCommonName();
        int quantity = Math.max(1, ss.getQuantity() * mult);
        MCItemStack itemStack = ss.getItemStack().clone();
        MCWorld w = ss.getWorld();
        itemStack.setQuantity(quantity);
        if (!MoneyController.hasAccount(seller.getName())) {
            seller.sendMessage(BukkitMessageController.getMessage("Seller_has_no_account", new Object[0]));
            return false;
        }
        if (seller.getInventory().getItemAmount(itemStack) < quantity) {
            seller.sendMessage(BukkitMessageController.getMessage("You_have_not_enough_items", quantity));
            return false;
        }
        if (!isAdminShop) {
            if (!MoneyController.hasEnough(so.getName(), sellPrice, w.getName())) {
                seller.sendMessage(BukkitMessageController.getMessage("owner_has_not_enough_money", new Object[0]));
                return false;
            }
            if (!chestset.fits(itemStack, quantity)) {
                if (mult == 1) {
                    seller.sendMessage(BukkitMessageController.getMessage("Chest_is_full", quantity));
                    String msg = BukkitMessageController.getMessage("Your_shop_is_full", itemName, seller.getName());
                    BukkitMessageController.sendMessage(so, msg);
                } else {
                    seller.sendMessage(BukkitMessageController.getMessage("Buyer_cant_fit_this_many", quantity));
                }
                return false;
            }
            BukkitMessageController.sendMessage(so, BukkitMessageController.getMessage("Somebody_sold_items_to_your_shop", seller.getName(), quantity, itemName, Float.valueOf(sellPrice)));
            MoneyController.subtract(so.getName(), sellPrice, w.getName());
            HashSet<ShopChest> affectedChests = new HashSet<ShopChest>();
            HashSet<MCItemStack> affectedIDs = new HashSet<MCItemStack>();
            chestset.addItem(itemStack, quantity, affectedChests);
            for (ShopChest c : affectedChests) {
                affectedIDs.addAll(c.getItemIds());
            }
            ShopController.updateAffectedSigns(ss.getWorld(), so, affectedIDs);
            ShopController.playerShopTransaction(so);
        }
        this.logger.log(so.getName(), seller.getName(), false, itemStack.getType(), itemStack.getDataValue(), quantity, sellPrice);
        seller.sendMessage(BukkitMessageController.getMessage("You_sold_items", quantity, itemName, Float.valueOf(sellPrice), so));
        MoneyController.add(seller.getName(), sellPrice, w.getName());
        seller.getInventory().removeItem(itemStack);
        seller.updateInventory();
        seller.sendMessage(BukkitMessageController.getMessage("Your_balance", MoneyController.balance(seller.getName(), w.getName())));
        return true;
    }

    public boolean buyFromShop(ShopSign ss, MCPlayer buyer, Integer mult) {
        boolean isAdminShop = ss.isAdminShop();
        ShopOwner so = ss.getOwner();
        Shop shop = ShopController.getShop(ss.getWorld(), so);
        if (!isAdminShop && shop == null) {
            buyer.sendMessage("badness shop doesnt exist!");
            return false;
        }
        Map<Long, Collection<ShopChest>> chests = shop.getChestsByID(KeyUtil.toKey(ss.getItemStack()));
        String itemName = ss.getCommonName();
        if (!isAdminShop && TransactionController.noChests(chests)) {
            buyer.sendMessage(BukkitMessageController.getMessage("No_chests_attached", itemName));
            return false;
        }
        float buyPrice = ss.getBuyPrice() * (float)mult.intValue();
        int quantity = Math.max(1, ss.getQuantity() * mult);
        MCItemStack itemStack = ss.getItemStack().clone();
        itemStack.setQuantity(quantity);
        MCWorld w = ss.getWorld();
        if (!MoneyController.hasAccount(buyer.getName())) {
            buyer.sendMessage(BukkitMessageController.getMessage("Buyer_has_no_account", new Object[0]));
            return false;
        }
        if (!ss.isSelling()) {
            buyer.sendMessage(BukkitMessageController.getMessage("No_buying_from_this_shop", new Object[0]));
            return false;
        }
        if (!MoneyController.hasEnough(buyer.getName(), buyPrice, w.getName())) {
            buyer.sendMessage(BukkitMessageController.getMessage("You_have_got_not_enough_money", new Object[0]));
            return false;
        }
        if (!buyer.getInventory().canFit(itemStack)) {
            buyer.sendMessage(BukkitMessageController.getMessage("Your_inventory_is_full", new Object[0]));
            return false;
        }
        if (!isAdminShop) {
            ChestSet chestset = new ChestSet(chests);
            if (!chestset.hasEnough(itemStack, quantity)) {
                buyer.sendMessage(BukkitMessageController.getMessage("Shop_is_out_of_stock", quantity));
                if (mult == 1) {
                    String msg = BukkitMessageController.getMessage("Your_shop_is_out_of_stock", itemName, buyer.getName());
                    String hashkey = so.getName() + ":" + itemName;
                    if (this.userTime.containsKey(hashkey)) {
                        if (System.currentTimeMillis() - this.userTime.get(hashkey) > 60000L) {
                            BukkitMessageController.sendMessage(so, msg);
                            this.userTime.put(hashkey, System.currentTimeMillis());
                        }
                    } else {
                        BukkitMessageController.sendMessage(so, msg);
                        this.userTime.put(hashkey, System.currentTimeMillis());
                    }
                } else {
                    buyer.sendMessage(BukkitMessageController.getMessage("Seller_cant_sell_this_many", quantity));
                }
                return false;
            }
            BukkitMessageController.sendMessage(so, BukkitMessageController.getMessage("Somebody_bought_items_from_your_shop", buyer.getName(), quantity, itemName, Float.valueOf(buyPrice)));
            MoneyController.add(so.getName(), buyPrice, w.getName());
            HashSet<ShopChest> affectedChests = new HashSet<ShopChest>();
            HashSet<MCItemStack> affectedItems = new HashSet<MCItemStack>();
            chestset.removeItem(itemStack, quantity, affectedChests);
            for (ShopChest c : affectedChests) {
                affectedItems.addAll(c.getItemIds());
            }
            ShopController.updateAffectedSigns(ss.getWorld(), so, affectedItems);
            ShopController.playerShopTransaction(so);
        }
        this.logger.log(so.getName(), buyer.getName(), true, itemStack.getType(), itemStack.getDataValue(), quantity, buyPrice);
        buyer.sendMessage(BukkitMessageController.getMessage("You_bought_items", quantity, itemName, so, Float.valueOf(buyPrice)));
        MoneyController.subtract(buyer.getName(), buyPrice, w.getName());
        buyer.getInventory().addItem(itemStack);
        buyer.updateInventory();
        buyer.sendMessage(BukkitMessageController.getMessage("Your_balance", MoneyController.balance(buyer.getName(), w.getName())));
        return true;
    }

    private static boolean noChests(Map<Long, Collection<ShopChest>> chests) {
        if (chests == null || chests.size() == 0) {
            return true;
        }
        int count = 0;
        for (Long id : chests.keySet()) {
            count += chests.get(id).size();
        }
        return count <= 0;
    }
}

