/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.objects;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mc.alk.mc.MCItemStack;
import mc.alk.shops.Defaults;
import mc.alk.shops.objects.ShopChest;

public class ChestSet {
    Collection<ShopChest> chests = null;
    Collection<ShopChest> everything_chests = null;

    public ChestSet(Map<Long, Collection<ShopChest>> chests) {
        for (Long id : chests.keySet()) {
            if (id == Defaults.EVERYTHING_ID) {
                this.everything_chests = chests.get(id);
                continue;
            }
            this.chests = chests.get(id);
        }
    }

    public ChestSet(long itemid, Collection<ShopChest> chests) {
        if (itemid != Defaults.EVERYTHING_ID) {
            this.chests = chests;
        } else {
            this.everything_chests = chests;
        }
    }

    public boolean hasEnough(MCItemStack itemStack, int stockAmount) {
        int quantity = 0;
        if (this.chests != null) {
            for (ShopChest chest : this.chests) {
                quantity += chest.amount(itemStack);
            }
        }
        if (this.everything_chests != null) {
            for (ShopChest chest : this.everything_chests) {
                quantity += chest.amount(itemStack);
            }
        }
        return quantity >= stockAmount;
    }

    public int freeSpaceAfter(MCItemStack itemStack) {
        int free = 0;
        if (this.chests != null) {
            for (ShopChest chest : this.chests) {
                free += chest.freeSpaceAfter(itemStack);
            }
        }
        if (this.everything_chests != null) {
            for (ShopChest chest : this.everything_chests) {
                free += chest.freeSpaceAfter(itemStack);
            }
        }
        return free;
    }

    public boolean fits(MCItemStack itemStack, int stockAmount) {
        return this.freeSpaceAfter(itemStack) >= 0;
    }

    public Integer addItem(MCItemStack itemStack, int stockAmount, Set<ShopChest> affectedChests) {
        int amount_left = stockAmount;
        if (this.chests != null) {
            amount_left = ChestSet.addItem(this.chests, itemStack, stockAmount, affectedChests);
        }
        if (amount_left > 0 && this.everything_chests != null) {
            ChestSet.addItem(this.everything_chests, itemStack, stockAmount, affectedChests);
        }
        return null;
    }

    public static int addItem(Collection<ShopChest> chests, MCItemStack itemStack, int quantity, Set<ShopChest> affectedChests) {
        MCItemStack item = itemStack.clone();
        item.setQuantity(0);
        for (ShopChest chest : chests) {
            MCItemStack add;
            int free = chest.freeSpaceAfter(item);
            if (free <= 0) continue;
            if (free >= quantity) {
                add = itemStack.clone();
                add.setQuantity(quantity);
                affectedChests.add(chest);
                chest.addItem(add);
                return 0;
            }
            if (free <= 0) continue;
            add = itemStack.clone();
            add.setQuantity(free);
            affectedChests.add(chest);
            chest.addItem(add);
            quantity -= free;
        }
        return quantity;
    }

    public Set<Integer> removeItem(MCItemStack itemStack, int quantity, Set<ShopChest> affectedChests) {
        int amount_left = quantity;
        if (this.chests != null) {
            amount_left = ChestSet.removeItem(this.chests, itemStack, quantity, affectedChests);
        }
        if (amount_left > 0 && this.everything_chests != null) {
            ChestSet.removeItem(this.everything_chests, itemStack, quantity, affectedChests);
        }
        return null;
    }

    public static int removeItem(Collection<ShopChest> chests, MCItemStack oitemStack, int quantity, Set<ShopChest> affectedChests) {
        MCItemStack itemStack = oitemStack.clone();
        for (ShopChest chest : chests) {
            int free = chest.amount(itemStack);
            if (free <= 0) continue;
            if (free >= quantity) {
                affectedChests.add(chest);
                chest.removeItem(itemStack);
                return 0;
            }
            if (free <= 0) continue;
            affectedChests.add(chest);
            chest.removeItem(itemStack);
            quantity -= free;
        }
        return quantity;
    }

    public int amount(MCItemStack itemStack) {
        int quantity = 0;
        if (this.chests != null) {
            for (ShopChest chest : this.chests) {
                quantity += chest.amount(itemStack);
            }
        }
        if (this.everything_chests != null) {
            for (ShopChest chest : this.everything_chests) {
                quantity += chest.amount(itemStack);
            }
        }
        return quantity;
    }

    public String toString() {
        int i;
        MCItemStack[] inv;
        StringBuilder sb = new StringBuilder();
        if (this.chests != null) {
            sb.append("---------------- chests\n");
            for (ShopChest chest : this.chests) {
                inv = chest.getInventory().getContents();
                for (i = 0; i < inv.length; ++i) {
                    if (inv[i] != null) {
                        sb.append(i + "  " + inv[i].getType() + "  " + inv[i].getQuantity() + "   " + inv[i].getDataValue() + "\n");
                        continue;
                    }
                    sb.append(i + " null\n");
                }
            }
        }
        if (this.everything_chests != null) {
            sb.append("---------------- everything_chests\n");
            for (ShopChest chest : this.everything_chests) {
                inv = chest.getInventory().getContents();
                for (i = 0; i < inv.length; ++i) {
                    if (inv[i] != null) {
                        sb.append(i + "  " + inv[i].getType() + "  " + inv[i].getQuantity() + "   " + inv[i].getDataValue() + "\n");
                        continue;
                    }
                    sb.append(i + " null\n");
                }
            }
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        boolean hasItems1 = this.chests != null && !this.chests.isEmpty();
        boolean hasItems2 = this.everything_chests != null && !this.everything_chests.isEmpty();
        return !hasItems1 && !hasItems2;
    }

    public int size() {
        int count = 0;
        if (this.chests != null) {
            count += this.chests.size();
        }
        if (this.everything_chests != null) {
            count += this.everything_chests.size();
        }
        return count;
    }

    public ShopChest getFirst() {
        Iterator<ShopChest> i$;
        if (this.chests != null && this.chests.size() > 0 && (i$ = this.chests.iterator()).hasNext()) {
            ShopChest c = i$.next();
            return c;
        }
        if (this.everything_chests != null && this.everything_chests.size() > 0 && (i$ = this.chests.iterator()).hasNext()) {
            ShopChest c = i$.next();
            return c;
        }
        return null;
    }
}

