/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.objects;

import java.util.ArrayList;
import java.util.List;
import mc.alk.mc.MCBlock;
import mc.alk.mc.MCInventory;
import mc.alk.mc.MCItemStack;
import mc.alk.mc.MCLocation;
import mc.alk.mc.MCWorld;
import mc.alk.mc.blocks.MCChest;
import mc.alk.shops.objects.EverythingItem;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.utils.KeyUtil;

public class ShopChest {
    private ShopOwner owner;
    List<MCItemStack> items = new ArrayList<MCItemStack>();
    MCLocation loc;

    public ShopChest(MCChest chest, ShopOwner owner) {
        this.loc = chest.getLocation();
        this.owner = owner;
        if (chest.getItems() != null) {
            this.items = new ArrayList<MCItemStack>();
            for (MCItemStack item : chest.getItems()) {
                if (item.getType() == 0) continue;
                this.items.add(item);
            }
        }
        if (this.items.size() == 0) {
            this.items.add(EverythingItem.EVERYTHING_ITEM);
        }
    }

    public ShopChest(MCChest chest, ShopOwner owner, List<MCItemStack> items) {
        this.loc = chest.getLocation();
        this.owner = owner;
        this.items = items;
    }

    public MCChest getChest() throws IllegalStateException {
        MCBlock block;
        MCWorld w = this.loc.getWorld();
        if (w.isType(block = w.getBlockAt(this.loc), MCChest.class)) {
            return (MCChest)w.toType(block, MCChest.class);
        }
        throw new IllegalStateException("ShopChest at " + this.loc + " is no longer a chest " + block.getType());
    }

    public ShopOwner getOwner() {
        return this.owner;
    }

    public MCWorld getWorld() {
        return this.loc.getWorld();
    }

    public MCLocation getLocation() {
        return this.loc;
    }

    public int getX() {
        return this.loc.getBlockX();
    }

    public int getY() {
        return this.loc.getBlockY();
    }

    public int getZ() {
        return this.loc.getBlockZ();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MyChest[");
        sb.append((this.owner == null ? "null" : this.owner.getName()) + " ,");
        sb.append(KeyUtil.getStringLoc(this.loc) + ",");
        sb.append(this.items);
        sb.append("]");
        return sb.toString();
    }

    public List<MCItemStack> getItemIds() {
        return this.items;
    }

    public int amount(MCItemStack itemStack) throws IllegalStateException {
        MCChest chest = this.getChest();
        return chest.getInventory().getItemAmount(itemStack);
    }

    public void removeItem(MCItemStack itemStack) throws IllegalStateException {
        MCChest chest = this.getChest();
        MCItemStack item = itemStack.clone();
        chest.getInventory().removeItem(item);
    }

    public int freeSpaceAfter(MCItemStack itemStack) throws IllegalStateException {
        MCChest chest = this.getChest();
        return chest.getInventory().freeSpaceAfter(itemStack);
    }

    public void addItem(MCItemStack itemStack) throws IllegalStateException {
        MCChest chest = this.getChest();
        MCItemStack item = itemStack.clone();
        chest.getInventory().addItem(item);
    }

    public void addItemID(MCItemStack itemStack) {
        MCItemStack item = itemStack.clone();
        this.items.add(item);
    }

    public MCInventory getInventory() {
        return this.getChest().getInventory();
    }
}

