/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.objects;

import mc.alk.mc.MCBlock;
import mc.alk.mc.MCItemStack;
import mc.alk.mc.MCLocation;
import mc.alk.mc.MCPlayer;
import mc.alk.mc.MCWorld;
import mc.alk.mc.blocks.MCSign;
import mc.alk.shops.bukkit.controllers.BukkitMessageController;
import mc.alk.shops.controllers.PermController;
import mc.alk.shops.controllers.SignParser;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.objects.SignFormatException;
import mc.alk.shops.objects.SignValues;
import org.bukkit.Material;
import org.bukkit.event.block.SignChangeEvent;

public class ShopSign {
    private ShopOwner owner;
    private float buyPrice;
    private float sellPrice;
    MCLocation loc;
    MCItemStack item;
    private int amount_in_chests;
    private int space_left_in_chests;

    public ShopSign() {
    }

    public ShopSign(ShopOwner p, MCSign cs, SignValues sv) {
        this.owner = p;
        this.setSignValues(sv);
        this.loc = cs.getLocation();
    }

    private void setSignValues(SignValues sv) {
        this.buyPrice = sv.buyPrice;
        this.sellPrice = sv.sellPrice;
        this.item = sv.itemStack.clone();
    }

    public int getQuantity() {
        return this.item.getQuantity();
    }

    public MCWorld getWorld() {
        return this.loc.getWorld();
    }

    public int getX() {
        return this.loc.getBlockX();
    }

    public int getY() {
        return this.loc.getBlockY();
    }

    public int getZ() {
        return this.loc.getBlockZ();
    }

    public float getSellPrice() {
        return this.sellPrice;
    }

    public boolean isSelling() {
        return this.buyPrice > 0.0f;
    }

    public float getBuyPrice() {
        return this.buyPrice;
    }

    public boolean isBuying() {
        return this.sellPrice > 0.0f;
    }

    public int getItemId() {
        return this.item.getType();
    }

    public int getItemDataValue() {
        return this.item.getDataValue();
    }

    public MCItemStack getItemStack() {
        return this.item;
    }

    public ShopOwner getOwner() {
        return this.owner;
    }

    public boolean isAdminShop() {
        return this.owner.isAdminShop();
    }

    public boolean validate() throws SignFormatException {
        if (this.owner == null) {
            throw new SignFormatException("No shop owner!", 0);
        }
        if (!this.isSelling() && !this.isBuying()) {
            throw new SignFormatException("Shop must buy or sell!", 3);
        }
        if (this.isBuying() && this.sellPrice <= 0.0f) {
            throw new SignFormatException("If you only buy, you must set a buy price!", 3);
        }
        if (this.isSelling() && this.buyPrice <= 0.0f) {
            throw new SignFormatException("If you only sell, you must set a sell price!", 3);
        }
        if (this.isSelling() && this.buyPrice < 0.001f) {
            throw new SignFormatException("You must set a sell price >= 0.0010!", 3);
        }
        if (this.isBuying() && this.sellPrice < 0.001f) {
            throw new SignFormatException("You must set a buy price >= 0.0010!", 3);
        }
        if (this.isSelling() && this.buyPrice > 100000.0f) {
            throw new SignFormatException("You must set a sell price <= 100000.0!", 3);
        }
        if (this.isBuying() && this.sellPrice > 100000.0f) {
            throw new SignFormatException("You must set a buy price <= 100000.0!", 3);
        }
        if (this.item.getQuantity() <= 0 || this.item.getQuantity() > 3456) {
            throw new SignFormatException("Quantity must be between [1-3456]", 2);
        }
        if (this.getItemId() < 0) {
            throw new SignFormatException("Shop sign must have the item to be sold", 4);
        }
        return true;
    }

    public void setEventValues(SignChangeEvent event) throws SignFormatException {
        event.setLine(0, this.getFormattedOwnerName());
        event.setLine(1, this.getFormattedQuantity());
        event.setLine(2, this.getFormattedBuySell());
        event.setLine(3, this.getFormattedItem());
    }

    public void setSignValues(MCSign sign) throws SignFormatException {
        sign.setLine(0, this.getFormattedOwnerName());
        sign.setLine(1, this.getFormattedQuantity());
        sign.setLine(2, this.getFormattedBuySell());
        sign.setLine(3, this.getFormattedItem());
    }

    private String formatPrice(float f) {
        if ((double)f == Math.ceil(f)) {
            return new Integer((int)f).toString();
        }
        String strf = new Float(f).toString();
        if (strf.endsWith("0")) {
            strf = strf.substring(0, strf.length() - 1);
        }
        return strf;
    }

    private String getFormattedItem() {
        String name = this.item.getCommonName();
        if (name.length() > 15) {
            return name.substring(0, 15);
        }
        return name;
    }

    private String getFormattedBuySell() throws SignFormatException {
        String strBuyPrice = this.formatPrice(this.buyPrice);
        String strSellPrice = this.formatPrice(this.sellPrice);
        StringBuffer sb = new StringBuffer();
        if (this.isSelling() && this.isBuying()) {
            sb.append("B " + strBuyPrice + " : " + strSellPrice + " S");
        } else if (this.isSelling()) {
            sb.append("B " + strBuyPrice);
        } else if (this.isBuying()) {
            sb.append("S " + strSellPrice);
        }
        String text = sb.toString();
        int length = text.length();
        if (length > 15 && (text = text.replaceAll(" ", "")).length() > 15) {
            throw new SignFormatException("Buy & Sell must be less than 10 chars long", 3);
        }
        return text;
    }

    private String getFormattedQuantity() throws SignFormatException {
        String text = this.getQuantity() + "";
        if (text.length() > 4) {
            throw new SignFormatException("Quantity must be less than 5 chars long", 2);
        }
        return text;
    }

    private String getFormattedOwnerName() {
        String name = this.owner.getName();
        if (name.length() > 15) {
            return name.substring(0, 15);
        }
        return name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ShopSign[");
        sb.append(this.owner == null ? "null, " : this.owner.getName() + ",");
        sb.append(this.getItemId() + ":" + this.getItemDataValue() + " ,");
        sb.append(this.item.getQuantity() + " ,");
        sb.append(this.buyPrice + " :" + this.sellPrice + " ]");
        return sb.toString();
    }

    private void setFull(int amount) {
        MCSign sign = this.getSign();
        if (sign == null) {
            return;
        }
        sign.setLine(1, BukkitMessageController.colorChat(this.getQuantity() + " : &6Full"));
        sign.update(true);
    }

    private void setEmpty(int quantity, int amount) {
        MCSign sign = this.getSign();
        if (sign == null) {
            return;
        }
        if (amount == 0) {
            sign.setLine(1, BukkitMessageController.colorChat(this.getQuantity() + " : &8 0"));
        } else {
            sign.setLine(1, BukkitMessageController.colorChat(this.getQuantity() + " : &8<" + this.getQuantity()));
        }
        sign.update(true);
    }

    private void setAmount(int amount) {
        String amountStr = amount > 999999 ? ">999999" : amount + "";
        MCSign sign = this.getSign();
        if (sign == null) {
            return;
        }
        sign.setLine(1, BukkitMessageController.colorChat(this.getQuantity() + " : &2" + amountStr));
        sign.update(true);
    }

    public void setUnlinked() {
        this.amount_in_chests = -1;
        MCSign sign = this.getSign();
        if (sign == null || this.isAdminShop()) {
            return;
        }
        sign.setLine(1, BukkitMessageController.colorChat(this.item.getQuantity() + " : &8 U"));
        sign.update(true);
    }

    private MCSign getSign() {
        MCBlock b = this.loc.getWorld().getBlockAt(this.loc.getBlockX(), this.loc.getBlockY(), this.loc.getBlockZ());
        int type = b.getType();
        if (type != Material.SIGN.getId() && type != Material.SIGN_POST.getId() && type != Material.WALL_SIGN.getId()) {
            return null;
        }
        return (MCSign)b;
    }

    public String getQuantityLine() {
        MCSign sign = this.getSign();
        if (sign == null) {
            return "";
        }
        return sign.getLine(1);
    }

    public void setSignAmount(int amount, int free) {
        if (this.isAdminShop()) {
            return;
        }
        this.amount_in_chests = amount;
        this.space_left_in_chests = free;
        if (this.item.getQuantity() > amount) {
            this.setEmpty(this.item.getQuantity(), amount);
        } else if (free < this.item.getQuantity()) {
            this.setFull(amount);
        } else {
            this.setAmount(amount);
        }
    }

    public boolean isUnlinked() {
        if (this.isAdminShop()) {
            return false;
        }
        return this.amount_in_chests == -1;
    }

    public boolean isFull() {
        if (this.isAdminShop()) {
            return false;
        }
        return this.space_left_in_chests < this.item.getQuantity();
    }

    public boolean isEmpty() {
        if (this.isAdminShop()) {
            return false;
        }
        return this.item.getQuantity() > this.amount_in_chests;
    }

    public MCLocation getLocation() {
        return this.loc;
    }

    public static boolean isShopSignOfPlayer(String[] lines, MCPlayer player, MCSign sign) {
        if (!ShopSign.playerNameMatches(player, lines[0], sign)) {
            return PermController.isAdmin(player) && ShopOwner.isAdminShop(lines[0]);
        }
        try {
            return SignParser.parseShopSign(lines) != null;
        }
        catch (SignFormatException e) {
            return false;
        }
    }

    private static boolean playerNameMatches(MCPlayer player, String ownerLine, MCSign sign) {
        if (!PermController.hasAllCreatePermissions(player, sign.getLocation())) {
            return false;
        }
        String name = player.getName();
        String signname = ownerLine;
        int first = signname.indexOf("&");
        if (first != -1) {
            signname = signname.substring(0, first);
        }
        if (name.length() > 15) {
            name = name.substring(0, 15);
        }
        if (signname.length() > 15) {
            signname = signname.substring(0, 15);
        }
        return name.compareToIgnoreCase(signname) == 0;
    }

    public String getCommonName() {
        return this.item.getCommonName();
    }
}

