/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.serializers;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.mc.MCBlock;
import mc.alk.mc.MCItemStack;
import mc.alk.mc.MCServer;
import mc.alk.mc.MCWorld;
import mc.alk.mc.StringLocation;
import mc.alk.mc.blocks.MCChest;
import mc.alk.mc.blocks.MCSign;
import mc.alk.mc.factories.ItemFactory;
import mc.alk.serializers.SQLSerializer;
import mc.alk.shops.BattleShops;
import mc.alk.shops.controllers.Shop;
import mc.alk.shops.controllers.ShopController;
import mc.alk.shops.controllers.SignParser;
import mc.alk.shops.controllers.TransactionLogger;
import mc.alk.shops.objects.EverythingItem;
import mc.alk.shops.objects.ShopChest;
import mc.alk.shops.objects.ShopOwner;
import mc.alk.shops.objects.ShopSign;
import mc.alk.shops.objects.SignFormatException;
import mc.alk.shops.objects.SignValues;
import mc.alk.shops.objects.Transaction;
import mc.alk.shops.serializers.ShopsSerializer;
import mc.alk.shops.utils.KeyUtil;
import mc.alk.util.Log;

public class SQLInstance
extends SQLSerializer
implements ShopsSerializer {
    static final boolean DEBUG = true;
    public static int MAX_NAME_LENGTH = 32;
    public static String URL = "localhost";
    public static String PORT = "3306";
    public static String USERNAME = "root";
    public static String PASSWORD = "";
    public static String DB = "minecraft";
    public static String TRANSACTION_TABLE = "shop_transactions";
    public static String SHOPSIGN_TABLE = "shop_signs";
    public static String SHOPCHEST_TABLE = "shop_chests";
    public static String SHOPCHESTITEM_TABLE = "shop_chestitems";
    public static String PLAYERSHOP_TABLE = "shop_shops";
    public static String SHOPPERMISSION_TABLE = "shop_associates";
    public static final String ID = "ID";
    public static final String PLAYER = "Player";
    public static final String P1 = "Player1";
    public static final String P2 = "Player2";
    public static final String BUYER = "Buyer";
    public static final String SELLER = "Seller";
    public static final String QUANTITY = "Quantity";
    public static final String PRICE = "Price";
    public static final String BUY_OR_SELL = "Type";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final String WORLD = "World";
    public static final String ITEM_ID = "ItemID";
    public static final String ITEM_DATA = "ItemData";
    public static final String PERMISSIONS = "Pemissions";
    public static final String DATE = "Date";
    public static final String SPECIAL = "Special";
    String sql_create_database;
    String sql_create_pk_table = "CREATE TABLE IF NOT EXISTS " + SHOPSIGN_TABLE + " (" + "Player" + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + "World" + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + "x" + " INTEGER ," + "y" + " INTEGER ," + "z" + " INTEGER ," + "Special" + " INTEGER DEFAULT 0 NOT NULL," + "PRIMARY KEY (" + "World" + "," + "x" + ", " + "y" + "," + "z" + "," + "Special" + ")) ";
    String sql_create_transaction_table;
    String sql_create_total_table = "CREATE TABLE IF NOT EXISTS " + SHOPCHEST_TABLE + " (" + "Player" + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + "World" + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + "x" + " INTEGER ," + "y" + " INTEGER ," + "z" + " INTEGER ," + "ItemID" + " INTEGER NOT NULL," + "ItemData" + " INTEGER NOT NULL," + "Special" + " INTEGER DEFAULT 0 NOT NULL," + "PRIMARY KEY (" + "World" + "," + "x" + ", " + "y" + "," + "z" + "," + "ItemID" + "," + "ItemData" + "," + "Special" + ")) ";
    String sql_create_permissions_table = "CREATE TABLE IF NOT EXISTS " + SHOPPERMISSION_TABLE + " (" + "Player" + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + "Player2" + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + "PRIMARY KEY (" + "Player" + "," + "Player2" + ")) ";
    final String sql_getall_signs = "select Player,World,x,y,z from " + SHOPSIGN_TABLE;
    final String sql_getall_shopassociates = "select Player,Player2 from " + SHOPPERMISSION_TABLE;
    final String sql_getall_chests = "select Player,World,x,y,z,ItemID,ItemData from " + SHOPCHEST_TABLE;
    String sql_insert_shopchest = "INSERT INTO " + SHOPCHEST_TABLE + " VALUES (?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE " + "Player" + " = VALUES(" + "Player" + ")" + "," + "ItemID" + " = VALUES(" + "ItemID" + ")" + "," + "ItemData" + " = VALUES(" + "ItemData" + ")";
    String sql_insert_shopsign = "INSERT INTO " + SHOPSIGN_TABLE + " VALUES (?,?,?,?,?,?) ON DUPLICATE KEY UPDATE " + "Player" + " = VALUES(" + "Player" + ")";
    String sql_insert_shopassociates = "INSERT IGNORE INTO " + SHOPPERMISSION_TABLE + " VALUES (?,?) ";
    final String sql_insert_transactions = "INSERT INTO " + TRANSACTION_TABLE + " VALUES (?,?,?,?,?,?,?,?,?,?) ";
    final String sql_delete_sign = "delete from " + SHOPSIGN_TABLE + " where " + "World" + "=? and " + "x" + "=? and " + "y" + "=? and " + "z" + "=? ";
    final String sql_delete_chest = "delete from " + SHOPCHEST_TABLE + " where " + "World" + "=? and " + "x" + "=? and " + "y" + "=? and " + "z" + "=? ";
    final String sql_delete_associate = "delete from " + SHOPPERMISSION_TABLE + " where " + "Player" + "=? and " + "Player2" + "=? ";
    final String get_player_transactions = "SELECT * FROM " + TRANSACTION_TABLE + " WHERE " + "Player2" + "=?";
    String get_player_transactions_ndays = "SELECT * FROM " + TRANSACTION_TABLE + " WHERE " + "Player2" + "=? AND " + "Date" + " >= (CURDATE() - INTERVAL ? DAY )";
    final String get_shop_transactions = "SELECT * FROM " + TRANSACTION_TABLE + " WHERE " + "Player1" + "=?";
    String get_shop_transactions_ndays = "SELECT * FROM " + TRANSACTION_TABLE + " WHERE " + "Player1" + "=? AND " + "Date" + " >= (CURDATE() - INTERVAL ? DAY )";
    protected TransactionLogger transactionLogger;

    public SQLInstance(TransactionLogger transactionLogger) {
        this.transactionLogger = transactionLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        switch (this.TYPE) {
            case MYSQL: {
                this.sql_create_transaction_table = "CREATE TABLE IF NOT EXISTS " + TRANSACTION_TABLE + " (" + ID + " INTEGER NOT NULL AUTO_INCREMENT," + P1 + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + P2 + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + BUY_OR_SELL + " TINYINT NOT NULL ," + ITEM_ID + " INTEGER ," + ITEM_DATA + " INTEGER ," + SPECIAL + " INTEGER ," + QUANTITY + " INTEGER ," + PRICE + " DOUBLE ," + DATE + " DATETIME," + "PRIMARY KEY (" + ID + "), INDEX USING BTREE (" + P1 + "),INDEX USING BTREE (" + P2 + "))";
                break;
            }
            case SQLITE: {
                this.sql_create_total_table = "CREATE TABLE IF NOT EXISTS " + SHOPCHEST_TABLE + " (" + PLAYER + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + WORLD + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + X + " INTEGER ," + Y + " INTEGER ," + Z + " INTEGER ," + ITEM_ID + " INTEGER NOT NULL," + ITEM_DATA + " INTEGER NOT NULL," + SPECIAL + " INTEGER DEFAULT 0 NOT NULL," + "PRIMARY KEY (" + WORLD + "," + X + ", " + Y + "," + Z + "," + ITEM_ID + "," + ITEM_DATA + "," + SPECIAL + ")) ";
                this.sql_create_pk_table = "CREATE TABLE IF NOT EXISTS " + SHOPSIGN_TABLE + " (" + PLAYER + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + WORLD + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + X + " INTEGER ," + Y + " INTEGER ," + Z + " INTEGER ," + SPECIAL + " INTEGER DEFAULT 0 NOT NULL," + "PRIMARY KEY (" + WORLD + "," + X + ", " + Y + "," + Z + "," + SPECIAL + ")) ";
                this.sql_create_transaction_table = "CREATE TABLE IF NOT EXISTS " + TRANSACTION_TABLE + " (" + ID + " INTEGER NOT NULL ," + P1 + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + P2 + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + BUY_OR_SELL + " TINYINT NOT NULL ," + ITEM_ID + " INTEGER ," + ITEM_DATA + " INTEGER ," + SPECIAL + " INTEGER ," + QUANTITY + " INTEGER ," + PRICE + " DOUBLE ," + DATE + " DATETIME," + "PRIMARY KEY (" + ID + "))";
                this.sql_create_permissions_table = "CREATE TABLE IF NOT EXISTS " + SHOPPERMISSION_TABLE + " (" + PLAYER + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + P2 + " VARCHAR(" + MAX_NAME_LENGTH + ") NOT NULL ," + "PRIMARY KEY (" + PLAYER + "," + P2 + ")) ";
                this.sql_insert_shopchest = "INSERT OR REPLACE INTO " + SHOPCHEST_TABLE + " VALUES (?,?,?,?,?,?,?,?)";
                this.sql_insert_shopsign = "INSERT OR REPLACE INTO " + SHOPSIGN_TABLE + " VALUES (?,?,?,?,?,?)";
                this.sql_insert_shopassociates = "INSERT OR IGNORE INTO " + SHOPPERMISSION_TABLE + " VALUES (?,?) ";
                this.get_player_transactions_ndays = "SELECT * FROM " + TRANSACTION_TABLE + " WHERE " + P2 + "=? AND " + DATE + " >= (julianday(date('now'))- ?)";
                this.get_shop_transactions_ndays = "SELECT * FROM " + TRANSACTION_TABLE + " WHERE " + P1 + "=? AND " + DATE + " >=  (julianday(date('now'))- ?)";
            }
        }
        if (this.shouldUpdateTo3point4()) {
            this.updateTo3Point4();
        }
        Connection con = null;
        try {
            con = this.getConnection();
            this.createTable(con, SHOPSIGN_TABLE, this.sql_create_pk_table, new String[0]);
            this.createTable(con, SHOPCHEST_TABLE, this.sql_create_total_table, new String[0]);
            this.createTable(con, SHOPPERMISSION_TABLE, this.sql_create_permissions_table, new String[0]);
            this.createTable(con, TRANSACTION_TABLE, this.sql_create_transaction_table, new String[0]);
            this.closeConnection(con);
        }
        catch (SQLException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(con);
        }
        return true;
    }

    @Override
    public void saveAll() {
        this.saveSigns();
        this.saveChests();
        this.saveShops();
        this.saveTransactions();
    }

    @Override
    public void loadAll() {
        this.loadChests();
        this.loadSigns();
        this.loadShops();
        MCServer.scheduleSyncDelayedTask(BattleShops.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ShopController.updateAllSigns();
            }
        }, 2000L);
    }

    private void loadChests() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SQLSerializer.RSCon rscon = SQLInstance.this.executeQuery(SQLInstance.this.sql_getall_chests, new Object[0]);
                if (rscon == null || rscon.rs == null) {
                    return;
                }
                final ArrayList results = SQLInstance.this.convertToResult(rscon);
                if (results == null) {
                    return;
                }
                SQLInstance.this.close(rscon);
                MCServer.scheduleSyncDelayedTask(BattleShops.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        SQLInstance.this.loadSyncChests(results);
                    }
                });
            }
        }).start();
    }

    public void loadShops() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SQLSerializer.RSCon rscon = SQLInstance.this.executeQuery(SQLInstance.this.sql_getall_shopassociates, new Object[0]);
                if (rscon == null || rscon.rs == null) {
                    return;
                }
                final ArrayList results = SQLInstance.this.convertToResult(rscon);
                if (results == null) {
                    return;
                }
                SQLInstance.this.close(rscon);
                MCServer.scheduleSyncDelayedTask(BattleShops.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        SQLInstance.this.loadSyncShops(results);
                    }
                });
            }
        });
    }

    private void loadSyncChests(ArrayList<Map<String, Object>> results) {
        LinkedList<StringLocation> bad_locs = new LinkedList<StringLocation>();
        HashMap<String, ShopChest> map = new HashMap<String, ShopChest>();
        try {
            for (Map<String, Object> rs : results) {
                String worldname = null;
                Integer x = null;
                Integer y = null;
                Integer z = null;
                try {
                    String player = this.getString(rs, PLAYER);
                    worldname = this.getString(rs, WORLD);
                    x = this.getInt(rs, X);
                    y = this.getInt(rs, Y);
                    z = this.getInt(rs, Z);
                    int itemid = this.getInt(rs, ITEM_ID);
                    int datavalue = this.getInt(rs, ITEM_DATA);
                    MCWorld world = MCServer.getWorld(worldname);
                    if (world == null) {
                        bad_locs.add(new StringLocation(worldname, x, y, z));
                        Log.warn("Ignoring chest at " + SQLInstance.toString(worldname, x, y, z) + " as world no longer exists");
                        continue;
                    }
                    MCBlock b = world.getBlockAt(x, y, z);
                    MCChest chest = (MCChest)world.toType(b, MCChest.class);
                    if (chest == null) {
                        bad_locs.add(new StringLocation(worldname, x, y, z));
                        Log.warn("Ignoring chest at " + SQLInstance.toString(worldname, x, y, z) + " as chest no longer exists");
                        continue;
                    }
                    ShopOwner owner = new ShopOwner(player);
                    ShopChest sc = (ShopChest)map.get(KeyUtil.getStringLoc(b));
                    if (sc == null) {
                        sc = new ShopChest(chest, owner, new ArrayList<MCItemStack>());
                    }
                    if (!EverythingItem.isEverythingID(itemid, (short)datavalue)) {
                        sc.addItemID(ItemFactory.createItem(itemid, (short)datavalue, 1));
                    } else {
                        sc.addItemID(EverythingItem.EVERYTHING_ITEM);
                    }
                    map.put(KeyUtil.getStringLoc(b), sc);
                }
                catch (Exception error) {
                    bad_locs.add(new StringLocation(worldname, x, y, z));
                    error.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ShopChest sc : map.values()) {
            ShopController.addShopChest(sc);
        }
        this.deleteChestLocations(bad_locs);
    }

    private void loadSyncShops(ArrayList<Map<String, Object>> results) {
        try {
            HashMap<String, HashSet<String>> shopsWithAssociates = new HashMap<String, HashSet<String>>();
            for (Map<String, Object> rs : results) {
                String player = this.getString(rs, PLAYER);
                String p2 = this.getString(rs, P2);
                HashSet<String> associates = (HashSet<String>)shopsWithAssociates.get(player);
                if (associates == null) {
                    associates = new HashSet<String>();
                    shopsWithAssociates.put(player, associates);
                }
                associates.add(p2);
            }
            Map<MCWorld, Map<String, Shop>> allshops = ShopController.getAllShops();
            for (MCWorld w : allshops.keySet()) {
                Map<String, Shop> shops = allshops.get(w);
                for (String player : shopsWithAssociates.keySet()) {
                    Shop s = shops.get(player);
                    if (s == null) {
                        ShopOwner so = new ShopOwner(player);
                        s = new Shop(so);
                        shops.put(ShopOwner.getShopOwnerKey(so), s);
                    }
                    for (String associate : (Set)shopsWithAssociates.get(player)) {
                        s.addToAssociates(associate);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSigns() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SQLSerializer.RSCon rscon = SQLInstance.this.executeQuery(SQLInstance.this.sql_getall_signs, new Object[0]);
                if (rscon == null || rscon.rs == null) {
                    return;
                }
                final ArrayList results = SQLInstance.this.convertToResult(rscon);
                if (results == null || results.isEmpty()) {
                    return;
                }
                SQLInstance.this.close(rscon);
                MCServer.scheduleSyncDelayedTask(BattleShops.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        SQLInstance.this.loadSyncSigns(results);
                    }
                });
            }
        }).start();
    }

    private void loadSyncSigns(ArrayList<Map<String, Object>> results) {
        LinkedList<StringLocation> bad_locs = new LinkedList<StringLocation>();
        ArrayList<ShopSign> list = new ArrayList<ShopSign>();
        try {
            for (Map<String, Object> rs : results) {
                String worldname = null;
                Integer x = null;
                Integer y = null;
                Integer z = null;
                try {
                    String player = this.getString(rs, PLAYER);
                    worldname = this.getString(rs, WORLD);
                    x = this.getInt(rs, X);
                    y = this.getInt(rs, Y);
                    z = this.getInt(rs, Z);
                    MCWorld world = MCServer.getWorld(worldname);
                    if (world == null) {
                        Log.warn("Ignoring sign at " + SQLInstance.toString(worldname, x, y, z) + " as that world no longer exists");
                        bad_locs.add(new StringLocation(worldname, x, y, z));
                        continue;
                    }
                    MCBlock b = world.getBlockAt(x, y, z);
                    MCSign sign = (MCSign)world.toType(b, MCSign.class);
                    if (sign == null) {
                        bad_locs.add(new StringLocation(worldname, x, y, z));
                        continue;
                    }
                    ShopOwner owner = new ShopOwner(player);
                    String[] lines = sign.getLines();
                    SignValues sv = null;
                    try {
                        sv = SignParser.parseShopSign(lines);
                    }
                    catch (SignFormatException e) {
                        Log.warn("[BattleShops] couldnt reparse sign!!!! " + SQLInstance.toString(worldname, x, y, z));
                        sign.setLine(1, "0 : U");
                        sign.setLine(3, "None");
                        bad_locs.add(new StringLocation(world.getName(), x, y, z));
                        continue;
                    }
                    ShopSign ss = new ShopSign(owner, sign, sv);
                    list.add(ss);
                }
                catch (Exception error) {
                    error.printStackTrace();
                    if (worldname == null || x == null || y == null || z == null) continue;
                    bad_locs.add(new StringLocation(worldname, x, y, z));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ShopSign ss : list) {
            try {
                ShopController.addShopSign(ss);
            }
            catch (Exception e) {
                Log.err("Error adding shopsign " + ss + " to the shops ");
                e.printStackTrace();
            }
        }
        this.deleteSignLocations(bad_locs);
    }

    private void saveSigns() {
        Map<MCWorld, Map<String, ShopSign>> allsigns = ShopController.getAllSigns();
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (MCWorld w : allsigns.keySet()) {
            Map<String, ShopSign> map = allsigns.get(w);
            if (map == null || map.isEmpty()) continue;
            for (ShopSign ss : map.values()) {
                String player = ss.getOwner().getName();
                String world = ss.getWorld().getName();
                int x = ss.getX();
                int y = ss.getY();
                int z = ss.getZ();
                batch.add(Arrays.asList(player, world, x, y, z, ss.getItemStack().isSpecial()));
            }
        }
        this.executeBatch(BattleShops.isEnabled(), this.sql_insert_shopsign, batch);
    }

    private void saveChests() {
        Map<MCWorld, Map<String, ShopChest>> allchests = ShopController.getAllChests();
        if (allchests == null || allchests.isEmpty()) {
            return;
        }
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (MCWorld w : allchests.keySet()) {
            Map<String, ShopChest> map = allchests.get(w);
            if (map == null || map.isEmpty()) continue;
            for (ShopChest sc : map.values()) {
                String player = sc.getOwner().getName();
                String world = sc.getWorld().getName();
                int x = sc.getX();
                int y = sc.getY();
                int z = sc.getZ();
                List<MCItemStack> ids = sc.getItemIds();
                for (MCItemStack item : ids) {
                    batch.add(Arrays.asList(player, world, x, y, z, item.getType(), item.getDataValue(), item.isSpecial()));
                }
            }
        }
        this.executeBatch(BattleShops.isEnabled(), this.sql_insert_shopchest, batch);
    }

    private void saveShops() {
        Map<MCWorld, Map<String, Shop>> allshops = ShopController.getAllShops();
        if (allshops == null || allshops.size() <= 0) {
            return;
        }
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (MCWorld w : allshops.keySet()) {
            Map<String, Shop> shops = allshops.get(w);
            for (String player : shops.keySet()) {
                Set<String> associates = shops.get(player).getAssociates();
                if (associates == null) continue;
                for (String associate : associates) {
                    batch.add(Arrays.asList(player, associate));
                }
            }
        }
        this.executeBatch(BattleShops.isEnabled(), this.sql_insert_shopassociates, batch);
    }

    private void saveTransactions() {
        this.saveTransactions(this.transactionLogger.getTransactionsAndClear());
    }

    public static String toString(String worldname, int x, int y, int z) {
        return worldname + ":" + x + ":" + y + ":" + z;
    }

    public String toString() {
        return "[SQLInstance " + this.getDB() + "  " + URL + "   " + PORT + "   " + USERNAME + "]";
    }

    private void deleteChestLocations(List<StringLocation> locs) {
        this.deleteLocations(this.sql_delete_chest, locs);
    }

    private void deleteSignLocations(List<StringLocation> locs) {
        this.deleteLocations(this.sql_delete_sign, locs);
    }

    private void deleteLocations(String stmt, List<StringLocation> locs) {
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (StringLocation l : locs) {
            batch.add(Arrays.asList(l.getWorldName(), l.getBlockX(), l.getBlockY(), l.getBlockZ()));
        }
        this.executeBatch(BattleShops.isEnabled(), stmt, batch);
    }

    @Override
    public void deleteShopChest(ShopChest chest) {
        this.executeUpdate(BattleShops.isEnabled(), this.sql_delete_chest, chest.getWorld().getName(), chest.getX(), chest.getY(), chest.getZ());
    }

    @Override
    public void deleteShopSign(ShopSign ss) {
        this.executeUpdate(BattleShops.isEnabled(), this.sql_delete_sign, ss.getWorld().getName(), ss.getLocation().getBlockX(), ss.getLocation().getBlockY(), ss.getLocation().getBlockZ());
    }

    @Override
    public void deleteAssociate(String p1, String p2) {
        this.executeUpdate(this.sql_delete_associate, p1, p2);
    }

    @Override
    public void saveTransactions(Collection<Transaction> trs) {
        if (trs.isEmpty()) {
            return;
        }
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (Transaction tr : trs) {
            int b = tr.buying ? 1 : 0;
            Timestamp ts = new Timestamp(tr.cal.getTimeInMillis());
            batch.add(Arrays.asList(null, tr.p1, tr.p2, b, tr.itemid, tr.datavalue, tr.special, tr.quantity, Float.valueOf(tr.price), ts));
        }
        this.executeBatch(BattleShops.isEnabled(), this.sql_insert_transactions, batch);
    }

    @Override
    public List<Transaction> getPlayerTransactions(String name, Integer ndays) {
        return this.getTransactions(name, ndays, this.get_player_transactions_ndays);
    }

    @Override
    public List<Transaction> getShopTransactions(String name, Integer ndays) {
        return this.getTransactions(name, ndays, this.get_shop_transactions_ndays);
    }

    private List<Transaction> getTransactions(String name, Integer ndays, String sqlStatement) {
        if (ndays == null) {
            ndays = 1;
        }
        this.saveTransactions();
        SQLSerializer.RSCon rs = this.executeQuery(sqlStatement, name, ndays);
        return this.parseTransactionResults(rs);
    }

    private List<Transaction> parseTransactionResults(SQLSerializer.RSCon rscon) {
        ArrayList<Transaction> trs = new ArrayList<Transaction>();
        if (rscon == null || rscon.rs == null) {
            return trs;
        }
        try {
            ResultSet rs = rscon.rs;
            while (rs.next()) {
                String p1 = rs.getString(P1);
                String p2 = rs.getString(P2);
                boolean buying = rs.getInt(BUY_OR_SELL) > 0;
                int itemid = rs.getInt(ITEM_ID);
                int datavalue = rs.getInt(ITEM_DATA);
                int quantity = rs.getInt(QUANTITY);
                int price = rs.getInt(PRICE);
                Timestamp ts = rs.getTimestamp(DATE);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(ts.getTime());
                Transaction tr = new Transaction(p1, p2, buying, itemid, datavalue, quantity, price, cal);
                trs.add(tr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trs;
    }

    @Override
    public void deleteShopChest(MCChest chest) {
        this.executeUpdate(BattleShops.isEnabled(), this.sql_delete_chest, chest.getWorld().getName(), chest.getX(), chest.getY(), chest.getZ());
    }

    public boolean shouldUpdateTo3point4() {
        return this.hasTable("transactions") != false && this.hasTable(TRANSACTION_TABLE) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTo3Point4() {
        if (!this.shouldUpdateTo3point4()) {
            return;
        }
        Log.warn("[BattleShops] updating database to 3.4");
        String rename2 = null;
        String rename3 = null;
        String rename4 = null;
        String alter1 = "ALTER TABLE " + SHOPSIGN_TABLE + " ADD " + SPECIAL + " INTEGER DEFAULT 0 NOT NULL";
        String alter2 = "ALTER TABLE " + TRANSACTION_TABLE + " ADD " + ITEM_DATA + " INTEGER DEFAULT 0 NOT NULL AFTER ItemID";
        String alter3 = "ALTER TABLE " + TRANSACTION_TABLE + " ADD " + SPECIAL + " INTEGER DEFAULT 0 AFTER " + ITEM_DATA;
        switch (this.TYPE) {
            case MYSQL: {
                rename2 = "RENAME TABLE signs TO " + SHOPSIGN_TABLE;
                rename3 = "RENAME TABLE transactions TO " + TRANSACTION_TABLE;
                rename4 = "RENAME TABLE associates TO " + SHOPPERMISSION_TABLE;
                break;
            }
            case SQLITE: {
                rename2 = "ALTER TABLE signs RENAME TO " + SHOPSIGN_TABLE;
                rename4 = "ALTER TABLE associates RENAME TO " + SHOPPERMISSION_TABLE;
            }
        }
        this.executeUpdate(rename2, new Object[0]);
        this.executeUpdate(rename4, new Object[0]);
        Connection con = null;
        try {
            con = this.getConnection();
            this.createTable(con, SHOPCHEST_TABLE, this.sql_create_total_table, new String[0]);
            if (this.TYPE == SQLSerializer.SQLType.SQLITE) {
                this.createTable(con, TRANSACTION_TABLE, this.sql_create_transaction_table, new String[0]);
            }
            this.closeConnection(con);
        }
        catch (SQLException e) {
        }
        finally {
            this.closeConnection(con);
        }
        String getall_chests = "select Player,World,x,y,z, ItemIDS from chests";
        SQLSerializer.RSCon rscon = this.executeQuery(getall_chests, new Object[0]);
        if (rscon == null || rscon.rs == null) {
            return;
        }
        ArrayList<Map<String, Object>> results = this.convertToResult(rscon);
        this.close(rscon);
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (Map<String, Object> rs : results) {
            try {
                String[] strids;
                String player = this.getString(rs, PLAYER);
                String worldname = this.getString(rs, WORLD);
                int x = this.getInt(rs, X);
                int y = this.getInt(rs, Y);
                int z = this.getInt(rs, Z);
                String stritemids = this.getString(rs, "ItemIDs");
                if (stritemids == "") continue;
                for (String s : strids = stritemids.split(",")) {
                    int id = Integer.valueOf(s);
                    if (id <= 0) continue;
                    int type = id % 100000;
                    int datavalue = id / 100000;
                    batch.add(Arrays.asList(player, worldname, x, y, z, type, datavalue, 0));
                }
            }
            catch (Exception e) {
            }
        }
        this.executeBatch(false, this.sql_insert_shopchest, batch);
        this.executeUpdate(alter1, new Object[0]);
        switch (this.TYPE) {
            case MYSQL: {
                this.executeUpdate(rename3, new Object[0]);
                this.executeUpdate(alter2, new Object[0]);
                this.executeUpdate(alter3, new Object[0]);
                break;
            }
            case SQLITE: {
                String reinsert = "INSERT INTO " + TRANSACTION_TABLE + " SELECT " + ID + "," + P1 + "," + P2 + ", " + BUY_OR_SELL + "," + ITEM_ID + "%100000," + ITEM_ID + "/100000,0," + QUANTITY + "," + PRICE + "," + DATE + " FROM transactions;";
                this.executeUpdate(reinsert, new Object[0]);
            }
        }
        this.executeUpdate("drop table chests", new Object[0]);
    }
}

