/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.shops.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class CompositeMap<T> {
    HashMap<Integer, HashMap<Integer, T>> map = new HashMap();

    public T put(int l, int h, T value) {
        HashMap<Integer, Object> map2 = this.map.get(l);
        if (map2 == null) {
            map2 = new HashMap();
            this.map.put(l, map2);
        }
        return map2.put(h, value);
    }

    public T put(long key, T value) {
        int l = (int)(key >> 32);
        int h = (int)key;
        HashMap<Integer, Object> map2 = this.map.get(l);
        if (map2 == null) {
            map2 = new HashMap();
            this.map.put(l, map2);
        }
        return map2.put(h, value);
    }

    public void clear() {
        this.map.clear();
    }

    public static long toKey(int hob, int lob) {
        return (long)hob << 32 | (long)lob & 0xFFFFFFFFL;
    }

    public boolean containsKey(long key) {
        int l = (int)(key >> 32);
        int h = (int)key;
        HashMap<Integer, T> map2 = this.map.get(l);
        return map2 != null && map2.containsKey(h);
    }

    public T get(long key) {
        int hob = (int)(key >> 32);
        int lob = (int)key;
        HashMap<Integer, T> map2 = this.map.get(hob);
        return map2 == null ? null : (T)map2.get(lob);
    }

    public T remove(long key) {
        int l = (int)(key >> 32);
        int h = (int)key;
        HashMap<Integer, T> map2 = this.map.get(l);
        return map2 == null ? null : (T)map2.remove(h);
    }

    public Collection<Long> keySet() {
        ArrayList<Long> keys = new ArrayList<Long>();
        Long base = 0L;
        for (Integer k : this.map.keySet()) {
            base = (long)k.intValue() << 32;
            for (Integer k2 : this.map.get(k).keySet()) {
                keys.add(base | (long)k2.intValue() & 0xFFFFFFFFL);
            }
        }
        return keys;
    }

    public Collection<T> values() {
        ArrayList<T> values = new ArrayList<T>();
        for (HashMap<Integer, T> v : this.map.values()) {
            for (T t : v.values()) {
                values.add(t);
            }
        }
        return values;
    }

    public static int getHOB(long itemid) {
        return (int)(itemid >> 32);
    }

    public static int getLOB(long itemid) {
        return (int)itemid;
    }
}

