package info.jbcs.minecraft.utilities;

import java.util.HashMap;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class General {
	public static Random rand = new Random();

	public static boolean isInRange(double distance, double x1, double y1, double z1, double x2, double y2, double z2) {
		double x = x1 - x2;
		double y = y1 - y2;
		double z = z1 - z2;

		return x * x + y * y + z * z < distance * distance;
	}

	public static Item getItem(ItemStack chiseledItem) {
		if (chiseledItem == null)
			return null;
		if (chiseledItem.itemID < 0)
			return null;
		if (chiseledItem.itemID >= Item.itemsList.length)
			return null;

		return Item.itemsList[chiseledItem.itemID];
	}

	public static Block getBlock(int blockId) {
		if (blockId < 0)
			return null;
		if (blockId >= Block.blocksList.length)
			return null;
		
		return Block.blocksList[blockId];
	}

	public static String getUnlocalizedName(Block block) {
		String name=block.getUnlocalizedName();
			if(name.startsWith("tile.")) name=name.substring(5);
			
			return name;
	}
	
	static HashMap<String,Block> blockMapping;
	public static Block getBlock(String s){
		if(blockMapping==null){
			blockMapping=new HashMap<String,Block>();
			
			for(Block block: Block.blocksList){
				if(block==null) continue;
				String name=block.getUnlocalizedName();
				if(name.startsWith("tile.")) name=name.substring(5);
				
				blockMapping.put(name.toLowerCase(), block);
			}
		}
		
		return blockMapping.get(s.toLowerCase());		
	}
	
	public static String getName(Block block){
		String res=block.getUnlocalizedName();
		return res.substring(5);
	}
}
