/*
 * Decompiled with CFR 0.152.
 */
package me.cnaude.plugin.Scavenger;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.comphenix.protocol.utility.StreamSerializer;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.api.GroupManager;
import com.onarandombox.multiverseinventories.api.profile.WorldGroupProfile;
import com.orange451.UltimateArena.UltimateArenaAPI;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.timvisee.DungeonMaze.API.DungeonMazeAPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.objects.ArenaPlayer;
import me.cnaude.plugin.Scavenger.Restoration;
import me.cnaude.plugin.Scavenger.RestorationS;
import me.cnaude.plugin.Scavenger.RestorationS1;
import me.cnaude.plugin.Scavenger.Scavenger;
import net.milkbowl.vault.economy.EconomyResponse;
import net.slipcor.pvparena.api.PVPArenaAPI;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import uk.co.tggl.pluckerpluck.multiinv.MultiInvAPI;

public class RestorationManager
implements Serializable {
    private static HashMap<String, Restoration> restorations = new HashMap();

    public void save() {
        StreamSerializer serializer = new StreamSerializer();
        HashMap<String, RestorationS1> res_s = new HashMap<String, RestorationS1>();
        for (Map.Entry<String, Restoration> entry : restorations.entrySet()) {
            String key = entry.getKey();
            Restoration value = entry.getValue();
            RestorationS1 restoration_s = new RestorationS1();
            for (ItemStack i : value.inventory) {
                if (!(i instanceof ItemStack)) continue;
                Scavenger.get().debugMessage("Serializing: " + i.toString());
                try {
                    restoration_s.inventory.add(serializer.serializeItemStack(i));
                }
                catch (IOException e) {
                    Scavenger.get().logError(e.getMessage());
                }
                Scavenger.get().debugMessage("Done: " + i.toString());
            }
            for (ItemStack i : value.armour) {
                if (!(i instanceof ItemStack)) continue;
                Scavenger.get().debugMessage("Serializing: " + i.toString());
                try {
                    restoration_s.armour.add(serializer.serializeItemStack(i));
                }
                catch (IOException e) {
                    Scavenger.get().logError(e.getMessage());
                }
                Scavenger.get().debugMessage("Done: " + i.toString());
            }
            restoration_s.enabled = value.enabled;
            restoration_s.level = value.level;
            restoration_s.exp = value.exp;
            res_s.put(key, restoration_s);
            Scavenger.get().logInfo("Saving " + key + "'s inventory to disk. (New format)");
        }
        try {
            File file = new File("plugins/Scavenger/inv1.ser");
            FileOutputStream f_out = new FileOutputStream(file);
            ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(res_s);
            obj_out.close();
        }
        catch (Exception e) {
            Scavenger.get().logError(e.getMessage());
        }
    }

    public void load() {
        HashMap res_s;
        File file = new File("plugins/Scavenger/inv.ser");
        if (!file.exists()) {
            Scavenger.get().logInfo("Recovery file '" + file.getAbsolutePath() + "' does not exist. (Old format)");
            return;
        }
        try {
            FileInputStream f_in = new FileInputStream(file);
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            res_s = (HashMap)obj_in.readObject();
            obj_in.close();
        }
        catch (Exception e) {
            Scavenger.get().logError(e.getMessage());
            file.delete();
            return;
        }
        for (Map.Entry entry : res_s.entrySet()) {
            int i;
            String key = (String)entry.getKey();
            RestorationS value = (RestorationS)entry.getValue();
            Restoration restoration = new Restoration();
            restoration.inventory = new ItemStack[value.inventory.size()];
            restoration.armour = new ItemStack[value.armour.size()];
            for (i = 0; i < value.inventory.size(); ++i) {
                if (!(value.inventory.get(i) instanceof Map)) continue;
                Scavenger.get().debugMessage("Deserializing: " + value.inventory.get(i).toString());
                restoration.inventory[i] = ItemStack.deserialize(value.inventory.get(i));
                Scavenger.get().debugMessage("Done: " + restoration.inventory[i].toString());
            }
            for (i = 0; i < value.armour.size(); ++i) {
                if (!(value.armour.get(i) instanceof Map)) continue;
                Scavenger.get().debugMessage("Deserializing: " + value.armour.get(i).toString());
                restoration.armour[i] = ItemStack.deserialize(value.armour.get(i));
                Scavenger.get().debugMessage("Done: " + restoration.armour[i].toString());
            }
            restoration.enabled = value.enabled;
            restoration.level = value.level;
            restoration.exp = value.exp;
            restorations.put(key, restoration);
            Scavenger.get().logInfo("Loading " + key + "'s inventory from disk.");
        }
        file.renameTo(new File("plugins/Scavenger/inv.ser.old"));
    }

    public void load1() {
        HashMap res_s;
        StreamSerializer serializer = new StreamSerializer();
        File file = new File("plugins/Scavenger/inv1.ser");
        if (!file.exists()) {
            Scavenger.get().logInfo("Recovery file '" + file.getAbsolutePath() + "' does not exist. (New format)");
            return;
        }
        try {
            FileInputStream f_in = new FileInputStream(file);
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            res_s = (HashMap)obj_in.readObject();
            obj_in.close();
        }
        catch (Exception e) {
            Scavenger.get().logError(e.getMessage());
            return;
        }
        for (Map.Entry entry : res_s.entrySet()) {
            ItemStack tmpStack;
            int i;
            String key = (String)entry.getKey();
            RestorationS1 value = (RestorationS1)entry.getValue();
            Restoration restoration = new Restoration();
            restoration.inventory = new ItemStack[value.inventory.size()];
            restoration.armour = new ItemStack[value.armour.size()];
            for (i = 0; i < value.inventory.size(); ++i) {
                if (!(value.inventory.get(i) instanceof String)) continue;
                tmpStack = new ItemStack(Material.AIR);
                Scavenger.get().debugMessage("Deserializing: " + value.inventory.get(i).toString());
                try {
                    tmpStack = serializer.deserializeItemStack(value.inventory.get(i));
                }
                catch (IOException e) {
                    Scavenger.get().logError(e.getMessage());
                }
                restoration.inventory[i] = tmpStack == null ? new ItemStack(Material.AIR) : tmpStack;
                Scavenger.get().debugMessage("Done: " + restoration.inventory[i].toString());
            }
            for (i = 0; i < value.armour.size(); ++i) {
                if (!(value.armour.get(i) instanceof String)) continue;
                tmpStack = new ItemStack(Material.AIR);
                Scavenger.get().debugMessage("Deserializing: " + value.armour.get(i).toString());
                try {
                    tmpStack = serializer.deserializeItemStack(value.armour.get(i));
                }
                catch (IOException e) {
                    Scavenger.get().logError(e.getMessage());
                }
                restoration.armour[i] = tmpStack == null ? new ItemStack(Material.AIR) : tmpStack;
                Scavenger.get().debugMessage("Done: " + restoration.armour[i].toString());
            }
            restoration.enabled = value.enabled;
            restoration.level = value.level;
            restoration.exp = value.exp;
            restorations.put(key, restoration);
            Scavenger.get().logInfo("Loading " + key + "'s inventory from disk.");
        }
    }

    public static boolean hasRestoration(Player p) {
        String keyName;
        if ((Scavenger.get().getMultiverseInventories() != null || Scavenger.get().getMultiInvInventories() != null) && restorations.containsKey(keyName = p.getName() + "." + RestorationManager.getWorldGroups(p.getWorld()).get(0))) {
            Scavenger.get().logDebug("Has: " + keyName);
            return true;
        }
        return restorations.containsKey(p.getName());
    }

    public static Restoration getRestoration(Player p) {
        String keyName;
        Restoration restoration = new Restoration();
        restoration.enabled = false;
        if ((Scavenger.get().getMultiverseInventories() != null || Scavenger.get().getMultiInvInventories() != null) && restorations.containsKey(keyName = p.getName() + "." + RestorationManager.getWorldGroups(p.getWorld()).get(0))) {
            Scavenger.get().logDebug("Getting: " + keyName);
            restoration = restorations.get(keyName);
        }
        if (!restoration.enabled && restorations.containsKey(p.getName())) {
            Scavenger.get().logDebug("Getting: " + p.getName());
            restoration = restorations.get(p.getName());
        }
        return restoration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void collect(Player p, List<ItemStack> _drops, EntityDeathEvent event) {
        ItemStack[] a;
        int len$;
        ItemStack[][] invAndArmour;
        block54: {
            block53: {
                EconomyResponse er;
                double withdraw_amount;
                Match match;
                ArenaPlayer ap;
                ClaimedResidence res;
                if (_drops.isEmpty() && !RestorationManager.levelAllow(p) && !RestorationManager.expAllow(p)) {
                    return;
                }
                if (Scavenger.getSConfig().dropOnPVPDeath() && p.getKiller() instanceof Player) {
                    Scavenger.get().message(p, Scavenger.getSConfig().msgPVPDeath());
                    return;
                }
                if (Scavenger.getSConfig().residence() && (res = Residence.getResidenceManager().getByLoc(p.getLocation())) != null) {
                    ResidencePermissions perms = res.getPermissions();
                    if (perms.playerHas(p.getName(), Scavenger.getSConfig().resFlag(), true)) {
                        Scavenger.get().logDebug("Player '" + p.getName() + "' is not allowed to use Scavenger in this residence. Items will be dropped.");
                        Scavenger.get().message(p, Scavenger.getSConfig().msgInsideRes());
                        return;
                    }
                    Scavenger.get().logDebug("Player '" + p.getName() + "' is allowed to use Scavenger in this residence.");
                }
                if (Scavenger.getSConfig().factionEnemyDrops()) {
                    if (Scavenger.get().getFactions() != null) {
                        try {
                            Scavenger.get().logDebug("Checking if '" + p.getName() + "' is in enemy territory.");
                            FPlayer fplayer = (FPlayer)FPlayers.i.get(p);
                            Scavenger.get().logDebug("Relation: " + fplayer.getRelationToLocation().name());
                            if (fplayer.getRelationToLocation().name().equals("ENEMY")) {
                                Scavenger.get().logDebug("Player '" + p.getName() + "' is inside enemy territory!");
                                Scavenger.get().message(p, Scavenger.getSConfig().msgInsideEnemyFaction());
                                return;
                            }
                        }
                        catch (NoSuchMethodError ex) {
                            Scavenger.get().logDebug("ERROR: " + ex.getMessage());
                        }
                    } else {
                        Scavenger.get().logDebug("No Factions detected");
                    }
                }
                if (Scavenger.getSConfig().dungeonMazeDrops()) {
                    if (Scavenger.get().getDungeonMaze() != null) {
                        Scavenger.get().logDebug("Checking if '" + p.getName() + "' is in DungeonMaze.");
                        if (DungeonMazeAPI.isInDMWorld((Player)p)) {
                            Scavenger.get().logDebug("Player '" + p.getName() + "' is in DungeonMaze.");
                            Scavenger.get().message(p, Scavenger.getSConfig().msgInsideDungeonMaze());
                            return;
                        }
                    } else {
                        Scavenger.get().logDebug("No DungeonMaze plugin detected");
                    }
                }
                if (Scavenger.get().getWorldGuard() != null) {
                    Scavenger.get().logDebug("Checking region support for '" + p.getWorld().getName() + "'");
                    if (Scavenger.get().getWorldGuard().getRegionManager(p.getWorld()) != null) {
                        RegionManager regionManager = Scavenger.get().getWorldGuard().getRegionManager(p.getWorld());
                        ApplicableRegionSet set = regionManager.getApplicableRegions(p.getLocation());
                        if (set.allows(DefaultFlag.PVP) && Scavenger.getSConfig().wgPVPIgnore()) {
                            Scavenger.get().logDebug("This is a WorldGuard PVP zone and WorldGuardPVPIgnore is " + Scavenger.getSConfig().wgPVPIgnore());
                            if (!Scavenger.getSConfig().msgInsideWGPVP().isEmpty()) {
                                Scavenger.get().message(p, Scavenger.getSConfig().msgInsideWGPVP());
                            }
                            return;
                        }
                        if (!set.allows(DefaultFlag.PVP) && Scavenger.getSConfig().wgGuardPVPOnly()) {
                            Scavenger.get().logDebug("This is NOT a WorldGuard PVP zone and WorldGuardPVPOnly is " + Scavenger.getSConfig().wgGuardPVPOnly());
                            if (!Scavenger.getSConfig().msgInsideWGPVP().isEmpty()) {
                                Scavenger.get().message(p, Scavenger.getSConfig().msgInsideWGPVPOnly());
                            }
                            return;
                        }
                    } else {
                        Scavenger.get().logDebug("Region support disabled for '" + p.getWorld().getName() + "'");
                    }
                }
                if (Scavenger.get().getUltimateArena() != null) {
                    Scavenger.get().getUltimateArena();
                    if (UltimateArenaAPI.hookIntoUA().isPlayerInArenaLocation(p)) {
                        if (!Scavenger.getSConfig().msgInsideUA().isEmpty()) {
                            Scavenger.get().message(p, Scavenger.getSConfig().msgInsideUA());
                        }
                        return;
                    }
                }
                if (Scavenger.maHandler != null && Scavenger.maHandler.isPlayerInArena(p)) {
                    if (!Scavenger.getSConfig().msgInsideMA().isEmpty()) {
                        Scavenger.get().message(p, Scavenger.getSConfig().msgInsideMA());
                    }
                    return;
                }
                if (Scavenger.pvpHandler != null && !PVPArenaAPI.getArenaName((Player)p).equals("")) {
                    String x = Scavenger.getSConfig().msgInsidePA();
                    if (!x.isEmpty()) {
                        x = x.replaceAll("%ARENA%", PVPArenaAPI.getArenaName((Player)p));
                        Scavenger.get().message(p, x);
                    }
                    return;
                }
                if (Scavenger.battleArena && (ap = BattleArena.toArenaPlayer((Player)p)) != null && (match = BattleArena.getBAController().getMatch(ap)) != null && match.insideArena(ap)) {
                    String x = Scavenger.getSConfig().msgInsideBA();
                    if (!x.isEmpty()) {
                        Scavenger.get().message(p, x);
                    }
                    return;
                }
                if (RestorationManager.hasRestoration(p)) {
                    Scavenger.get().error(p, "Restoration already exists, ignoring.");
                    return;
                }
                if (Scavenger.get().getEconomy() == null || p.hasPermission("scavenger.free") || p.isOp() && Scavenger.getSConfig().opsAllPerms() || !Scavenger.getSConfig().economyEnabled()) break block53;
                double restore_cost = Scavenger.getSConfig().restoreCost();
                double player_balance = Scavenger.get().getEconomy().getBalance(p.getName());
                double percent_cost = Scavenger.getSConfig().percentCost();
                double min_cost = Scavenger.getSConfig().minCost();
                double max_cost = Scavenger.getSConfig().maxCost();
                if (Scavenger.getSConfig().percent()) {
                    withdraw_amount = player_balance * (percent_cost / 100.0);
                    if (Scavenger.getSConfig().addMin()) {
                        withdraw_amount += min_cost;
                    } else if (withdraw_amount < min_cost) {
                        withdraw_amount = min_cost;
                    }
                    if (withdraw_amount > max_cost && max_cost > 0.0) {
                        withdraw_amount = max_cost;
                    }
                } else {
                    withdraw_amount = restore_cost;
                }
                if ((er = Scavenger.get().getEconomy().withdrawPlayer(p.getName(), withdraw_amount)).transactionSuccess()) {
                    String currency = withdraw_amount == 1.0 ? Scavenger.get().getEconomy().currencyNameSingular() : Scavenger.get().getEconomy().currencyNamePlural();
                    String x = Scavenger.getSConfig().msgSaveForFee();
                    if (!x.isEmpty()) {
                        x = x.replaceAll("%COST%", String.format("%.2f", withdraw_amount));
                        x = x.replaceAll("%CURRENCY%", currency);
                        Scavenger.get().message(p, x);
                    }
                    break block54;
                } else {
                    String currency = player_balance == 1.0 ? Scavenger.get().getEconomy().currencyNameSingular() : Scavenger.get().getEconomy().currencyNamePlural();
                    String x = Scavenger.getSConfig().msgNotEnoughMoney();
                    if (!x.isEmpty()) {
                        x = x.replaceAll("%BALANCE%", String.format("%.2f", player_balance));
                        x = x.replaceAll("%COST%", String.format("%.2f", withdraw_amount));
                        x = x.replaceAll("%CURRENCY%", currency);
                        Scavenger.get().message(p, x);
                    }
                    return;
                }
            }
            Scavenger.get().message(p, Scavenger.getSConfig().msgSaving());
        }
        Restoration restoration = new Restoration();
        restoration.enabled = false;
        restoration.inventory = p.getInventory().getContents();
        restoration.armour = p.getInventory().getArmorContents();
        if (RestorationManager.levelAllow(p)) {
            restoration.level = p.getLevel();
        }
        if (RestorationManager.expAllow(p)) {
            restoration.exp = p.getExp();
            event.setDroppedExp(0);
        }
        _drops.clear();
        if (Scavenger.getSConfig().singleItemDrops()) {
            ItemStack[][] arr$ = invAndArmour = new ItemStack[][]{restoration.inventory, restoration.armour};
            len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                for (ItemStack i : a = arr$[i$]) {
                    if (!(i instanceof ItemStack) || i.getType().equals((Object)Material.AIR)) continue;
                    boolean dropIt = Scavenger.getSConfig().singleItemDropsOnly() ? !p.hasPermission("scavenger.drop." + i.getTypeId()) && !p.hasPermission("scavenger.drop.*") : p.hasPermission("scavenger.drop." + i.getTypeId()) && !p.hasPermission("scavenger.drop.*");
                    if (dropIt) {
                        Scavenger.get().debugMessage(p, "Dropping item " + i.getType());
                        _drops.add(i.clone());
                        i.setAmount(0);
                        continue;
                    }
                    Scavenger.get().debugMessage(p, "Keeping item " + i.getType());
                }
            }
        }
        if (Scavenger.getSConfig().chanceToDrop() > 0 && !p.hasPermission("scavenger.nochance")) {
            ItemStack[][] arr$ = invAndArmour = new ItemStack[][]{restoration.inventory, restoration.armour};
            len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                for (ItemStack i : a = arr$[i$]) {
                    if (!(i instanceof ItemStack) || i.getType().equals((Object)Material.AIR)) continue;
                    Random randomGenerator = new Random();
                    int randomInt = randomGenerator.nextInt(Scavenger.getSConfig().chanceToDrop()) + 1;
                    Scavenger.get().debugMessage(p, "Random number is " + randomInt);
                    if (randomInt == Scavenger.getSConfig().chanceToDrop()) {
                        Scavenger.get().debugMessage(p, "Randomly dropping item " + i.getType());
                        _drops.add(i.clone());
                        i.setAmount(0);
                        continue;
                    }
                    Scavenger.get().debugMessage(p, "Randomly keeping item " + i.getType());
                }
            }
        }
        if (Scavenger.getSConfig().slotBasedRecovery()) {
            RestorationManager.checkSlots(p, "armour", restoration.armour, _drops);
            RestorationManager.checkSlots(p, "inv", restoration.inventory, _drops);
        }
        RestorationManager.addRestoration(p, restoration);
    }

    private static void checkSlots(Player p, String type, ItemStack[] itemStackArray, List<ItemStack> _drops) {
        for (int i = 0; i < itemStackArray.length; ++i) {
            String itemType = itemStackArray[i] != null ? itemStackArray[i].getType().toString() : "NULL";
            Scavenger.get().debugMessage("[type:" + type + "] [p:" + p.getName() + "] [slot:" + i + "] [item:" + itemType + "] [perm:" + p.hasPermission("scavenger." + type + "." + i) + "]");
            if (!p.hasPermission("scavenger." + type + "." + i) && !itemType.equals("NULL")) {
                Scavenger.get().debugMessage(p, "Dropping: " + itemType);
                _drops.add(itemStackArray[i].clone());
                itemStackArray[i].setAmount(0);
                continue;
            }
            Scavenger.get().debugMessage(p, "Keeping: " + itemType);
        }
    }

    public static boolean levelAllow(Player p) {
        return (p.hasPermission("scavenger.level") || !Scavenger.getSConfig().permsEnabled() || p.isOp() && Scavenger.getSConfig().opsAllPerms()) && p.getLevel() > 0;
    }

    public static boolean expAllow(Player p) {
        return (p.hasPermission("scavenger.exp") || !Scavenger.getSConfig().permsEnabled() || p.isOp() && Scavenger.getSConfig().opsAllPerms()) && p.getExhaustion() > 0.0f;
    }

    public void printRestorations(Player p) {
        Scavenger.get().message(p, "Restorations:");
        for (String key : restorations.keySet()) {
            Scavenger.get().message(p, "  " + key);
        }
    }

    public void printRestorations() {
        Scavenger.get().logInfo("Restorations:");
        for (String key : restorations.keySet()) {
            Scavenger.get().logInfo("  " + key);
        }
    }

    public static void addRestoration(Player p, Restoration r) {
        if (Scavenger.get().getMultiverseInventories() != null || Scavenger.get().getMultiInvInventories() != null) {
            String keyName = p.getName() + "." + RestorationManager.getWorldGroups(p.getWorld()).get(0);
            restorations.put(keyName, r);
            Scavenger.get().debugMessage("Adding: " + keyName);
        } else {
            restorations.put(p.getName(), r);
            Scavenger.get().debugMessage("Adding: " + p.getName());
        }
    }

    public static void enable(Player p) {
        if (RestorationManager.hasRestoration(p)) {
            Restoration restoration = RestorationManager.getRestoration(p);
            restoration.enabled = true;
            Scavenger.get().debugMessage("Enabling: " + p.getName());
        } else {
            Scavenger.get().logDebug("Not enabling: " + p.getName());
        }
    }

    public static void restore(Player p) {
        Restoration restoration = RestorationManager.getRestoration(p);
        if (restoration.enabled) {
            p.getInventory().clear();
            p.getInventory().setContents(restoration.inventory);
            p.getInventory().setArmorContents(restoration.armour);
            if (p.hasPermission("scavenger.level") || !Scavenger.getSConfig().permsEnabled() || p.isOp() && Scavenger.getSConfig().opsAllPerms()) {
                p.setLevel(restoration.level);
            }
            if (p.hasPermission("scavenger.exp") || !Scavenger.getSConfig().permsEnabled() || p.isOp() && Scavenger.getSConfig().opsAllPerms()) {
                p.setExp(restoration.exp);
            }
            if (Scavenger.getSConfig().shouldNotify()) {
                Scavenger.get().message(p, Scavenger.getSConfig().msgRecovered());
            }
            RestorationManager.removeRestoration(p);
            if (RestorationManager.hasRestoration(p)) {
                Scavenger.get().message(p, "Restore exists!!!");
            }
        }
    }

    public static void removeRestoration(Player p) {
        String keyName;
        if ((Scavenger.get().getMultiverseInventories() != null || Scavenger.get().getMultiInvInventories() != null) && restorations.containsKey(keyName = p.getName() + "." + RestorationManager.getWorldGroups(p.getWorld()).get(0))) {
            restorations.remove(keyName);
            Scavenger.get().logDebug("Removing: " + keyName);
        }
        if (restorations.containsKey(p.getName())) {
            restorations.remove(p.getName());
            Scavenger.get().logDebug("Removing: " + p.getName());
        }
    }

    public static List<String> getWorldGroups(World world) {
        List worldGroupProfiles;
        GroupManager groupManager;
        MultiverseInventories multiInv;
        ArrayList<String> returnData = new ArrayList<String>();
        if (Scavenger.get().getMultiverseInventories() != null && (multiInv = Scavenger.get().getMultiverseInventories()).getGroupManager() != null && (groupManager = multiInv.getGroupManager()).getGroupsForWorld(world.getName()) != null && (worldGroupProfiles = groupManager.getGroupsForWorld(world.getName())) != null) {
            for (WorldGroupProfile i : worldGroupProfiles) {
                returnData.add(i.getName());
            }
        }
        if (Scavenger.get().getMultiInvInventories() != null) {
            String worldname = world.getName();
            MultiInvAPI multiInvAPI = Scavenger.get().getMultiInvInventories();
            if (multiInvAPI.getGroups() != null && multiInvAPI.getGroups().containsKey(worldname)) {
                returnData.add((String)multiInvAPI.getGroups().get(worldname));
            }
        }
        if (returnData.isEmpty()) {
            returnData.add("");
        }
        return returnData;
    }
}

