/*
 * Decompiled with CFR 0.152.
 */
package me.cnaude.plugin.Scavenger;

import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.MobArenaHandler;
import com.massivecraft.factions.P;
import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.orange451.UltimateArena.UltimateArenaAPI;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.timvisee.DungeonMaze.API.DungeonMazeAPI;
import com.timvisee.DungeonMaze.DungeonMaze;
import fr.areku.Authenticator.Authenticator;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.cnaude.plugin.Scavenger.RestorationManager;
import me.cnaude.plugin.Scavenger.ScavengerConfig;
import me.cnaude.plugin.Scavenger.ScavengerEventListenerOffline;
import me.cnaude.plugin.Scavenger.ScavengerEventListenerOnline;
import me.cnaude.plugin.Scavenger.ScavengerIgnoreList;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.economy.Economy;
import net.slipcor.pvparena.PVPArena;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.tggl.pluckerpluck.multiinv.MultiInv;
import uk.co.tggl.pluckerpluck.multiinv.MultiInvAPI;

public class Scavenger
extends JavaPlugin {
    public static final String PLUGIN_NAME = "Scavenger";
    public static final String LOG_HEADER = "[Scavenger]";
    private static Scavenger instance = null;
    private static Economy economy = null;
    public static MobArenaHandler maHandler;
    public static PVPArena pvpHandler;
    public static MultiverseInventories multiverseHandler;
    public static MultiInv multiinvHandler;
    public static DungeonMazeAPI dmHandler;
    public static RestorationManager rm;
    public static boolean battleArena;
    public static ScavengerIgnoreList ignoreList;
    public boolean configLoaded = false;
    static final Logger log;
    private static ScavengerConfig config;
    private final ScavengerEventListenerOffline eventListener = new ScavengerEventListenerOffline();
    private final ScavengerEventListenerOnline eventListenerOnline = new ScavengerEventListenerOnline();

    public static Scavenger get() {
        return instance;
    }

    public void onEnable() {
        if (!this.checkForProtocolLib()) {
            this.logError("This plugin requires ProtocolLib. Please download the latest: http://dev.bukkit.org/server-mods/protocollib/");
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            this.loadConfig();
            for (String s : Scavenger.getSConfig().blacklistedWorlds()) {
                Scavenger.get().logDebug("BlackListedWorld: " + s);
            }
            this.setupMobArenaHandler();
            this.setupPVPArenaHandler();
            this.checkForUltimateArena();
            this.checkForBattleArena();
            this.checkForWorldGuard();
            this.checkForFactions();
            this.checkForDungeonMaze();
            this.setupResidence();
            rm = new RestorationManager();
            rm.load();
            rm.load1();
            ignoreList = new ScavengerIgnoreList();
            ignoreList.load();
            if (Scavenger.getSConfig().offlineMode()) {
                Plugin p = Bukkit.getServer().getPluginManager().getPlugin("Authenticator");
                if (p != null) {
                    if (Authenticator.isUsingOfflineModePlugin()) {
                        this.getServer().getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)this);
                        this.logInfo("Hook to Authenticator's API and your auth plugin.");
                    } else {
                        this.logInfo("No Auth plugin detected. Set offline-mode to false or add an auth plugin.");
                        this.getServer().getPluginManager().registerEvents((Listener)this.eventListenerOnline, (Plugin)this);
                    }
                } else {
                    this.logInfo("Authenticator not detected. Set offline-mode to false or add Authenticator.");
                    this.getServer().getPluginManager().registerEvents((Listener)this.eventListenerOnline, (Plugin)this);
                }
            } else {
                this.getServer().getPluginManager().registerEvents((Listener)this.eventListenerOnline, (Plugin)this);
                this.logInfo("Offline-mode is set to false, no Authenticator Hook");
            }
        }
    }

    private void checkForWorldGuard() {
        if (this.getWorldGuard() != null && Scavenger.getSConfig().wgPVPIgnore()) {
            this.logInfo("WorldGuard detected. Scavenger will not recover items in PVP regions.");
        }
    }

    private void checkForUltimateArena() {
        if (this.getUltimateArena() != null) {
            this.logInfo("UltimateArena detected. Scavenger will not recover items in an arena.");
        }
    }

    private void checkForBattleArena() {
        Plugin baPlugin = this.getServer().getPluginManager().getPlugin("BattleArena");
        if (baPlugin != null) {
            battleArena = true;
            this.logInfo("BattleArena detected. Scavenger will not recover items in an arena.");
        }
    }

    private void checkForFactions() {
        if (this.getFactions() != null && Scavenger.getSConfig().factionEnemyDrops()) {
            this.logInfo("Factions detected. Players will drop items in enemy teritory!");
        }
    }

    private void checkForDungeonMaze() {
        if (this.getDungeonMaze() != null) {
            this.logInfo("DungeonMaze detected, drop item in the dungeon maze worlds configs.");
        }
    }

    public void onDisable() {
        if (this.checkForProtocolLib()) {
            rm.save();
            ignoreList.save();
        }
    }

    public Economy getEconomy() {
        return economy;
    }

    private Boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    public MultiverseInventories getMultiverseInventories() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("Multiverse-Inventories");
        if (plugin == null || !(plugin instanceof MultiverseInventories)) {
            return null;
        }
        return (MultiverseInventories)plugin;
    }

    public MultiInvAPI getMultiInvInventories() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("MultiInv");
        MultiInvAPI multiInvAPI = null;
        try {
            if (plugin instanceof MultiInv) {
                multiInvAPI = ((MultiInv)plugin).getAPI();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return multiInvAPI;
    }

    public P getFactions() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("Factions");
        if (plugin == null || !(plugin instanceof P)) {
            return null;
        }
        return (P)plugin;
    }

    public DungeonMaze getDungeonMaze() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("DungeonMaze");
        if (plugin == null && !(plugin instanceof DungeonMaze)) {
            return null;
        }
        return (DungeonMaze)plugin;
    }

    public boolean checkForProtocolLib() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("ProtocolLib");
        return plugin != null;
    }

    public void setupResidence() {
        if (Scavenger.getSConfig().residence()) {
            PluginManager pm = this.getServer().getPluginManager();
            Plugin p = pm.getPlugin("Residence");
            if (p != null) {
                if (!p.isEnabled()) {
                    this.logInfo("Manually enabling Residence!");
                    pm.enablePlugin(p);
                }
                this.logInfo("Adding '" + Scavenger.getSConfig().resFlag() + "' flag to Residence.");
                FlagPermissions.addResidenceOnlyFlag((String)Scavenger.getSConfig().resFlag());
                FlagPermissions.addFlag((String)Scavenger.getSConfig().resFlag());
            } else {
                this.logInfo("Residence NOT Installed!");
            }
        } else {
            this.logDebug("Residence support disabled via config.");
        }
    }

    public WorldGuardPlugin getWorldGuard() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }

    public void logInfo(String _message) {
        log.log(Level.INFO, String.format("%s %s", LOG_HEADER, _message));
    }

    public void logDebug(String _message) {
        if (Scavenger.getSConfig().debugEnabled()) {
            log.log(Level.INFO, String.format("%s [DEBUG] %s", LOG_HEADER, _message));
        }
    }

    public void logError(String _message) {
        log.log(Level.SEVERE, String.format("%s %s", LOG_HEADER, _message));
    }

    public static ScavengerConfig getSConfig() {
        return config;
    }

    void loadConfig() {
        if (!this.configLoaded) {
            this.getConfig().options().copyDefaults(true);
            this.saveConfig();
            this.logInfo("Configuration loaded.");
            config = new ScavengerConfig(this);
        } else {
            this.reloadConfig();
            this.getConfig().options().copyDefaults(false);
            config = new ScavengerConfig(this);
            this.logInfo("Configuration reloaded.");
        }
        if (config.economyEnabled()) {
            Plugin x = this.getServer().getPluginManager().getPlugin("Vault");
            if (x != null && x instanceof Vault) {
                if (this.setupEconomy().booleanValue()) {
                    this.logInfo("Scavenger has linked to " + economy.getName() + " through Vault");
                    if (Scavenger.getSConfig().percent()) {
                        if (Scavenger.getSConfig().addMin()) {
                            this.logInfo("Item recovery fee: " + Scavenger.getSConfig().percentCost() + "% + " + Scavenger.getSConfig().minCost());
                        } else {
                            this.logInfo("Item recovery fee: " + Scavenger.getSConfig().percentCost() + "% (Min: " + Scavenger.getSConfig().minCost() + ") (Max: " + Scavenger.getSConfig().maxCost() + ")");
                        }
                    } else {
                        this.logInfo("Item recovery fee: " + Scavenger.getSConfig().restoreCost());
                    }
                } else {
                    this.logError("Vault could not find an Economy plugin installed!");
                }
            } else {
                this.logInfo("Scavenger relies on Vault for economy support and Vault isn't installed!");
                this.logInfo("See http://dev.bukkit.org/server-mods/vault/");
                this.logInfo("If you don't want economy support, set 'Economy: Enabled' to false in Scavenger config.");
            }
        } else {
            this.logInfo("Economy disabled. Item recovery will be free.");
        }
        instance = this;
        this.configLoaded = true;
    }

    public UltimateArenaAPI getUltimateArena() {
        Plugin uaPlugin = this.getServer().getPluginManager().getPlugin("UltimateArena");
        if (uaPlugin == null) {
            return null;
        }
        return UltimateArenaAPI.hookIntoUA();
    }

    public void setupMobArenaHandler() {
        MobArena maPlugin = (MobArena)this.getServer().getPluginManager().getPlugin("MobArena");
        if (maPlugin == null) {
            return;
        }
        maHandler = new MobArenaHandler();
        this.logInfo("MobArena detected. Player inventory restores ignored inside arenas.");
    }

    public void setupPVPArenaHandler() {
        PVPArena pvpPlugin = (PVPArena)this.getServer().getPluginManager().getPlugin("pvparena");
        if (pvpPlugin == null) {
            return;
        }
        pvpHandler = PVPArena.instance;
        this.logInfo("PVPArena detected. Player inventory restores ignored inside arenas.");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandlabel, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (commandlabel.equalsIgnoreCase("scvr") || commandlabel.equalsIgnoreCase("scavengerreload")) {
                if (p.hasPermission("scavenger.reload") || p.isOp() && Scavenger.getSConfig().opsAllPerms()) {
                    this.loadConfig();
                    this.message(p, "Configuration reloaded.");
                } else {
                    this.message(p, "No permission to reload scavenger config!");
                }
            }
            if (commandlabel.equalsIgnoreCase("scvron")) {
                if (p.hasPermission("scavenger.self.on") || p.isOp() && Scavenger.getSConfig().opsAllPerms() || !Scavenger.getSConfig().permsEnabled()) {
                    ignoreList.removePlayer(sender.getName());
                    this.message(p, "You have enabled item recovery for yourself!");
                } else {
                    this.message(p, "No permission to do this!");
                }
            }
            if (commandlabel.equalsIgnoreCase("scvroff")) {
                if (p.hasPermission("scavenger.self.off") || p.isOp() && Scavenger.getSConfig().opsAllPerms() || !Scavenger.getSConfig().permsEnabled()) {
                    ignoreList.addPlayer(sender.getName());
                    this.message(p, "You have disabled item recovery for yourself!");
                } else {
                    this.message(p, "No permission to do this!");
                }
            }
            if (commandlabel.equalsIgnoreCase("scvrlist")) {
                if (p.hasPermission("scavenger.list") || p.isOp() && Scavenger.getSConfig().opsAllPerms() || !Scavenger.getSConfig().permsEnabled()) {
                    rm.printRestorations(p);
                } else {
                    this.message(p, "No permission to do this!");
                }
            }
        } else if (sender instanceof ConsoleCommandSender) {
            if (commandlabel.equalsIgnoreCase("scvr") || commandlabel.equalsIgnoreCase("scavengerreload")) {
                this.loadConfig();
            }
            if (commandlabel.equalsIgnoreCase("scvrlist")) {
                rm.printRestorations();
            }
        }
        return true;
    }

    private String headerStr() {
        ChatColor headerColor = Scavenger.getSConfig().headerColor();
        ChatColor textColor = Scavenger.getSConfig().textColor();
        if (Scavenger.getSConfig().msgHeader().isEmpty()) {
            return textColor + "[" + headerColor + PLUGIN_NAME + textColor + "] " + textColor;
        }
        return textColor + "[" + headerColor + Scavenger.getSConfig().msgHeader() + textColor + "] " + textColor;
    }

    public void message(Player p, String msg) {
        if (p instanceof Player) {
            msg = msg.replaceAll("%PLAYER%", p.getName());
            msg = msg.replaceAll("%DPLAYER%", p.getDisplayName());
            if (Scavenger.getSConfig().shouldNotify()) {
                p.sendMessage(this.headerStr() + msg);
            } else {
                this.logInfo(msg);
            }
        }
    }

    public void debugMessage(Player _player, String _message) {
        if (Scavenger.getSConfig().debugEnabled()) {
            if (_player != null) {
                _player.sendMessage(this.headerStr() + _message);
            } else {
                this.logDebug(_message);
            }
        }
    }

    public void debugMessage(String _message) {
        if (Scavenger.getSConfig().debugEnabled()) {
            this.logDebug(_message);
        }
    }

    public void error(Player _player, String _message) {
        if (_player != null && Scavenger.getSConfig().shouldNotify()) {
            _player.sendMessage(this.headerStr() + ChatColor.RED + "Error: " + _message);
        } else {
            this.logError(_message);
        }
    }

    static {
        battleArena = false;
        log = Logger.getLogger("Minecraft");
    }
}

