/*
 * Decompiled with CFR 0.152.
 */
package me.cnaude.plugin.Scavenger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.cnaude.plugin.Scavenger.Scavenger;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.yaml.snakeyaml.Yaml;

public final class ScavengerConfig {
    private final Configuration config;
    private static final String langDir = "plugins/Scavenger/Languages";
    private static final String SHOULD_NOTIFY = "Global.Notify";
    private static final String ECONOMY_ENABLED = "Economy.Enabled";
    private static final String ECONOMY_RESTORECOST = "Economy.RestoreCost";
    private static final String ECONOMY_PERCENT = "Economy.Percent";
    private static final String ECONOMY_MINCOST = "Economy.MinCost";
    private static final String ECONOMY_MAXCOST = "Economy.MaxCost";
    private static final String ECONOMY_PERCENTCOST = "Economy.PercentCost";
    private static final String ECONOMY_ADDMIN = "Economy.AddMin";
    private static final String ECONOMY_DROP_CHANCE = "Economy.ChanceToDrop";
    private static final String GLOBAL_COLOR = "Global.Color";
    private static final String GLOBAL_TEXTCOLOR = "Global.TextColor";
    private static final String DEBUG_ENABLED = "Global.Debug";
    private static final String GLOBAL_SIDROPS = "Global.SingleItemDrops";
    private static final String GLOBAL_SIDROPS_ONLY = "Global.SingleItemDropsOnly";
    private static final String GLOBAL_PERMS = "Global.Permissions";
    private static final String GLOBAL_WGPVPIGNORE = "Global.WorldGuardPVPIgnore";
    private static final String GLOBAL_WGPVPONLY = "Global.WorldGuardPVPOnly";
    private static final String GLOBAL_OPSALLPERMS = "Global.OpsAllPerms";
    private static final String GLOBAL_FACTIONENEMYDROPS = "Global.FactionEnemyDrops";
    private static final String GLOBAL_OFFLINEMODE = "Global.OfflineMode";
    private static final String GLOBAL_DUNGEONMAZE = "Global.DungeonMaze";
    private static final String GLOBAL_RESIDENCE = "Global.Residence";
    private static final String GLOBAL_RESFLAG = "Global.ResidenceFlag";
    private static final String GLOBAL_DROPONPVPDEATH = "Global.DropOnPVPDeath";
    private static final String GLOBAL_LANGUAGE = "Global.LanguageFile";
    private static final String BLACKLISTED_WORLDS = "BlacklistedWorlds";
    private static final String GLOBAL_SLOT_RECOVERY = "Global.SlotBasedRecovery";
    private static final String MSG_RECOVERED = "MsgRecovered";
    private static final String MSG_SAVING = "MsgSaving";
    private static final String MSG_SAVEFORFEE = "MsgSaveForFee";
    private static final String MSG_NOTENOUGHMONEY = "MsgNotEnoughMoney";
    private static final String MSG_INSIDEPA = "MsgInsidePA";
    private static final String MSG_INSIDEBA = "MsgInsideBA";
    private static final String MSG_INSIDEMA = "MsgInsideMA";
    private static final String MSG_INSIDEUA = "MsgInsideUA";
    private static final String MSG_INSIDEWGPVP = "MsgInsideWGPVP";
    private static final String MSG_INSIDEWGPVPONLY = "MsgInsideWGPVPOnly";
    private static final String MSG_HEADER = "MsgHeader";
    private static final String MSG_INSIDEENEMYFACTION = "MsgInsideEnemyFaction";
    private static final String MSG_INSIDEDUNGEONMAZE = "MsgInsideDungeonMaze";
    private static final String MSG_INSIDERES = "MsgInsideRes";
    private static final String MSG_PVPDEATH = "PVPDeath";
    private static final String MSG_HEADER_DEF = "Scavenger";
    private static final String MSG_RECOVERED_DEF = "Your inventory has been restored.";
    private static final String MSG_SAVING_DEF = "Saving your inventory.";
    private static final String MSG_SAVEFORFEE_DEF = "Saving your inventory for a small fee of %COST% %CURRENCY%.";
    private static final String MSG_NOTENOUGHMONEY_DEF = "Item recovery cost is %COST% and you only have %BALANCE% %CURRENCY%.";
    private static final String MSG_INSIDEPA_DEF = "You are inside PVP Arena %ARENA%. Scavenger will not save your inventory.";
    private static final String MSG_INSIDEBA_DEF = "You are inside a Battle Arena. Scavenger will not save your inventory.";
    private static final String MSG_INSIDEMA_DEF = "You are inside a Mob Arena. Scavenger will not save your inventory.";
    private static final String MSG_INSIDEUA_DEF = "You are inside an Ultimate Arena. Scavenger will not save your inventory.";
    private static final String MSG_INSIDEWGPVP_DEF = "You are inside WorldGuard PVP region. Scavenger will not save your inventory.";
    private static final String MSG_INSIDEWGPVPONLY_DEF = "You are not inside a WorldGuard PVP region. Scavenger will not save your inventory.";
    private static final String MSG_INSIDEENEMYFACTION_DEF = "You died in enemy territory. Your items will be dropped!";
    private static final String MSG_INSIDEDUNGEONMAZE_DEF = "You died in a DungeonMaze. Your items will be dropped!";
    private static final String MSG_INSIDERES_DEF = "This residence does not allow item recovery! Dropping items!";
    private static final String MSG_PVPDEATH_DEF = "Killed by another player! Dropping items.";
    private boolean shouldNotify;
    private double restoreCost;
    private boolean economyEnabled;
    private boolean debugEnabled;
    private boolean percent;
    private double minCost;
    private double maxCost;
    private double percentCost;
    private boolean addMin;
    private ChatColor headerColor;
    private ChatColor textColor;
    private boolean singleItemDrops;
    private boolean singleItemDropsOnly;
    private boolean permsEnabled;
    private String msgRecovered;
    private String msgSaving;
    private String msgSaveForFee;
    private String msgNotEnoughMoney;
    private String msgInsidePA;
    private String msgInsideBA;
    private String msgInsideMA;
    private String msgInsideUA;
    private boolean wgPVPIgnore;
    private boolean wgGuardPVPOnly;
    private String msgInsideWGPVP;
    private String msgInsideWGPVPOnly;
    private boolean opsAllPerms;
    private String msgHeader;
    private int chanceToDrop;
    private String msgInsideEnemyFaction;
    private String msgInsideDungeonMaze;
    private boolean factionEnemyDrops;
    private boolean offlineMode;
    private boolean dungeonMaze;
    private boolean residence;
    private String msgInsideRes;
    private String resFlag;
    private boolean dropOnPVPDeath;
    private String msgPVPDeath;
    private String languageFileName;
    private List<String> blacklistedworlds = new ArrayList<String>();
    private boolean slotBasedRecovery;

    public ScavengerConfig(Scavenger plug) {
        this.config = plug.getConfig();
        this.loadValues(plug);
    }

    public void loadValues(Scavenger plug) {
        this.debugEnabled = this.config.getBoolean(DEBUG_ENABLED, false);
        this.economyEnabled = this.config.getBoolean(ECONOMY_ENABLED, false);
        this.restoreCost = this.config.getDouble(ECONOMY_RESTORECOST, 10.0);
        this.percent = this.config.getBoolean(ECONOMY_PERCENT, false);
        this.minCost = this.config.getDouble(ECONOMY_MINCOST, 5.0);
        this.maxCost = this.config.getDouble(ECONOMY_MAXCOST, 0.0);
        this.percentCost = this.config.getDouble(ECONOMY_PERCENTCOST, 5.0);
        this.addMin = this.config.getBoolean(ECONOMY_ADDMIN, false);
        this.chanceToDrop = this.config.getInt(ECONOMY_DROP_CHANCE, 0);
        this.slotBasedRecovery = this.config.getBoolean(GLOBAL_SLOT_RECOVERY, false);
        this.shouldNotify = this.config.getBoolean(SHOULD_NOTIFY, true);
        this.singleItemDrops = this.config.getBoolean(GLOBAL_SIDROPS, false);
        this.singleItemDropsOnly = this.config.getBoolean(GLOBAL_SIDROPS_ONLY, false);
        this.permsEnabled = this.config.getBoolean(GLOBAL_PERMS, true);
        this.wgPVPIgnore = this.config.getBoolean(GLOBAL_WGPVPIGNORE, false);
        this.wgGuardPVPOnly = this.config.getBoolean(GLOBAL_WGPVPONLY, false);
        this.opsAllPerms = this.config.getBoolean(GLOBAL_OPSALLPERMS, true);
        this.factionEnemyDrops = this.config.getBoolean(GLOBAL_FACTIONENEMYDROPS, false);
        this.offlineMode = this.config.getBoolean(GLOBAL_OFFLINEMODE, false);
        this.dungeonMaze = this.config.getBoolean(GLOBAL_DUNGEONMAZE, false);
        this.residence = this.config.getBoolean(GLOBAL_RESIDENCE, false);
        this.resFlag = this.config.getString(GLOBAL_RESFLAG, "noscv");
        this.dropOnPVPDeath = this.config.getBoolean(GLOBAL_DROPONPVPDEATH, false);
        this.headerColor = ChatColor.valueOf((String)this.config.getString(GLOBAL_COLOR, "GOLD").toUpperCase());
        this.textColor = ChatColor.valueOf((String)this.config.getString(GLOBAL_TEXTCOLOR, "WHITE").toUpperCase());
        this.languageFileName = this.config.getString(GLOBAL_LANGUAGE, "English.yml");
        for (String s : this.config.getStringList(BLACKLISTED_WORLDS)) {
            this.blacklistedworlds.add(s.toLowerCase());
        }
        this.initLangFiles(plug);
        this.loadLanguage(plug);
    }

    private void initLangFiles(Scavenger plug) {
        File dataFolder = new File(langDir);
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        ArrayList<String> langFiles = new ArrayList<String>();
        langFiles.add("dutch.yml");
        langFiles.add("french.yml");
        langFiles.add("german.yml");
        langFiles.add("italian.yml");
        langFiles.add("korean.yml");
        langFiles.add("russian.yml");
        langFiles.add("portugues.yml");
        for (String fName : langFiles) {
            File file = new File("plugins/Scavenger/Languages/" + fName);
            if (file.exists()) continue;
            try {
                int len;
                InputStream in = Scavenger.class.getResourceAsStream("/me/cnaude/plugin/Scavenger/Languages/" + fName);
                byte[] buf = new byte[1024];
                FileOutputStream out = new FileOutputStream(file);
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                plug.logError(ex.getMessage());
            }
        }
    }

    private void loadLanguage(Scavenger plug) {
        boolean success = false;
        File file = new File("plugins/Scavenger/Languages/" + this.languageFileName);
        if (file.exists()) {
            Yaml yaml = new Yaml();
            try {
                plug.logInfo("Loading language file: " + file.getAbsolutePath());
                FileReader reader = new FileReader(file);
                Map map = (Map)yaml.load((Reader)reader);
                this.msgHeader = map.containsKey(MSG_HEADER) ? (String)map.get(MSG_HEADER) : this.config.getString("Messages.MsgHeader", MSG_HEADER_DEF);
                this.msgInsideEnemyFaction = map.containsKey(MSG_INSIDEENEMYFACTION) ? (String)map.get(MSG_INSIDEENEMYFACTION) : this.config.getString("Messages.MsgInsideEnemyFaction", MSG_INSIDEENEMYFACTION_DEF);
                this.msgInsideDungeonMaze = map.containsKey(MSG_INSIDEDUNGEONMAZE) ? (String)map.get(MSG_INSIDEDUNGEONMAZE) : this.config.getString("Messages.MsgInsideDungeonMaze", MSG_INSIDEDUNGEONMAZE_DEF);
                this.msgInsideRes = map.containsKey(MSG_INSIDERES) ? (String)map.get(MSG_INSIDERES) : this.config.getString("Messages.MsgInsideRes", MSG_INSIDERES_DEF);
                this.msgPVPDeath = map.containsKey(MSG_PVPDEATH) ? (String)map.get(MSG_PVPDEATH) : this.config.getString("Messages.PVPDeath", MSG_PVPDEATH_DEF);
                this.msgRecovered = map.containsKey(MSG_RECOVERED) ? (String)map.get(MSG_RECOVERED) : this.config.getString("Messages.MsgRecovered", MSG_RECOVERED_DEF);
                this.msgSaving = map.containsKey(MSG_SAVING) ? (String)map.get(MSG_SAVING) : this.config.getString("Messages.MsgSaving", MSG_SAVING_DEF);
                this.msgSaveForFee = map.containsKey(MSG_SAVEFORFEE) ? (String)map.get(MSG_SAVEFORFEE) : this.config.getString("Messages.MsgSaveForFee", MSG_SAVEFORFEE_DEF);
                this.msgNotEnoughMoney = map.containsKey(MSG_NOTENOUGHMONEY) ? (String)map.get(MSG_NOTENOUGHMONEY) : this.config.getString("Messages.MsgNotEnoughMoney", MSG_NOTENOUGHMONEY_DEF);
                this.msgInsidePA = map.containsKey(MSG_INSIDEPA) ? (String)map.get(MSG_INSIDEPA) : this.config.getString("Messages.MsgInsidePA", MSG_INSIDEPA_DEF);
                this.msgInsideBA = map.containsKey(MSG_INSIDEBA) ? (String)map.get(MSG_INSIDEBA) : this.config.getString("Messages.MsgInsideBA", MSG_INSIDEBA_DEF);
                this.msgInsideMA = map.containsKey(MSG_INSIDEMA) ? (String)map.get(MSG_INSIDEMA) : this.config.getString("Messages.MsgInsideMA", MSG_INSIDEMA_DEF);
                this.msgInsideUA = map.containsKey(MSG_INSIDEUA) ? (String)map.get(MSG_INSIDEUA) : this.config.getString("Messages.MsgInsideUA", MSG_INSIDEUA_DEF);
                this.msgInsideWGPVP = map.containsKey(MSG_INSIDEWGPVP) ? (String)map.get(MSG_INSIDEWGPVP) : this.config.getString("Messages.MsgInsideWGPVP", MSG_INSIDEWGPVP_DEF);
                this.msgInsideWGPVPOnly = map.containsKey(MSG_INSIDEWGPVPONLY) ? (String)map.get(MSG_INSIDEWGPVPONLY) : this.config.getString("Messages.MsgInsideWGPVPOnly", MSG_INSIDEWGPVPONLY_DEF);
                ((Reader)reader).close();
                success = true;
            }
            catch (Exception ex) {
                plug.logError("Error reading file: " + ex.getMessage());
                success = false;
            }
        }
        if (!success) {
            this.msgHeader = this.config.getString("Messages.MsgHeader", MSG_HEADER_DEF);
            this.msgInsideEnemyFaction = this.config.getString("Messages.MsgInsideEnemyFaction", MSG_INSIDEENEMYFACTION_DEF);
            this.msgInsideDungeonMaze = this.config.getString("Messages.MsgInsideDungeonMaze", MSG_INSIDEDUNGEONMAZE_DEF);
            this.msgInsideRes = this.config.getString("Messages.MsgInsideRes", MSG_INSIDERES_DEF);
            this.msgPVPDeath = this.config.getString("Messages.PVPDeath", MSG_PVPDEATH_DEF);
            this.msgRecovered = this.config.getString("Messages.MsgRecovered", MSG_RECOVERED_DEF);
            this.msgSaving = this.config.getString("Messages.MsgSaving", MSG_SAVING_DEF);
            this.msgSaveForFee = this.config.getString("Messages.MsgSaveForFee", MSG_SAVEFORFEE_DEF);
            this.msgNotEnoughMoney = this.config.getString("Messages.MsgNotEnoughMoney", MSG_NOTENOUGHMONEY_DEF);
            this.msgInsidePA = this.config.getString("Messages.MsgInsidePA", MSG_INSIDEPA_DEF);
            this.msgInsideBA = this.config.getString("Messages.MsgInsideBA", MSG_INSIDEBA_DEF);
            this.msgInsideMA = this.config.getString("Messages.MsgInsideMA", MSG_INSIDEMA_DEF);
            this.msgInsideUA = this.config.getString("Messages.MsgInsideUA", MSG_INSIDEUA_DEF);
            this.msgInsideWGPVP = this.config.getString("Messages.MsgInsideWGPVP", MSG_INSIDEWGPVP_DEF);
            this.msgInsideWGPVPOnly = this.config.getString("Messages.MsgInsideWGPVPOnly", MSG_INSIDEWGPVPONLY_DEF);
        }
    }

    public boolean shouldNotify() {
        return this.shouldNotify;
    }

    public double restoreCost() {
        return this.restoreCost;
    }

    public boolean economyEnabled() {
        return this.economyEnabled;
    }

    public boolean debugEnabled() {
        return this.debugEnabled;
    }

    public boolean percent() {
        return this.percent;
    }

    public boolean addMin() {
        return this.addMin;
    }

    public double minCost() {
        return this.minCost;
    }

    public double maxCost() {
        return this.maxCost;
    }

    public double percentCost() {
        return this.percentCost;
    }

    public ChatColor headerColor() {
        return this.headerColor;
    }

    public ChatColor textColor() {
        return this.textColor;
    }

    public boolean singleItemDrops() {
        return this.singleItemDrops;
    }

    public boolean singleItemDropsOnly() {
        return this.singleItemDropsOnly;
    }

    public boolean permsEnabled() {
        return this.permsEnabled;
    }

    public String msgRecovered() {
        return this.msgRecovered;
    }

    public String msgSaving() {
        return this.msgSaving;
    }

    public String msgSaveForFee() {
        return this.msgSaveForFee;
    }

    public String msgNotEnoughMoney() {
        return this.msgNotEnoughMoney;
    }

    public String msgInsidePA() {
        return this.msgInsidePA;
    }

    public String msgInsideBA() {
        return this.msgInsideBA;
    }

    public String msgInsideMA() {
        return this.msgInsideMA;
    }

    public String msgInsideUA() {
        return this.msgInsideUA;
    }

    public String msgInsideWGPVP() {
        return this.msgInsideWGPVP;
    }

    public String msgInsideWGPVPOnly() {
        return this.msgInsideWGPVPOnly;
    }

    public String msgHeader() {
        return this.msgHeader;
    }

    public boolean wgPVPIgnore() {
        return this.wgPVPIgnore;
    }

    public boolean wgGuardPVPOnly() {
        return this.wgGuardPVPOnly;
    }

    public boolean opsAllPerms() {
        return this.opsAllPerms;
    }

    public int chanceToDrop() {
        return this.chanceToDrop;
    }

    public String msgInsideEnemyFaction() {
        return this.msgInsideEnemyFaction;
    }

    public String msgInsideDungeonMaze() {
        return this.msgInsideDungeonMaze;
    }

    public boolean dungeonMazeDrops() {
        return this.dungeonMaze;
    }

    public boolean factionEnemyDrops() {
        return this.factionEnemyDrops;
    }

    public boolean offlineMode() {
        return this.offlineMode;
    }

    public boolean residence() {
        return this.residence;
    }

    public String msgInsideRes() {
        return this.msgInsideRes;
    }

    public String resFlag() {
        return this.resFlag;
    }

    public boolean dropOnPVPDeath() {
        return this.dropOnPVPDeath;
    }

    public String msgPVPDeath() {
        return this.msgPVPDeath;
    }

    public List<String> blacklistedWorlds() {
        return this.blacklistedworlds;
    }

    public boolean slotBasedRecovery() {
        return this.slotBasedRecovery;
    }
}

