/*
 * Decompiled with CFR 0.152.
 */
package me.cnaude.plugin.Scavenger;

import me.cnaude.plugin.Scavenger.RestorationManager;
import me.cnaude.plugin.Scavenger.Scavenger;
import me.cnaude.plugin.Scavenger.ScavengerIgnoreList;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class ScavengerEventListenerOnline
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        if (event.getEntity() instanceof Player && this.isScavengeAllowed(event.getEntity())) {
            RestorationManager.collect(event.getEntity(), event.getDrops(), (EntityDeathEvent)event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof Player && RestorationManager.hasRestoration(event.getPlayer())) {
            RestorationManager.enable(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        if (event.getPlayer() instanceof Player && RestorationManager.hasRestoration(event.getPlayer())) {
            RestorationManager.enable(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getPlayer() instanceof Player && RestorationManager.hasRestoration(event.getPlayer())) {
            RestorationManager.restore(event.getPlayer());
        }
    }

    private boolean isScavengeAllowed(Player player) {
        String dcString = "NULL";
        if (player.getLastDamageCause() != null && player.getLastDamageCause().getCause() != null) {
            dcString = player.getLastDamageCause().getCause().toString();
        }
        Scavenger.get().logDebug("Player: " + player + "World: " + player.getWorld().getName().toLowerCase() + " DamageCause: " + dcString);
        if (Scavenger.getSConfig().blacklistedWorlds().contains(player.getWorld().getName().toLowerCase())) {
            return false;
        }
        if (ScavengerIgnoreList.isIgnored(player.getName())) {
            return false;
        }
        if (!Scavenger.getSConfig().permsEnabled()) {
            return true;
        }
        if (player.hasPermission("scavenger.scavenge")) {
            return true;
        }
        if (player.hasPermission("scavenger.scavenge." + dcString)) {
            return true;
        }
        if (player.hasPermission("scavenger.inv")) {
            return true;
        }
        if (player.hasPermission("scavenger.armour")) {
            return true;
        }
        return player.isOp() && Scavenger.getSConfig().opsAllPerms();
    }
}

