/*
 * Decompiled with CFR 0.152.
 */
package me.cnaude.plugin.Scavenger;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import me.cnaude.plugin.Scavenger.Scavenger;

public class ScavengerIgnoreList
implements Serializable {
    private static ArrayList<String> ignoreList = new ArrayList();
    private static final String IGNORE_FILE = "plugins/Scavenger/ignores.ser";

    public void load() {
        File file = new File(IGNORE_FILE);
        if (!file.exists()) {
            Scavenger.get().logInfo("Ignore file '" + file.getAbsolutePath() + "' does not exist.");
            return;
        }
        try {
            FileInputStream f_in = new FileInputStream(file);
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            ignoreList = (ArrayList)obj_in.readObject();
            obj_in.close();
            Scavenger.get().logInfo("Loaded ignore list. (Count = " + ignoreList.size() + ")");
        }
        catch (Exception e) {
            Scavenger.get().logError(e.getMessage());
        }
    }

    public void save() {
        try {
            File file = new File(IGNORE_FILE);
            FileOutputStream f_out = new FileOutputStream(file);
            ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(ignoreList);
            obj_out.close();
            Scavenger.get().logInfo("Saved ignore list. (Count = " + ignoreList.size() + ")");
        }
        catch (Exception e) {
            Scavenger.get().logError(e.getMessage());
        }
    }

    public void addPlayer(String s) {
        if (ignoreList.contains(s)) {
            return;
        }
        Scavenger.get().logInfo("Adding " + s + " to ignore list.");
        ignoreList.add(s);
    }

    public void removePlayer(String s) {
        Scavenger.get().logInfo("Removing " + s + " from ignore list.");
        ignoreList.remove(s);
    }

    public static boolean isIgnored(String s) {
        return ignoreList.contains(s);
    }
}

